/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.hexfile;

import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.AddressedProgrammerManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.UserPreferencesManager;
import jmri.jmrit.XmlFile;
import jmri.jmrix.debugthrottle.DebugThrottleManager;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnSensorManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.hexfile.Bundle;
import jmri.jmrix.loconet.hexfile.LnHexFilePort;
import jmri.managers.DefaultProgrammerManager;
import jmri.progdebugger.DebugProgrammerManager;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexFileFrame
extends JmriJFrame
implements LocoNetListener {
    JButton openHexFileButton = new JButton();
    JButton filePauseButton = new JButton();
    JButton jButton1 = new JButton();
    JTextField delayField = new JTextField(5);
    JLabel jLabel1 = new JLabel();
    JCheckBox simReplyBox = new JCheckBox(Bundle.getMessage("SimReplyBox"));
    private int maxSlots = 10;
    private int slotsInUse = 0;
    final JFileChooser inputFileChooser = XmlFile.userFileChooser("Hex files", "hex");
    boolean connected = false;
    LnPacketizer packets = null;
    Thread sourceThread;
    private LnHexFilePort port = null;
    private static final Logger log = LoggerFactory.getLogger(HexFileFrame.class);

    @InvokeOnGuiThread
    public HexFileFrame() {
    }

    @Override
    @InvokeOnGuiThread
    public void initComponents() {
        if (this.port == null) {
            log.error("initComponents called before adapter has been set");
        }
        this.openHexFileButton.setText(Bundle.getMessage("OpenFile"));
        this.openHexFileButton.setVisible(true);
        this.openHexFileButton.setToolTipText(Bundle.getMessage("OpenFileTooltip"));
        this.filePauseButton.setText(Bundle.getMessage("ButtonPause"));
        this.filePauseButton.setVisible(true);
        this.filePauseButton.setToolTipText(Bundle.getMessage("ButtonPauseTooltip"));
        this.jButton1.setText(Bundle.getMessage("ButtonContinue"));
        this.jButton1.setVisible(true);
        this.jButton1.setToolTipText(Bundle.getMessage("ButtonContinueTooltip"));
        this.delayField.setText("200");
        this.delayField.setVisible(true);
        this.delayField.setToolTipText(Bundle.getMessage("DelayTooltip"));
        this.jLabel1.setText(Bundle.getMessage("FieldDelay"));
        this.jLabel1.setVisible(true);
        this.simReplyBox.setToolTipText(Bundle.getMessage("SimReplyTip"));
        this.setTitle(Bundle.getMessage("TitleLocoNetSimulator", this.getAdapter().getUserName()));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        pane1.add(this.openHexFileButton);
        pane1.add(new JPanel());
        this.getContentPane().add(pane1);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new BoxLayout(pane2, 0));
        pane2.add(this.jLabel1);
        pane2.add(this.delayField);
        this.getContentPane().add(pane2);
        JPanel pane3 = new JPanel();
        pane3.setLayout(new BoxLayout(pane3, 0));
        pane3.add(this.filePauseButton);
        pane3.add(this.jButton1);
        this.getContentPane().add(pane3);
        JPanel pane4 = new JPanel();
        pane4.add(this.simReplyBox);
        this.getContentPane().add(pane4);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> {
            this.simReplyBox.setSelected(prefMgr.getSimplePreferenceState("simReply"));
            this.port.simReply(this.simReplyBox.isSelected());
        });
        this.openHexFileButton.addActionListener(this::openHexFileButtonActionPerformed);
        this.filePauseButton.addActionListener(this::filePauseButtonActionPerformed);
        this.jButton1.addActionListener(this::jButton1ActionPerformed);
        this.delayField.addActionListener(this::delayFieldActionPerformed);
        this.simReplyBox.addActionListener(this::simReplyActionPerformed);
        this.pack();
    }

    @Override
    @InvokeOnGuiThread
    public void dispose() {
        super.dispose();
    }

    @InvokeOnGuiThread
    public void openHexFileButtonActionPerformed(ActionEvent e) {
        this.inputFileChooser.rescanCurrentDirectory();
        int retVal = this.inputFileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.port.load(this.inputFileChooser.getSelectedFile());
        this.sourceThread.interrupt();
    }

    @InvokeOnGuiThread
    public void configure() {
        if (this.port == null) {
            log.error("configure called before adapter has been set");
            return;
        }
        this.packets = new LnPacketizer(this.port.getSystemConnectionMemo());
        this.packets.connectPort(this.port);
        this.connected = true;
        this.port.getSystemConnectionMemo().setLnTrafficController(this.packets);
        this.port.getSystemConnectionMemo().configureCommandStation(LnCommandStationType.COMMAND_STATION_DCS100, false, false, false);
        this.port.getSystemConnectionMemo().configureManagers();
        LnSensorManager sm = this.port.getSystemConnectionMemo().getSensorManager();
        if (sm != null) {
            if (sm instanceof jmri.jmrix.loconet.hexfile.LnSensorManager) {
                ((jmri.jmrix.loconet.hexfile.LnSensorManager)sm).setDefaultSensorState(this.port.getOptionState("SensorDefaultState"));
            } else {
                log.info("SensorManager referenced by port is not an LnSensorManager. Have not set the default sensor state.");
            }
        }
        try {
            this.maxSlots = Integer.parseInt(this.port.getOptionState("MaxSlots"));
        }
        catch (NumberFormatException numberFormatException) {}
        log.debug("HexFileFrame called");
        DefaultProgrammerManager ep = this.port.getSystemConnectionMemo().getProgrammerManager();
        this.port.getSystemConnectionMemo().setProgrammerManager(new DebugProgrammerManager(this.port.getSystemConnectionMemo()));
        if (this.port.getSystemConnectionMemo().getProgrammerManager().isAddressedModePossible()) {
            log.debug("replacing AddressedProgrammer in Hex");
            InstanceManager.store(this.port.getSystemConnectionMemo().getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.port.getSystemConnectionMemo().getProgrammerManager().isGlobalProgrammerAvailable()) {
            log.debug("replacing GlobalProgrammer in Hex");
            InstanceManager.store(this.port.getSystemConnectionMemo().getProgrammerManager(), GlobalProgrammerManager.class);
        }
        InstanceManager.deregister(ep, AddressedProgrammerManager.class);
        InstanceManager.deregister(ep, GlobalProgrammerManager.class);
        DebugThrottleManager tm = new DebugThrottleManager(this.port.getSystemConnectionMemo()){

            @Override
            public boolean canBeLongAddress(int address) {
                return address >= 128;
            }

            @Override
            public void requestThrottleSetup(LocoAddress a, boolean control) {
                if (!(a instanceof DccLocoAddress)) {
                    log.error("{} is not a DccLocoAddress", (Object)a);
                    this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
                    return;
                }
                DccLocoAddress address = (DccLocoAddress)a;
                if (HexFileFrame.this.slotsInUse >= HexFileFrame.this.maxSlots) {
                    log.warn("SLOT MAX of {} reached. Throttle {} not added. Current slotsInUse={}", new Object[]{HexFileFrame.this.maxSlots, a, HexFileFrame.this.slotsInUse});
                    this.failedThrottleRequest(address, "SLOT MAX of " + HexFileFrame.this.maxSlots + " reached");
                    return;
                }
                HexFileFrame hexFileFrame = HexFileFrame.this;
                hexFileFrame.slotsInUse = hexFileFrame.slotsInUse + 1;
                log.debug("Throttle {} requested. slotsInUse={}, maxSlots={}", new Object[]{a, HexFileFrame.this.slotsInUse, HexFileFrame.this.maxSlots});
                super.requestThrottleSetup(a, control);
            }

            @Override
            public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
                if (HexFileFrame.this.slotsInUse > 0) {
                    HexFileFrame hexFileFrame = HexFileFrame.this;
                    hexFileFrame.slotsInUse = hexFileFrame.slotsInUse - 1;
                }
                log.debug("Throttle {} disposed. slotsInUse={}, maxSlots={}", new Object[]{t, HexFileFrame.this.slotsInUse, HexFileFrame.this.maxSlots});
                return super.disposeThrottle(t, l);
            }
        };
        this.port.getSystemConnectionMemo().setThrottleManager(tm);
        InstanceManager.setThrottleManager(this.port.getSystemConnectionMemo().getThrottleManager());
        this.port.getSystemConnectionMemo().getLnTrafficController().addLocoNetListener(-1, this);
        this.packets.startThreads();
        this.sourceThread = new Thread((Runnable)this.port, "LocoNet HexFileFrame");
        this.sourceThread.start();
    }

    public void filePauseButtonActionPerformed(ActionEvent e) {
        this.port.suspendReading(true);
    }

    public void jButton1ActionPerformed(ActionEvent e) {
        this.port.suspendReading(false);
    }

    public void delayFieldActionPerformed(ActionEvent e) {
        if (this.port != null) {
            this.port.setDelay(Integer.parseInt(this.delayField.getText()));
        }
    }

    @Override
    public synchronized void message(LocoNetMessage m) {
        LocoNetMessage reply;
        if (this.port.simReply() && (reply = LnHexFilePort.generateReply(m)) != null) {
            this.packets.sendLocoNetMessage(reply);
        }
    }

    public void setAdapter(LnHexFilePort adapter) {
        this.port = adapter;
    }

    public LnHexFilePort getAdapter() {
        return this.port;
    }

    public void simReplyActionPerformed(ActionEvent e) {
        this.port.simReply(this.simReplyBox.isSelected());
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState("simReply", this.simReplyBox.isSelected()));
    }
}

