/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.duplexgroup.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetException;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.duplexgroup.DuplexGroupMessageType;
import jmri.jmrix.loconet.duplexgroup.swing.LnIPLImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnDplxGrpInfoImpl
extends JComponent
implements LocoNetListener {
    private static final boolean limitPasswordToNumericCharacters = false;
    private LocoNetSystemConnectionMemo memo;
    private Integer numUr92;
    private Timer swingTmrIplQuery;
    private Timer swingTmrDuplexInfoQuery;
    private boolean waitingForIplReply;
    private boolean gotQueryReply;
    private int messagesHandled;
    LnDplxGrpInfoImpl thisone = this;
    private boolean awaitingGroupReadReport;
    private String acceptedGroupName;
    private String acceptedGroupChannel;
    private String acceptedGroupPassword;
    private String acceptedGroupId;
    public static final String DPLX_PC_STAT_LN_UPDATE = "DPLXPCK_STAT_LN_UPDATE";
    public static final String DPLX_PC_STAT_LN_UPDATE_IF_NOT_CURRENTLY_ERROR = "DPLXPCK_STAT_LN_ON_OVER_UPDATE";
    public static final String DPLX_PC_NAME_VALIDITY = "DPLXPCK_NAME_VALID";
    public static final String DPLX_PC_CHANNEL_VALIDITY = "DPLXPCK_CH_VALID";
    public static final String DPLX_PC_PASSWORD_VALIDITY = "DPLXPCK_PW_VALID";
    public static final String DPLX_PC_ID_VALIDITY = "DPLXPCK_ID_VALID";
    public static final String DPLX_PC_NAME_UPDATE = "DPLXPCK_NAME_UPDATE";
    public static final String DPLX_PC_CHANNEL_UPDATE = "DPLXPCK_CH_UPDATE";
    public static final String DPLX_PC_PASSWORD_UPDATE = "DPLXPCK_PW_UPDATE";
    public static final String DPLX_PC_ID_UPDATE = "DPLXPCK_ID_UPDATE";
    public static final String DPLX_PC_RCD_DPLX_IDENTITY_QUERY = "DPLXPCK_IDENTITY_QUERY";
    public static final String DPLX_PC_RCD_DPLX_IDENTITY_REPORT = "DPLXPCK_IDENTITY_REPORT";
    private static final Logger log = LoggerFactory.getLogger(LnDplxGrpInfoImpl.class);

    public LnDplxGrpInfoImpl(LocoNetSystemConnectionMemo LNCMemo) {
        this.memo = LNCMemo;
        this.messagesHandled = 0;
        this.connect(this.memo.getLnTrafficController());
        this.numUr92 = 0;
        this.waitingForIplReply = false;
        this.swingTmrIplQuery = new Timer(1300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LnDplxGrpInfoImpl.this.swingTmrIplQuery.stop();
                LnDplxGrpInfoImpl.this.waitingForIplReply = false;
                int oldvalue = 9999;
                int newvalue = 0;
                if (LnDplxGrpInfoImpl.this.numUr92 > 0) {
                    newvalue = LnDplxGrpInfoImpl.this.numUr92;
                    LnDplxGrpInfoImpl.this.thisone.firePropertyChange("NumberOfUr92sUpdate", oldvalue, newvalue);
                    LnDplxGrpInfoImpl.this.invalidateDataAndQueryDuplexInfo();
                } else {
                    LnDplxGrpInfoImpl.this.thisone.firePropertyChange("NumberOfUr92sUpdate", oldvalue, newvalue);
                    LnDplxGrpInfoImpl.this.thisone.firePropertyChange(LnDplxGrpInfoImpl.DPLX_PC_STAT_LN_UPDATE, " ", "ErrorNoUR92Found");
                }
            }
        });
        this.swingTmrDuplexInfoQuery = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LnDplxGrpInfoImpl.this.swingTmrDuplexInfoQuery.stop();
                LnDplxGrpInfoImpl.this.waitingForIplReply = false;
                if (LnDplxGrpInfoImpl.this.gotQueryReply) {
                    LnDplxGrpInfoImpl.this.thisone.firePropertyChange(LnDplxGrpInfoImpl.DPLX_PC_STAT_LN_UPDATE_IF_NOT_CURRENTLY_ERROR, "", " ");
                    LnDplxGrpInfoImpl.this.gotQueryReply = false;
                } else {
                    LnDplxGrpInfoImpl.this.thisone.firePropertyChange(LnDplxGrpInfoImpl.DPLX_PC_STAT_LN_UPDATE, " ", "ErrorNoQueryResponse");
                    LnDplxGrpInfoImpl.this.numUr92 = 0;
                    int oldvalue = 9999;
                    int newvalue = 0;
                    LnDplxGrpInfoImpl.this.thisone.firePropertyChange("NumberOfUr92sUpdate", oldvalue, newvalue);
                }
            }
        });
        this.acceptedGroupName = "";
        this.acceptedGroupChannel = "";
        this.acceptedGroupPassword = "";
        this.acceptedGroupId = "";
    }

    public static final boolean isPasswordLimitedToNumbers() {
        return false;
    }

    public static final boolean validateGroupName(String sGroupName) {
        return sGroupName.length() == 8;
    }

    public static final boolean validateGroupPassword(String sGroupPassword) {
        if (sGroupPassword.length() == 0) {
            return false;
        }
        return sGroupPassword.matches("^[0-9A-C][0-9A-C][0-9A-C][0-9A-C]$");
    }

    public static final boolean validateGroupChannel(Integer iGroupChannel) {
        return iGroupChannel >= 11 && iGroupChannel <= 26;
    }

    public static final boolean validateGroupID(Integer iGroupId) {
        return iGroupId >= 0 && iGroupId <= 127;
    }

    public static final LocoNetMessage createUr92GroupIdentityQueryPacket() {
        Integer i;
        LocoNetMessage m = new LocoNetMessage(20);
        Integer n = i = Integer.valueOf(0);
        i = n + 1;
        m.setElement(n, 229);
        Integer n2 = i;
        i = n2 + 1;
        m.setElement(n2, 20);
        Integer n3 = i;
        i = n3 + 1;
        m.setElement(n3, 3);
        Integer n4 = i;
        i = n4 + 1;
        m.setElement(n4, 8);
        while (i < 19) {
            m.setElement(i, 0);
            i = i + 1;
        }
        return m;
    }

    public static final LocoNetMessage createSetUr92GroupNamePacket(String sGroupName) throws LocoNetException {
        int gr_msb1 = 0;
        int gr_msb2 = 0;
        if (!LnDplxGrpInfoImpl.validateGroupName(sGroupName)) {
            throw new LocoNetException("Invalid Duplex Group Name - must be exactly 8 characters");
        }
        LocoNetMessage m = new LocoNetMessage(20);
        gr_msb1 += Character.valueOf(sGroupName.charAt(0)).charValue() > '\u007f' ? 1 : 0;
        gr_msb1 += Character.valueOf(sGroupName.charAt(1)).charValue() > '\u007f' ? 2 : 0;
        gr_msb1 += Character.valueOf(sGroupName.charAt(2)).charValue() > '\u007f' ? 4 : 0;
        gr_msb1 += Character.valueOf(sGroupName.charAt(3)).charValue() > '\u007f' ? 8 : 0;
        gr_msb2 += Character.valueOf(sGroupName.charAt(4)).charValue() > '\u007f' ? 1 : 0;
        gr_msb2 += Character.valueOf(sGroupName.charAt(5)).charValue() > '\u007f' ? 2 : 0;
        gr_msb2 += Character.valueOf(sGroupName.charAt(6)).charValue() > '\u007f' ? 4 : 0;
        gr_msb2 += Character.valueOf(sGroupName.charAt(7)).charValue() > '\u007f' ? 8 : 0;
        int i = 0;
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 3);
        m.setElement(i++, 0);
        m.setElement(i++, gr_msb1);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(0)).charValue() & 0x7F);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(1)).charValue() & 0x7F);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(2)).charValue() & 0x7F);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(3)).charValue() & 0x7F);
        m.setElement(i++, gr_msb2);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(4)).charValue() & 0x7F);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(5)).charValue() & 0x7F);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(6)).charValue() & 0x7F);
        m.setElement(i++, Character.valueOf(sGroupName.charAt(7)).charValue() & 0x7F);
        while (i < 19) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    public static final LocoNetMessage createSetUr92GroupChannelPacket(Integer iChannelNumber) throws LocoNetException {
        if (!LnDplxGrpInfoImpl.validateGroupChannel(iChannelNumber)) {
            throw new LocoNetException("Invalid Duplex Group Channel - must be between 11 and 26, inclusive");
        }
        LocoNetMessage m = new LocoNetMessage(20);
        int i = 0;
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 2);
        m.setElement(i++, 0);
        m.setElement(i++, 0);
        m.setElement(i++, iChannelNumber);
        while (i < 19) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    public static final LocoNetMessage createSetUr92GroupPasswordPacket(String sGroupPassword) throws LocoNetException {
        int gr_p1 = sGroupPassword.toUpperCase().charAt(0);
        int gr_p2 = sGroupPassword.toUpperCase().charAt(1);
        int gr_p3 = sGroupPassword.toUpperCase().charAt(2);
        int gr_p4 = sGroupPassword.toUpperCase().charAt(3);
        if (!LnDplxGrpInfoImpl.validateGroupPassword(sGroupPassword)) {
            if (LnDplxGrpInfoImpl.isPasswordLimitedToNumbers()) {
                throw new LocoNetException("Invalid Duplex Group Password - must be a 4 digit number between 0000 and 9999, inclusive");
            }
            throw new LocoNetException("Invalid Duplex Group Password - must be a 4 character value using only digits, 'A', 'B', and/or 'C'");
        }
        gr_p1 -= gr_p1 > 57 ? 7 : 0;
        gr_p2 -= gr_p2 > 57 ? 7 : 0;
        gr_p3 -= gr_p3 > 57 ? 7 : 0;
        gr_p4 -= gr_p4 > 57 ? 7 : 0;
        LocoNetMessage m = new LocoNetMessage(20);
        int i = 0;
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 7);
        m.setElement(i++, 0);
        m.setElement(i++, 0);
        m.setElement(i++, gr_p1);
        m.setElement(i++, gr_p2);
        m.setElement(i++, gr_p3);
        m.setElement(i++, gr_p4);
        while (i < 19) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    public static final LocoNetMessage createSetUr92GroupIDPacket(String s) throws LocoNetException {
        int gr_id = Integer.parseInt(s, 10);
        if (gr_id >= 0 && gr_id <= 127) {
            int i = 0;
            LocoNetMessage m = new LocoNetMessage(20);
            m.setElement(i++, 229);
            m.setElement(i++, 20);
            m.setElement(i++, 4);
            m.setElement(i++, 0);
            m.setElement(i++, 0);
            m.setElement(i++, gr_id);
            while (i < 19) {
                m.setElement(i, 0);
                ++i;
            }
            return m;
        }
        throw new LocoNetException("Illegal Duplex Group ID number");
    }

    public static final boolean isDuplexGroupMessage(LocoNetMessage m) {
        Integer byte3;
        Integer byte2;
        return !(m.getOpCode() != 229 || m.getElement(1) != 20 || (byte2 = Integer.valueOf(m.getElement(2))) != 2 && byte2 != 3 && byte2 != 4 && byte2 != 7 || (byte3 = Integer.valueOf(m.getElement(3))) != 8 && byte3 != 16 && byte3 != 0);
    }

    public static final DuplexGroupMessageType getDuplexGroupIdentityMessageType(LocoNetMessage m) {
        if (m.getOpCode() == 229 && m.getElement(1) == 20) {
            Integer byte3 = m.getElement(3);
            switch (m.getElement(2)) {
                case 2: {
                    return byte3 == 8 ? DuplexGroupMessageType.DUPLEX_GROUP_CHANNEL_QUERY_MESSAGE : (byte3 == 16 ? DuplexGroupMessageType.DUPLEX_GROUP_CHANNEL_REPORT_MESSAGE : (byte3 == 0 ? DuplexGroupMessageType.DUPLEX_GROUP_CHANNEL_WRITE_MESSAGE : DuplexGroupMessageType.NOT_A_DUPLEX_GROUP_MESSAGE));
                }
                case 3: {
                    return byte3 == 8 ? DuplexGroupMessageType.DUPLEX_GROUP_NAME_QUERY_MESSAGE : (byte3 == 16 ? DuplexGroupMessageType.DUPLEX_GROUP_NAME_ETC_REPORT_MESSAGE : (byte3 == 0 ? DuplexGroupMessageType.DUPLEX_GROUP_NAME_WRITE_MESSAGE : DuplexGroupMessageType.NOT_A_DUPLEX_GROUP_MESSAGE));
                }
                case 7: {
                    return byte3 == 8 ? DuplexGroupMessageType.DUPLEX_GROUP_PASSWORD_QUERY_MESSAGE : (byte3 == 16 ? DuplexGroupMessageType.DUPLEX_GROUP_PASSWORD_REPORT_MESSAGE : (byte3 == 0 ? DuplexGroupMessageType.DUPLEX_GROUP_PASSWORD_WRITE_MESSAGE : DuplexGroupMessageType.NOT_A_DUPLEX_GROUP_MESSAGE));
                }
                case 4: {
                    return byte3 == 8 ? DuplexGroupMessageType.DUPLEX_GROUP_ID_QUERY_MESSAGE : (byte3 == 16 ? DuplexGroupMessageType.DUPLEX_GROUP_ID_REPORT_MESSAGE : (byte3 == 0 ? DuplexGroupMessageType.DUPLEX_GROUP_ID_WRITE_MESSAGE : DuplexGroupMessageType.NOT_A_DUPLEX_GROUP_MESSAGE));
                }
            }
            return DuplexGroupMessageType.NOT_A_DUPLEX_GROUP_MESSAGE;
        }
        return DuplexGroupMessageType.NOT_A_DUPLEX_GROUP_MESSAGE;
    }

    public static String extractDuplexGroupName(LocoNetMessage m) {
        switch (LnDplxGrpInfoImpl.getDuplexGroupIdentityMessageType(m)) {
            case DUPLEX_GROUP_NAME_ETC_REPORT_MESSAGE: 
            case DUPLEX_GROUP_NAME_WRITE_MESSAGE: {
                return LnDplxGrpInfoImpl.extractGroupName(m);
            }
        }
        return null;
    }

    private static String extractGroupName(LocoNetMessage m) {
        StringBuilder gr_name = new StringBuilder();
        int gr_msb1 = m.getElement(4) & 0x7F;
        int gr_msb2 = m.getElement(9) & 0x7F;
        gr_name.append(Character.toString((char)((m.getElement(5) & 0x7F) + ((gr_msb1 & 1) << 7))));
        gr_name.append(Character.toString((char)((m.getElement(6) & 0x7F) + ((gr_msb1 & 2) << 6))));
        gr_name.append(Character.toString((char)((m.getElement(7) & 0x7F) + ((gr_msb1 & 4) << 5))));
        gr_name.append(Character.toString((char)((m.getElement(8) & 0x7F) + ((gr_msb1 & 8) << 4))));
        gr_name.append(Character.toString((char)((m.getElement(10) & 0x7F) + ((gr_msb2 & 1) << 7))));
        gr_name.append(Character.toString((char)((m.getElement(11) & 0x7F) + ((gr_msb2 & 2) << 6))));
        gr_name.append(Character.toString((char)((m.getElement(12) & 0x7F) + ((gr_msb2 & 4) << 5))));
        gr_name.append(Character.toString((char)((m.getElement(13) & 0x7F) + ((gr_msb2 & 8) << 4))));
        return gr_name.toString();
    }

    public static int extractDuplexGroupChannel(LocoNetMessage m) {
        switch (LnDplxGrpInfoImpl.getDuplexGroupIdentityMessageType(m)) {
            case DUPLEX_GROUP_NAME_ETC_REPORT_MESSAGE: {
                return m.getElement(17) + ((m.getElement(14) & 4) == 4 ? 128 : 0);
            }
            case DUPLEX_GROUP_CHANNEL_REPORT_MESSAGE: 
            case DUPLEX_GROUP_CHANNEL_WRITE_MESSAGE: {
                return m.getElement(5) + ((m.getElement(4) & 1) == 1 ? 128 : 0);
            }
        }
        return -1;
    }

    public static int extractDuplexGroupID(LocoNetMessage m) {
        switch (LnDplxGrpInfoImpl.getDuplexGroupIdentityMessageType(m)) {
            case DUPLEX_GROUP_NAME_ETC_REPORT_MESSAGE: {
                return m.getElement(18) + ((m.getElement(14) & 8) == 8 ? 128 : 0);
            }
            case DUPLEX_GROUP_ID_REPORT_MESSAGE: 
            case DUPLEX_GROUP_ID_WRITE_MESSAGE: {
                return m.getElement(5) + ((m.getElement(4) & 1) == 1 ? 128 : 0);
            }
        }
        return -1;
    }

    public static String extractDuplexGroupPassword(LocoNetMessage m) {
        switch (LnDplxGrpInfoImpl.getDuplexGroupIdentityMessageType(m)) {
            case DUPLEX_GROUP_NAME_ETC_REPORT_MESSAGE: {
                return LnDplxGrpInfoImpl.extractDuplexGroupPasswordSimplified((m.getElement(15) & 0x70) >> 4, m.getElement(15) & 0xF, (m.getElement(16) & 0x70) >> 4, m.getElement(16) & 0xF, (m.getElement(14) & 1) == 1, false, (m.getElement(14) & 2) == 2, false);
            }
            case DUPLEX_GROUP_PASSWORD_REPORT_MESSAGE: 
            case DUPLEX_GROUP_PASSWORD_WRITE_MESSAGE: {
                return LnDplxGrpInfoImpl.extractDuplexGroupPasswordSimplified(m.getElement(5) & 0xF, m.getElement(6) & 0xF, m.getElement(7) & 0xF, m.getElement(8) & 0xF, false, false, false, false);
            }
        }
        return null;
    }

    private static String extractDuplexGroupPasswordSimplified(Integer byte1, Integer byte2, Integer byte3, Integer byte4, boolean x1, boolean x2, boolean x3, boolean x4) {
        Integer b1 = byte1 + (x1 ? 8 : 0);
        Integer b2 = byte2 + (x2 ? 8 : 0);
        Integer b3 = byte3 + (x3 ? 8 : 0);
        Integer b4 = byte4 + (x4 ? 8 : 0);
        char gr_p1 = (char)(48 + b1);
        gr_p1 = (char)(gr_p1 + (gr_p1 > '9' ? 7 : 0));
        char gr_p2 = (char)(48 + b2);
        gr_p2 = (char)(gr_p2 + (gr_p2 > '9' ? 7 : 0));
        char gr_p3 = (char)(48 + b3);
        gr_p3 = (char)(gr_p3 + (gr_p3 > '9' ? 7 : 0));
        char gr_p4 = (char)(48 + b4);
        gr_p4 = (char)(gr_p4 + (gr_p4 > '9' ? 7 : 0));
        return "" + gr_p1 + gr_p2 + gr_p3 + gr_p4;
    }

    @Override
    public void message(LocoNetMessage m) {
        ++this.messagesHandled;
        if (this.handleMessageIplResult(m)) {
            return;
        }
        if (this.handleMessageDuplexInfoQuery(m)) {
            this.gotQueryReply = true;
            this.thisone.firePropertyChange(DPLX_PC_RCD_DPLX_IDENTITY_QUERY, false, true);
            return;
        }
        if (this.handleMessageDuplexInfoReport(m)) {
            this.gotQueryReply = true;
            this.thisone.firePropertyChange(DPLX_PC_RCD_DPLX_IDENTITY_REPORT, false, true);
            return;
        }
    }

    public String getFetchedDuplexGroupName() {
        return this.acceptedGroupName;
    }

    public String getFetchedDuplexGroupChannel() {
        return this.acceptedGroupChannel;
    }

    public String getFetchedDuplexGroupPassword() {
        return this.acceptedGroupPassword;
    }

    public String getFetchedDuplexGroupId() {
        return this.acceptedGroupId;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="False positive on the implied local variable in numUr92++")
    private boolean handleMessageIplResult(LocoNetMessage m) {
        if (LnIPLImplementation.isIplUr92IdentityReportMessage(m)) {
            this.numUr92 = this.numUr92 + 1;
            this.thisone.firePropertyChange(DPLX_PC_STAT_LN_UPDATE, "", " ");
            this.waitingForIplReply = false;
            return true;
        }
        return false;
    }

    private boolean handleMessageDuplexInfoQuery(LocoNetMessage m) {
        return LnDplxGrpInfoImpl.getDuplexGroupIdentityMessageType(m) == DuplexGroupMessageType.DUPLEX_GROUP_NAME_QUERY_MESSAGE;
    }

    private boolean handleMessageDuplexInfoReport(LocoNetMessage m) {
        String gr_name = "";
        String gr_password = "";
        if (LnDplxGrpInfoImpl.getDuplexGroupIdentityMessageType(m) == DuplexGroupMessageType.DUPLEX_GROUP_NAME_ETC_REPORT_MESSAGE) {
            gr_name = LnDplxGrpInfoImpl.extractDuplexGroupName(m);
            int i = gr_name.length() - 1;
            while (gr_name.charAt(i) == ' ' && i > 0) {
                gr_name = gr_name.substring(0, i);
                --i;
            }
            gr_password = LnDplxGrpInfoImpl.extractDuplexGroupPassword(m);
            int gr_ch = LnDplxGrpInfoImpl.extractDuplexGroupChannel(m);
            int gr_id = LnDplxGrpInfoImpl.extractDuplexGroupID(m);
            if (this.awaitingGroupReadReport) {
                this.awaitingGroupReadReport = false;
                this.acceptedGroupName = gr_name;
                this.acceptedGroupChannel = Integer.toString(gr_ch, 10);
                this.acceptedGroupPassword = gr_password;
                this.acceptedGroupId = Integer.toString(gr_id, 10);
                this.thisone.firePropertyChange(DPLX_PC_NAME_UPDATE, false, true);
                this.thisone.firePropertyChange(DPLX_PC_CHANNEL_UPDATE, false, true);
                this.thisone.firePropertyChange(DPLX_PC_PASSWORD_UPDATE, false, true);
                this.thisone.firePropertyChange(DPLX_PC_ID_UPDATE, false, true);
                this.thisone.firePropertyChange(DPLX_PC_NAME_VALIDITY, false, true);
                this.thisone.firePropertyChange(DPLX_PC_CHANNEL_VALIDITY, false, true);
                this.thisone.firePropertyChange(DPLX_PC_PASSWORD_VALIDITY, false, true);
                this.thisone.firePropertyChange(DPLX_PC_ID_VALIDITY, false, true);
                this.thisone.firePropertyChange(DPLX_PC_STAT_LN_UPDATE, "", " ");
            } else {
                String c = Integer.toString(gr_ch, 10);
                String p = gr_password;
                String d = Integer.toString(gr_id, 10);
                if (!(this.acceptedGroupName.equals(gr_name) && this.acceptedGroupChannel.equals(c) && this.acceptedGroupPassword.equals(p) && this.acceptedGroupId.equals(d))) {
                    this.thisone.firePropertyChange(DPLX_PC_STAT_LN_UPDATE, " ", "ErrorGroupMismatch");
                }
            }
            return true;
        }
        return false;
    }

    public void queryDuplexGroupIdentity() {
        this.awaitingGroupReadReport = true;
        this.gotQueryReply = false;
        this.memo.getLnTrafficController().sendLocoNetMessage(LnDplxGrpInfoImpl.createUr92GroupIdentityQueryPacket());
        this.invalidateDuplexGroupIdentityInfo();
        if (this.swingTmrDuplexInfoQuery != null) {
            if (this.swingTmrDuplexInfoQuery.isRunning()) {
                this.swingTmrDuplexInfoQuery.restart();
            } else {
                this.swingTmrDuplexInfoQuery.start();
            }
        }
    }

    public void setDuplexGroupName(String dgn) throws LocoNetException {
        this.memo.getLnTrafficController().sendLocoNetMessage(LnDplxGrpInfoImpl.createSetUr92GroupNamePacket(dgn));
    }

    public void setDuplexGroupChannel(Integer dgc) throws LocoNetException {
        this.memo.getLnTrafficController().sendLocoNetMessage(LnDplxGrpInfoImpl.createSetUr92GroupChannelPacket(dgc));
    }

    public void setDuplexGroupPassword(String dgp) throws LocoNetException {
        this.memo.getLnTrafficController().sendLocoNetMessage(LnDplxGrpInfoImpl.createSetUr92GroupPasswordPacket(dgp));
    }

    public void setDuplexGroupId(String dgi) throws LocoNetException {
        this.memo.getLnTrafficController().sendLocoNetMessage(LnDplxGrpInfoImpl.createSetUr92GroupIDPacket(dgi));
    }

    private void invalidateDataAndQueryDuplexInfo() {
        if (this.numUr92 > 0) {
            this.thisone.firePropertyChange(DPLX_PC_STAT_LN_UPDATE, " ", "ProcessingReadingInfo");
            this.queryDuplexGroupIdentity();
        }
    }

    private void sendUr92IplQuery() {
        this.waitingForIplReply = true;
        this.memo.getLnTrafficController().sendLocoNetMessage(LnIPLImplementation.createIplSpecificHostQueryPacket(0, 92));
        int oldvalue = 9999;
        int newvalue = 0;
        this.thisone.firePropertyChange("NumberOfUr92sUpdate", oldvalue, newvalue);
        this.invalidateDuplexGroupIdentityInfo();
        if (this.swingTmrIplQuery != null) {
            if (this.swingTmrIplQuery.isRunning()) {
                this.swingTmrIplQuery.restart();
            } else {
                this.swingTmrIplQuery.start();
            }
        }
    }

    private void invalidateDuplexGroupIdentityInfo() {
        this.acceptedGroupName = "";
        this.acceptedGroupChannel = "";
        this.acceptedGroupPassword = "";
        this.acceptedGroupId = "";
        this.thisone.firePropertyChange(DPLX_PC_NAME_UPDATE, true, false);
        this.thisone.firePropertyChange(DPLX_PC_CHANNEL_UPDATE, true, false);
        this.thisone.firePropertyChange(DPLX_PC_PASSWORD_UPDATE, true, false);
        this.thisone.firePropertyChange(DPLX_PC_ID_UPDATE, true, false);
        this.thisone.firePropertyChange(DPLX_PC_NAME_VALIDITY, true, false);
        this.thisone.firePropertyChange(DPLX_PC_CHANNEL_VALIDITY, true, false);
        this.thisone.firePropertyChange(DPLX_PC_PASSWORD_VALIDITY, true, false);
        this.thisone.firePropertyChange(DPLX_PC_ID_VALIDITY, true, false);
    }

    public void countUr92sAndQueryDuplexIdentityInfo() {
        if (this.thisone == null) {
            log.error("called countUR92sAndQueryDuplexInfo before thisone is initialized");
            return;
        }
        if (this.waitingForIplReply || this.swingTmrIplQuery == null || this.swingTmrDuplexInfoQuery == null || this.swingTmrIplQuery.isRunning() || this.swingTmrDuplexInfoQuery.isRunning()) {
            this.thisone.firePropertyChange(DPLX_PC_STAT_LN_UPDATE, " ", "ErrorReadingTooSoon");
            return;
        }
        this.invalidateDuplexGroupIdentityInfo();
        this.numUr92 = 0;
        this.sendUr92IplQuery();
        this.thisone.firePropertyChange(DPLX_PC_STAT_LN_UPDATE, " ", "ProcessingInitialStatusMessage");
        this.swingTmrIplQuery.stop();
        this.swingTmrIplQuery.setInitialDelay(1300);
        this.swingTmrIplQuery.setRepeats(false);
        this.swingTmrIplQuery.restart();
    }

    public static final LocoNetMessage createUr92GroupNameReportPacket(String dupName, String dupPass, int dupChan, int dupId) {
        LocoNetMessage m = new LocoNetMessage(20);
        int i = 0;
        dupName = String.valueOf(dupName) + "        ";
        dupName = dupName.substring(0, 8);
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 3);
        m.setElement(i++, 16);
        m.setElement(i++, ((dupName.charAt(0) & 0x80) == 128 ? 1 : 0) + ((dupName.charAt(1) & 0x80) == 128 ? 2 : 0) + ((dupName.charAt(2) & 0x80) == 128 ? 4 : 0) + ((dupName.charAt(3) & 0x80) == 128 ? 8 : 0));
        m.setElement(i++, dupName.charAt(0) & 0x7F);
        m.setElement(i++, dupName.charAt(1) & 0x7F);
        m.setElement(i++, dupName.charAt(2) & 0x7F);
        m.setElement(i++, dupName.charAt(3) & 0x7F);
        m.setElement(i++, ((dupName.charAt(4) & 0x80) == 128 ? 1 : 0) + ((dupName.charAt(5) & 0x80) == 128 ? 2 : 0) + ((dupName.charAt(6) & 0x80) == 128 ? 4 : 0) + ((dupName.charAt(7) & 0x80) == 128 ? 8 : 0));
        m.setElement(i++, dupName.charAt(4) & 0x7F);
        m.setElement(i++, dupName.charAt(5) & 0x7F);
        m.setElement(i++, dupName.charAt(6) & 0x7F);
        m.setElement(i++, dupName.charAt(7) & 0x7F);
        dupPass = String.valueOf(dupPass) + "0000";
        dupPass = dupPass.substring(0, 4);
        int gr_p1 = dupPass.charAt(0);
        int gr_p2 = dupPass.charAt(1);
        int gr_p3 = dupPass.charAt(2);
        int gr_p4 = dupPass.charAt(3);
        gr_p1 -= gr_p1 > 57 ? 7 : 0;
        int n = gr_p4 > 57 ? 7 : 0;
        int passLo = ((gr_p1 & 0xF) << 4) + ((gr_p2 -= gr_p2 > 57 ? 7 : 0) & 0xF);
        int passHi = (((gr_p3 -= gr_p3 > 57 ? 7 : 0) & 0xF) << 4) + ((gr_p4 -= n) & 0xF);
        m.setElement(i++, ((passLo & 0x80) == 128 ? 1 : 0) + ((passHi & 0x80) == 128 ? 2 : 0) + ((dupChan & 0x80) == 128 ? 4 : 0) + ((dupId & 0x80) == 128 ? 8 : 0));
        m.setElement(i++, passLo & 0x7F);
        m.setElement(i++, passHi & 0x7F);
        m.setElement(i++, dupChan & 0x7F);
        m.setElement(i++, dupId & 0x7F);
        return m;
    }

    public static final LocoNetMessage createUr92GroupChannelReportPacket(int dupChan) {
        LocoNetMessage m = new LocoNetMessage(20);
        int i = 0;
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 2);
        m.setElement(i++, 16);
        m.setElement(i++, (dupChan & 0x80) >> 7);
        m.setElement(i++, dupChan & 0x7F);
        while (i < 20) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    public static final LocoNetMessage createUr92GroupPasswordReportPacket(String dupPass) {
        LocoNetMessage m = new LocoNetMessage(20);
        int i = 0;
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 7);
        m.setElement(i++, 16);
        dupPass = String.valueOf(dupPass) + "0000";
        m.setElement(i++, ((dupPass.charAt(0) & 0x80) == 128 ? 8 : 0) + ((dupPass.charAt(1) & 0x80) == 128 ? 4 : 0) + ((dupPass.charAt(2) & 0x80) == 128 ? 2 : 0) + ((dupPass.charAt(3) & 0x80) == 128 ? 1 : 0));
        m.setElement(i++, dupPass.charAt(0) & 0x7F);
        m.setElement(i++, dupPass.charAt(1) & 0x7F);
        m.setElement(i++, dupPass.charAt(2) & 0x7F);
        m.setElement(i++, dupPass.charAt(3) & 0x7F);
        while (i < 20) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    public static final LocoNetMessage createUr92GroupIdReportPacket(int dupId) {
        LocoNetMessage m = new LocoNetMessage(20);
        int i = 0;
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 4);
        m.setElement(i++, 16);
        m.setElement(i++, (dupId & 0x80) >> 7);
        m.setElement(i++, dupId & 0x7F);
        while (i < 20) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    public int getNumUr92s() {
        return this.numUr92;
    }

    public boolean isWaitingForFirstUr92IPLReport() {
        return this.waitingForIplReply;
    }

    public int getMessagesHandled() {
        return this.messagesHandled;
    }

    public boolean isIplQueryTimerRunning() {
        return this.swingTmrIplQuery.isRunning();
    }

    public boolean isDuplexGroupQueryRunning() {
        return this.swingTmrDuplexInfoQuery.isRunning();
    }

    public boolean isAwaitingDuplexGroupReportMessage() {
        return this.awaitingGroupReadReport;
    }

    public void connect(LnTrafficController t) {
        if (t != null) {
            t.addLocoNetListener(-1, this);
        }
    }

    public void dispose() {
        if (this.swingTmrIplQuery != null) {
            this.swingTmrIplQuery.stop();
        }
        if (this.swingTmrDuplexInfoQuery != null) {
            this.swingTmrDuplexInfoQuery.stop();
        }
        if (this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
    }
}

