/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.duplexgroup.swing;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.duplexgroup.swing.Bundle;
import jmri.jmrix.loconet.swing.LnPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplexGroupScanPanel
extends LnPanel
implements LocoNetListener,
ChangeListener {
    DuplexChannelInfo[] dci = new DuplexChannelInfo[16];
    private Timer tmr;
    DuplexGroupScanPanel safe;
    private static final int DEFAULT_SCAN_COUNT = 25;
    private boolean isInitialized = false;
    JButton scanLoopButton = null;
    JLabel scanLoopLabel = null;
    JButton clearButton = null;
    JLabel grStatusValue = null;
    boolean stopRequested;
    Integer scanLoopDelay;
    boolean waitingForPreviousGroupChannel;
    int previousGroupChannel;
    int channelIndexToScan;
    int maxChannelIndexToScan;
    int loopNum;
    Integer whenToStop;
    private static final Logger log = LoggerFactory.getLogger(DuplexGroupScanPanel.class);
    private DuplexGroupChannelScanGuiCanvas graphicArea;

    public DuplexGroupScanPanel() {
        this.memo = null;
        this.safe = this;
    }

    @Override
    public void initComponents() {
        int minWindowWidth = 0;
        int j = 0;
        int i = 11;
        while (i <= 26) {
            this.dci[j] = new DuplexChannelInfo();
            this.dci[j].channel = i++;
            this.dci[j].numSamples = 0;
            this.dci[j].maxSigValue = -1;
            this.dci[j].minSigValue = 256;
            this.dci[j].sumSamples = 0;
            this.dci[j].avgSamples = 0;
            this.dci[j].mostRecentSample = -1;
            ++j;
        }
        this.grStatusValue = new JLabel(" ");
        this.clearButton = new JButton(Bundle.getMessage("ButtonClearScanData"));
        this.scanLoopButton = new JButton(Bundle.getMessage("ButtonScanChannelsLoop"));
        this.clearButton.setToolTipText(Bundle.getMessage("ToolTipButtonClearScanData"));
        this.scanLoopButton.setToolTipText(Bundle.getMessage("ToolTipButtonScanChannelsLoop"));
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        this.graphicArea = new DuplexGroupChannelScanGuiCanvas();
        p.add(this.graphicArea);
        this.add(p);
        p = new JPanel();
        p.setLayout(new GridLayout(4, 1));
        JLabel graphicAreaLabel1 = new JLabel(Bundle.getMessage("LabelGraphicArea1"));
        graphicAreaLabel1.setFont(new Font("Dialog", 0, 10));
        p.add(graphicAreaLabel1);
        JLabel graphicAreaLabel2 = new JLabel(Bundle.getMessage("LabelGraphicArea2"));
        graphicAreaLabel2.setFont(new Font("Dialog", 0, 10));
        p.add(graphicAreaLabel2);
        JLabel graphicAreaLabel3 = new JLabel(Bundle.getMessage("LabelGraphicArea3"));
        graphicAreaLabel3.setFont(new Font("Dialog", 0, 10));
        p.add(graphicAreaLabel3);
        this.add(p);
        JLabel graphicAreaLabel4 = new JLabel(Bundle.getMessage("LabelGraphicArea4"));
        graphicAreaLabel4.setFont(new Font("Dialog", 0, 10));
        p.add(graphicAreaLabel4);
        this.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.clearButton);
        p.add(this.scanLoopButton);
        this.stopRequested = false;
        this.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.add(new JSeparator());
        p.add(this.grStatusValue);
        this.add(p);
        p = new JPanel();
        try {
            minWindowWidth = Integer.parseInt(Bundle.getMessage("MinimumWidthForWindow"), 10);
        }
        catch (Exception exception) {
            minWindowWidth = 400;
        }
        p.add(Box.createRigidArea(new Dimension(minWindowWidth, 0)));
        this.add(p);
        this.scanLoopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplexGroupScanPanel.this.scanLoopButton.getText().equals(Bundle.getMessage("ButtonScanChannelsStop"))) {
                    DuplexGroupScanPanel.this.scanLoopStopButtonActionPerformed();
                } else {
                    DuplexGroupScanPanel.this.scanLoopButton.setText(Bundle.getMessage("ButtonScanChannelsStop"));
                    DuplexGroupScanPanel.this.scanLoopButtonActionPerformed();
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplexGroupScanPanel.this.scanLoopStopButtonActionPerformed();
                DuplexGroupScanPanel.this.clearButtonActionPerformed();
                DuplexGroupScanPanel.this.graphicArea.repaint();
            }
        });
        try {
            this.scanLoopDelay = Integer.parseInt(Bundle.getMessage("SetupDefaultChannelDelayInMilliSec"));
        }
        catch (Exception exception) {
            log.error("Bad value in prop files for SetupDefaultChannelDelayInMilliSec.");
            this.scanLoopDelay = 200;
        }
        if (this.memo != null) {
            this.isInitialized = true;
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.duplexgroup.DuplexGroupTabbedPanel";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("ScanTitle");
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.connect(memo.getLnTrafficController());
        this.waitingForPreviousGroupChannel = true;
        memo.getLnTrafficController().sendLocoNetMessage(this.createGetGroupChannelPacketInt());
        if (this.grStatusValue != null) {
            this.isInitialized = true;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void message(LocoNetMessage m) {
        if (this.stopRequested) {
            return;
        }
        if (this.handleMessageDuplexScanReport(m)) {
            return;
        }
        if (this.handleMessageDuplexChannelReport(m)) {
            return;
        }
    }

    private boolean handleMessageDuplexChannelReport(LocoNetMessage m) {
        if (m.getOpCode() != 229 || m.getElement(1) != 20 || m.getElement(2) != 2 || m.getElement(3) != 16) {
            return false;
        }
        if (this.waitingForPreviousGroupChannel) {
            this.waitingForPreviousGroupChannel = false;
            this.previousGroupChannel = m.getElement(5);
        }
        return true;
    }

    private boolean handleMessageDuplexScanReport(LocoNetMessage m) {
        if (m.getOpCode() != 229 || m.getElement(1) != 20 || m.getElement(2) != 16 || m.getElement(3) != 16) {
            return false;
        }
        this.handleChannelSignalReport(m.getElement(4), m.getElement(5), m.getElement(6));
        return true;
    }

    private void handleChannelSignalReport(int extendedVal, int channelNum, int signalValue) {
        int index = -1;
        int fullSignal = signalValue + 128 * ((extendedVal & 2) == 2 ? 1 : 0);
        int i = 0;
        while (i < this.dci.length) {
            if (this.dci[i].channel == channelNum) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            if (index == 16) {
                log.error("{}\n", (Object)Bundle.getMessage("ErrorLogUnexpectedChannelNumber", channelNum));
            }
            ++this.dci[index].numSamples;
            this.dci[index].mostRecentSample = fullSignal;
            if (fullSignal > this.dci[index].maxSigValue) {
                this.dci[index].maxSigValue = fullSignal;
            }
            if (fullSignal < this.dci[index].minSigValue) {
                this.dci[index].minSigValue = fullSignal;
            }
            this.dci[index].sumSamples += fullSignal;
            this.dci[index].avgSamples = this.dci[index].sumSamples / this.dci[index].numSamples;
            this.graphicArea.repaint();
        } else {
            log.error("{}\n", (Object)Bundle.getMessage("ErrorLogUnexpectedChannelNumber", channelNum));
        }
    }

    private LocoNetMessage createDuplexScanQueryPacket(int channelNum) {
        int i = 0;
        LocoNetMessage m = new LocoNetMessage(20);
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 16);
        m.setElement(i++, 8);
        m.setElement(i++, 0);
        m.setElement(i++, channelNum);
        while (i < 19) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    private LocoNetMessage createGetGroupChannelPacketInt() {
        LocoNetMessage m = new LocoNetMessage(20);
        int i = 0;
        m.setElement(i++, 229);
        m.setElement(i++, 20);
        m.setElement(i++, 2);
        m.setElement(i++, 8);
        while (i < 19) {
            m.setElement(i, 0);
            ++i;
        }
        return m;
    }

    private void updateScanLoopCountStatus(int current, int total) {
        this.grStatusValue.setText(Bundle.getMessage("StatusCurrentLoopCounter", current, total));
    }

    private void scanLoopButtonActionPerformed() {
        this.loopNum = 1;
        try {
            this.whenToStop = Integer.parseInt(Bundle.getMessage("SetupNumberOfLoops"));
        }
        catch (Exception exception) {
            this.whenToStop = 25;
        }
        if (this.whenToStop <= 0 || this.whenToStop > 1000) {
            this.grStatusValue.setText(Bundle.getMessage("ErrorBadLoopCount"));
            return;
        }
        this.grStatusValue.setText(" ");
        this.stopRequested = false;
        this.channelIndexToScan = 0;
        this.maxChannelIndexToScan = 15;
        this.updateScanLoopCountStatus(this.loopNum, this.whenToStop);
        this.tmr = new Timer(this.scanLoopDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplexGroupScanPanel.this.tmr.stop();
                if (DuplexGroupScanPanel.this.stopRequested) {
                    DuplexGroupScanPanel.this.stopRequested = false;
                    DuplexGroupScanPanel.this.showOnlyMaxAvgValues();
                } else if (DuplexGroupScanPanel.this.channelIndexToScan <= DuplexGroupScanPanel.this.maxChannelIndexToScan) {
                    DuplexGroupScanPanel.this.graphicArea.setChannelBeingScanned(DuplexGroupScanPanel.this.dci[DuplexGroupScanPanel.this.channelIndexToScan].channel);
                    DuplexGroupScanPanel.this.graphicArea.repaint();
                    DuplexGroupScanPanel.this.memo.getLnTrafficController().sendLocoNetMessage(DuplexGroupScanPanel.this.createDuplexScanQueryPacket(DuplexGroupScanPanel.this.dci[DuplexGroupScanPanel.this.channelIndexToScan].channel));
                    DuplexGroupScanPanel.this.tmr.setInitialDelay(DuplexGroupScanPanel.this.scanLoopDelay);
                    DuplexGroupScanPanel.this.tmr.setRepeats(false);
                    DuplexGroupScanPanel.this.tmr.start();
                    ++DuplexGroupScanPanel.this.channelIndexToScan;
                } else if (DuplexGroupScanPanel.this.loopNum < DuplexGroupScanPanel.this.whenToStop) {
                    ++DuplexGroupScanPanel.this.loopNum;
                    DuplexGroupScanPanel.this.updateScanLoopCountStatus(DuplexGroupScanPanel.this.loopNum, DuplexGroupScanPanel.this.whenToStop);
                    DuplexGroupScanPanel.this.channelIndexToScan = 0;
                    DuplexGroupScanPanel.this.graphicArea.setChannelBeingScanned(DuplexGroupScanPanel.this.dci[DuplexGroupScanPanel.this.channelIndexToScan].channel);
                    DuplexGroupScanPanel.this.graphicArea.repaint();
                    DuplexGroupScanPanel.this.memo.getLnTrafficController().sendLocoNetMessage(DuplexGroupScanPanel.this.createDuplexScanQueryPacket(DuplexGroupScanPanel.this.dci[DuplexGroupScanPanel.this.channelIndexToScan].channel));
                    DuplexGroupScanPanel.this.tmr.setInitialDelay(DuplexGroupScanPanel.this.scanLoopDelay);
                    DuplexGroupScanPanel.this.tmr.setRepeats(false);
                    DuplexGroupScanPanel.this.tmr.start();
                    ++DuplexGroupScanPanel.this.channelIndexToScan;
                } else {
                    DuplexGroupScanPanel.this.showOnlyMaxAvgValues();
                    DuplexGroupScanPanel.this.scanLoopButton.setText(Bundle.getMessage("ButtonScanChannelsLoop"));
                    DuplexGroupScanPanel.this.scanLoopStopButtonActionPerformed();
                    DuplexGroupScanPanel.this.grStatusValue.setText(" ");
                    DuplexGroupScanPanel.this.graphicArea.setChannelBeingScanned(-1);
                    DuplexGroupScanPanel.this.graphicArea.repaint();
                }
            }
        });
        this.tmr.setInitialDelay(this.scanLoopDelay);
        this.tmr.setRepeats(false);
        this.tmr.start();
    }

    private void scanLoopStopButtonActionPerformed() {
        this.scanLoopButton.setText(Bundle.getMessage("ButtonScanChannelsLoop"));
        this.graphicArea.setChannelBeingScanned(-1);
        this.graphicArea.repaint();
        this.grStatusValue.setText(" ");
        this.stopRequested = true;
    }

    private void clearButtonActionPerformed() {
        int maxIndex = 15;
        int index = 0;
        while (index <= maxIndex) {
            this.dci[index].numSamples = 0;
            this.dci[index].maxSigValue = -1;
            this.dci[index].minSigValue = 256;
            this.dci[index].sumSamples = 0;
            this.dci[index].avgSamples = 0;
            this.dci[index].mostRecentSample = -1;
            ++index;
        }
    }

    public void connect(LnTrafficController t) {
        if (t != null) {
            t.addLocoNetListener(-1, this);
        }
    }

    @Override
    public void dispose() {
        this.stopRequested = true;
        if (this.tmr != null) {
            this.tmr.stop();
        }
        this.tmr = null;
        if (!this.waitingForPreviousGroupChannel) {
            Timer exitTmr = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DuplexGroupScanPanel.this.memo.getLnTrafficController() != null) {
                        DuplexGroupScanPanel.this.memo.getLnTrafficController().removeLocoNetListener(-1, DuplexGroupScanPanel.this.safe);
                    }
                    DuplexGroupScanPanel.this.safe.dispose();
                }
            });
            exitTmr.setInitialDelay(200);
            exitTmr.setRepeats(false);
            exitTmr.start();
            while (exitTmr.isRunning()) {
            }
            exitTmr.stop();
        }
        if (this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
        super.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.graphicArea.repaint();
    }

    private void showOnlyMaxAvgValues() {
        int i = 0;
        while (i < 16) {
            this.dci[i].mostRecentSample = -1;
            ++i;
        }
        this.graphicArea.repaint();
    }

    private static class DuplexChannelInfo {
        public int channel = -1;
        public int numSamples = 0;
        public int maxSigValue = -1;
        public int minSigValue = 1000;
        public int sumSamples = 0;
        public int avgSamples = 0;
        public int mostRecentSample = -1;
    }

    private class DuplexGroupChannelScanGuiCanvas
    extends Canvas {
        private int barWidth = 7;
        private int barSpace = this.barWidth + 8;
        private int barOffset = (this.barSpace - this.barWidth) / 2;
        private static final int channelCount = 16;
        private static final int barGraphScale = 2;
        private static final int maxScanValue = 255;
        private static final int maxScaledBarValue = 128;
        private int baseline = 133;
        public int requiredMinWindowWidth = 16 * this.barSpace;
        public int requiredMinWindowHeight = this.baseline + 10;
        private static final int HORIZ_PADDING = 12;
        private static final int VERT_PADDING = 4;
        private int indexBeingScanned = -1;
        private Dimension channelTextSize;
        Font signalBarsFont;
        private final Color foregroundColor = Color.WHITE;
        private final Color backgroundColor = Color.BLACK;
        private final Color recommendationLineColor = Color.YELLOW;
        private final Color valueBarColor = Color.CYAN;
        private final Color maxLineColor = Color.RED;
        private final Color averageLineColor = Color.GREEN;
        private final Color lowerLimitLineColor = Color.LIGHT_GRAY;
        final float[] dash1 = new float[]{7.0f, 3.0f};
        final BasicStroke dashedStroke = new BasicStroke(1.0f, 0, 0, 10.0f, this.dash1, 0.0f);
        final BasicStroke plainStroke = new BasicStroke(1.0f);

        public DuplexGroupChannelScanGuiCanvas() {
            this.setBackground(this.backgroundColor);
            this.setForeground(this.foregroundColor);
            this.signalBarsFont = new Font("Dialog", 0, 8);
            int textHeight = 0;
            int textWidth = 0;
            FontMetrics metrics = this.getFontMetrics(this.signalBarsFont);
            textHeight = metrics.getHeight();
            textWidth = metrics.stringWidth("38");
            this.channelTextSize = new Dimension(textWidth + 12, textHeight + 4);
            this.requiredMinWindowWidth = 16 * this.channelTextSize.width;
            this.requiredMinWindowHeight += 2 * this.channelTextSize.height;
            this.baseline += this.channelTextSize.height;
            this.barSpace = this.channelTextSize.width;
            this.barWidth = textWidth;
            this.barOffset = (this.barSpace - this.barWidth) / 2;
            textWidth = 0;
            this.setSize(this.requiredMinWindowWidth, this.requiredMinWindowHeight);
        }

        public void setChannelBeingScanned(int channelNum) {
            if (channelNum < 11 || channelNum > 26) {
                this.indexBeingScanned = -1;
                return;
            }
            this.indexBeingScanned = channelNum - 11;
        }

        @Override
        public void paint(Graphics g) {
            if (!(g instanceof Graphics2D)) {
                log.error("paint() cannot cast object g to Graphics2D.  Aborting paint().");
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            int i = 11;
            while (i <= 26) {
                g2.drawString(Integer.toString(i), (i - 11) * this.channelTextSize.width, this.channelTextSize.height);
                g2.drawString(Integer.toString(i), (i - 11) * this.channelTextSize.width, this.requiredMinWindowHeight - 1);
                ++i;
            }
            g2.setColor(this.lowerLimitLineColor);
            g2.draw(new Line2D.Float(0.0f, this.baseline + 1, this.requiredMinWindowWidth - 1, this.baseline + 1));
            int channelIndex = 0;
            while (channelIndex < 16) {
                this.redrawSignalBar(g2, DuplexGroupScanPanel.this.dci[channelIndex]);
                ++channelIndex;
            }
            this.redrawChannelAtIndicator(g2, this.indexBeingScanned);
            g2.setColor(this.recommendationLineColor);
            g2.setStroke(this.dashedStroke);
            g2.draw(new Line2D.Float(1.0f, this.baseline - 48, this.requiredMinWindowWidth - 1, this.baseline - 48));
            g2.setStroke(this.plainStroke);
        }

        private void redrawSignalBar(Graphics2D g2, DuplexChannelInfo dci) {
            int index = dci.channel - 11;
            int current = dci.mostRecentSample;
            int max = dci.maxSigValue;
            int avg = dci.avgSamples;
            if (avg < 0) {
                avg = 0;
            }
            int numSamples = dci.numSamples;
            if (current > 0) {
                int upperX = this.barSpace * index;
                int width = this.barSpace;
                int upperY = this.baseline - 128;
                int height = 127;
                g2.setColor(this.backgroundColor);
                g2.fillRect(upperX, upperY, width, height - 1);
                upperY = this.baseline - current / 2;
                g2.setColor(this.valueBarColor);
                g2.fillRect(upperX + this.barOffset, upperY, this.barWidth, current / 2);
            } else {
                g2.setColor(this.backgroundColor);
                g2.fillRect(this.barOffset + this.barSpace * index, this.baseline - 128 - 1, this.barWidth, 128);
            }
            if (numSamples > 1) {
                g2.setColor(this.averageLineColor);
                g2.draw(new Line2D.Float(this.barSpace * index + 1, this.baseline - avg / 2 - 1, this.barSpace * (index + 1) - 2, this.baseline - avg / 2 - 1));
            }
            if (max >= 0) {
                g2.setColor(this.maxLineColor);
                g2.draw(new Line2D.Float(this.barSpace * index + 1, this.baseline - max / 2 - 1, this.barSpace * (index + 1) - 2, this.baseline - max / 2 - 1));
            }
        }

        private void redrawChannelAtIndicator(Graphics2D g2, int channelIndex) {
            int upperY = this.baseline + 2;
            int height = this.requiredMinWindowHeight - upperY - this.channelTextSize.height - 2;
            int upperX = 0;
            int width = this.requiredMinWindowWidth;
            g2.setColor(this.backgroundColor);
            g2.fillRect(upperX, upperY, width, height - 1);
            if (channelIndex >= 0 && channelIndex < 16) {
                g2.setColor(this.foregroundColor);
                int[] x2Points = new int[]{channelIndex * this.barSpace + this.barSpace / 2, channelIndex * this.barSpace + this.barOffset, channelIndex * this.barSpace + this.barSpace / 2, channelIndex * this.barSpace + (this.barSpace - this.barOffset)};
                int[] y2Points = new int[]{this.baseline + 2, this.baseline + 5, this.baseline + 8, this.baseline + 5};
                GeneralPath polygon = new GeneralPath(0, x2Points.length);
                polygon.moveTo(x2Points[0], y2Points[0]);
                int index = 1;
                while (index < x2Points.length) {
                    polygon.lineTo(x2Points[index], y2Points[index]);
                    ++index;
                }
                polygon.closePath();
                g2.draw(polygon);
            }
        }
    }
}

