/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.duplexgroup.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.jmrix.loconet.LocoNetException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.duplexgroup.swing.Bundle;
import jmri.jmrix.loconet.duplexgroup.swing.LnDplxGrpInfoImpl;
import jmri.jmrix.loconet.swing.LnNamedPaneAction;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.util.swing.ValidatedTextField;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class DuplexGroupInfoPanel
extends LnPanel
implements PropertyChangeListener {
    JButton swingReadButton;
    JButton swingSetButton;
    ValidatedTextField swingNameValueField = new ValidatedTextField((Integer)1, false, "a", "b");
    ValidatedTextField swingChannelValueField = new ValidatedTextField((Integer)1, false, "a", "b");
    ValidatedTextField swingPasswordValueField = new ValidatedTextField((Integer)1, false, "a", "b");
    ValidatedTextField swingIdValueField = new ValidatedTextField((Integer)1, false, "a", "b");
    JLabel swingNumUr92Label;
    JLabel swingStatusValueLabel;
    private int numUr92;
    private LnDplxGrpInfoImpl duplexGroupImplementation;
    private int minWindowWidth = 0;
    public static final Color COLOR_MISMATCH_VAL = Color.red.darker();
    public static final Color COLOR_UNKN_VAL = Color.yellow.brighter();
    public static final Color COLOR_READ = null;
    public static final Color COLOR_BG_EDITED = Color.orange;
    public static final Color COLOR_ERROR_VAL = Color.black;
    public static final Color COLOR_OK = Color.black;
    public static final Color COLOR_BG_OK = Color.white;
    public static final Color COLOR_BG_UNEDITED = Color.white;
    public static final Color COLOR_STATUS_OK = Color.black;
    public static final Color COLOR_STATUS_ERROR = Color.red;
    public static final Color COLOR_BG_ERROR = Color.red;
    public static final int DEFAULT_WINDOW_WIDTH = 200;

    public DuplexGroupInfoPanel() {
        this.swingNameValueField = new ValidatedTextField((Integer)9, false, "^.{1,8}$", "ErrorBadGroupName");
        this.swingChannelValueField = new ValidatedTextField(3, false, 11, 26, "ErrorBadGroupChannel");
        this.swingPasswordValueField = new ValidatedTextField((Integer)5, true, "^[0-9A-C]{4}$", "ErrorBadGroupPassword");
        this.swingIdValueField = new ValidatedTextField(3, false, 0, 127, "ErrorBadGroupId");
        this.swingNameValueField.addPropertyChangeListener("VTFPCK_STAT_LN_UPDATE", this);
        this.swingChannelValueField.addPropertyChangeListener("VTFPCK_STAT_LN_UPDATE", this);
        this.swingPasswordValueField.addPropertyChangeListener("VTFPCK_STAT_LN_UPDATE", this);
        this.swingIdValueField.addPropertyChangeListener("VTFPCK_STAT_LN_UPDATE", this);
        this.duplexGroupImplementation = null;
    }

    @Override
    public void initComponents() {
        try {
            this.minWindowWidth = Integer.parseInt(Bundle.getMessage("MinimumWidthForWindow"), 10);
        }
        catch (RuntimeException runtimeException) {
            this.minWindowWidth = 200;
        }
        this.numUr92 = 0;
        this.swingStatusValueLabel = new JLabel();
        this.swingStatusValueLabel.setName("ProcessingInitialStatusMessage");
        this.swingStatusValueLabel.setText(this.convertToHtml(this.swingStatusValueLabel.getName(), this.minWindowWidth));
        this.swingNameValueField.setText(Bundle.getMessage("ValueUnknownGroupName"));
        this.swingNameValueField.setToolTipText(Bundle.getMessage("ToolTipGroupName"));
        this.swingNameValueField.setLastQueriedValue(Bundle.getMessage("ValueUnknownGroupName"));
        this.swingChannelValueField.setText(Bundle.getMessage("ValueUnknownGroupChannel"));
        this.swingChannelValueField.setToolTipText(Bundle.getMessage("ToolTipGroupChannel"));
        this.swingChannelValueField.setLastQueriedValue(Bundle.getMessage("ValueUnknownGroupChannel"));
        this.swingPasswordValueField.setText(Bundle.getMessage("ValueUnknownGroupPassword"));
        this.swingPasswordValueField.setToolTipText(Bundle.getMessage("ToolTipGroupPassword"));
        this.swingPasswordValueField.setLastQueriedValue(Bundle.getMessage("ValueUnknownGroupPassword"));
        this.swingIdValueField.setText(Bundle.getMessage("ValueUnknownGroupID"));
        this.swingIdValueField.setToolTipText(Bundle.getMessage("ToolTipGroupID"));
        this.swingIdValueField.setLastQueriedValue(Bundle.getMessage("ValueUnknownGroupID"));
        int numLinesForStatus = 2;
        try {
            numLinesForStatus = Integer.parseInt(Bundle.getMessage("FixedLinesForStatus"));
        }
        catch (RuntimeException runtimeException) {
            numLinesForStatus = 2;
        }
        this.swingStatusValueLabel.setPreferredSize(new Dimension(this.minWindowWidth, numLinesForStatus * (int)this.swingStatusValueLabel.getMaximumSize().getHeight()));
        this.swingReadButton = new JButton(Bundle.getMessage("ButtonRead"));
        this.swingSetButton = new JButton(Bundle.getMessage("ButtonSet"));
        this.setLayout(new BoxLayout(this, 1));
        this.swingReadButton.hasFocus();
        JPanel swingTempPanel = new JPanel();
        swingTempPanel.setLayout(new FlowLayout(1, 5, 3));
        JLabel swingTempLabel = new JLabel(Bundle.getMessage("LabelDuplexName"));
        swingTempPanel.add(swingTempLabel);
        swingTempPanel.add(this.swingNameValueField);
        swingTempLabel.setLabelFor(this.swingNameValueField);
        this.add(swingTempPanel);
        swingTempPanel = new JPanel();
        swingTempPanel.setLayout(new FlowLayout(1, 5, 3));
        swingTempLabel = new JLabel(Bundle.getMessage("LabelDuplexChannel"));
        swingTempPanel.add(swingTempLabel);
        swingTempPanel.add(this.swingChannelValueField);
        swingTempLabel.setLabelFor(this.swingChannelValueField);
        this.add(swingTempPanel);
        swingTempPanel = new JPanel();
        swingTempPanel.setLayout(new FlowLayout(1, 5, 3));
        swingTempLabel = new JLabel(Bundle.getMessage("LabelDuplexPassword"));
        swingTempPanel.add(swingTempLabel);
        swingTempPanel.add(this.swingPasswordValueField);
        swingTempLabel.setLabelFor(this.swingPasswordValueField);
        this.add(swingTempPanel);
        swingTempPanel = new JPanel();
        swingTempPanel.setLayout(new FlowLayout(1, 5, 3));
        swingTempLabel = new JLabel(Bundle.getMessage("LabelDuplexGroupID"));
        swingTempPanel.add(swingTempLabel);
        swingTempPanel.add(this.swingIdValueField);
        swingTempLabel.setLabelFor(this.swingIdValueField);
        this.add(swingTempPanel);
        swingTempPanel = new JPanel();
        swingTempPanel.setLayout(new FlowLayout(1, 5, 3));
        this.swingNumUr92Label = new JLabel(" ");
        swingTempPanel.add(this.swingNumUr92Label);
        this.updateDisplayOfUr92Count();
        this.add(swingTempPanel);
        swingTempPanel = new JPanel();
        swingTempPanel.setLayout(new FlowLayout());
        swingTempPanel.add(this.swingReadButton);
        swingTempPanel.add(this.swingSetButton);
        this.add(swingTempPanel);
        this.add(new JSeparator());
        swingTempPanel = new JPanel();
        swingTempPanel.setLayout(new FlowLayout());
        swingTempPanel.add(this.swingStatusValueLabel);
        this.add(swingTempPanel);
        this.swingSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplexGroupInfoPanel.this.setButtonActionPerformed();
            }
        });
        this.swingReadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplexGroupInfoPanel.this.scanButtonActionPerformed();
            }
        });
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.duplexgroup.DuplexGroupTabbedPanel";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("Title");
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.duplexGroupImplementation = new LnDplxGrpInfoImpl(memo);
        this.duplexGroupImplementation.addPropertyChangeListener(this);
        this.scanButtonActionPerformed();
    }

    private void scanButtonActionPerformed() {
        this.numUr92 = 0;
        this.updateStatusLineMessage("ProcessingFindingUR92s", COLOR_STATUS_OK);
        this.duplexGroupImplementation.countUr92sAndQueryDuplexIdentityInfo();
    }

    private void readButtonActionPerformed() {
        if (this.numUr92 == 0) {
            this.scanButtonActionPerformed();
            return;
        }
        this.swingNameValueField.setForeground(COLOR_OK);
        this.swingChannelValueField.setForeground(COLOR_OK);
        this.swingPasswordValueField.setForeground(COLOR_OK);
        this.swingIdValueField.setForeground(COLOR_OK);
        this.swingNameValueField.setText(Bundle.getMessage("ValueUnknownGroupName"));
        this.swingChannelValueField.setText(Bundle.getMessage("ValueUnknownGroupChannel"));
        this.swingPasswordValueField.setText(Bundle.getMessage("ValueUnknownGroupPassword"));
        this.swingIdValueField.setText(Bundle.getMessage("ValueUnknownGroupID"));
        this.updateStatusLineMessage("ProcessingReadingInfo", COLOR_STATUS_OK);
        this.duplexGroupImplementation.queryDuplexGroupIdentity();
        this.updateStatusLineMessage("ProcessingWaitingForReport", COLOR_STATUS_OK);
    }

    private boolean validateGroupNameField() {
        return this.swingNameValueField.isValid();
    }

    private boolean validateGroupChannelField() {
        return this.swingChannelValueField.isValid();
    }

    private boolean validateGroupIDField() {
        return this.swingIdValueField.isValid();
    }

    private boolean validateGroupPasswordField() {
        return this.swingPasswordValueField.isValid();
    }

    private void setButtonActionPerformed() {
        boolean result = true;
        this.swingNameValueField.setForeground(COLOR_OK);
        this.swingChannelValueField.setForeground(COLOR_OK);
        this.swingPasswordValueField.setForeground(COLOR_OK);
        this.swingIdValueField.setForeground(COLOR_OK);
        this.updateStatusLineMessage(" ", COLOR_STATUS_OK);
        if (!this.validateGroupNameField()) {
            this.swingNameValueField.setForeground(COLOR_ERROR_VAL);
            result = false;
            this.updateStatusLineMessage("ErrorBadGroupName", COLOR_STATUS_ERROR);
            this.swingNameValueField.requestFocusInWindow();
        } else if (!this.validateGroupChannelField()) {
            this.swingChannelValueField.setForeground(COLOR_ERROR_VAL);
            result = false;
            this.updateStatusLineMessage("ErrorBadGroupChannel", COLOR_STATUS_ERROR);
            this.swingChannelValueField.requestFocusInWindow();
        } else if (!this.validateGroupPasswordField()) {
            this.swingPasswordValueField.setForeground(COLOR_ERROR_VAL);
            result = false;
            this.updateStatusLineMessage("ErrorBadGroupPassword", COLOR_STATUS_ERROR);
            this.swingPasswordValueField.requestFocusInWindow();
        } else if (!this.validateGroupIDField()) {
            this.swingIdValueField.setForeground(COLOR_ERROR_VAL);
            result = false;
            this.updateStatusLineMessage("ErrorBadGroupId", COLOR_STATUS_ERROR);
            this.swingIdValueField.requestFocusInWindow();
        }
        if (result) {
            this.updateStatusLineMessage("ProcessingGroupUpdate", COLOR_STATUS_OK);
            StringBuilder writeGroupName = new StringBuilder();
            writeGroupName.append(this.swingNameValueField.getText());
            writeGroupName.append("         ");
            writeGroupName.setLength(8);
            try {
                this.duplexGroupImplementation.setDuplexGroupName(writeGroupName.toString());
            }
            catch (LocoNetException locoNetException) {
                this.updateStatusLineMessage("ErrorBadGroupName", COLOR_STATUS_ERROR);
                this.swingNameValueField.requestFocusInWindow();
                return;
            }
            try {
                this.duplexGroupImplementation.setDuplexGroupChannel(Integer.parseInt(this.swingChannelValueField.getText(), 10));
            }
            catch (LocoNetException locoNetException) {
                this.updateStatusLineMessage("ErrorBadGroupChannel", COLOR_STATUS_ERROR);
                this.swingChannelValueField.requestFocusInWindow();
                return;
            }
            try {
                this.duplexGroupImplementation.setDuplexGroupPassword(this.swingPasswordValueField.getText());
            }
            catch (LocoNetException locoNetException) {
                this.updateStatusLineMessage("ErrorBadGroupPassword", COLOR_STATUS_ERROR);
                this.swingPasswordValueField.requestFocusInWindow();
                return;
            }
            try {
                this.duplexGroupImplementation.setDuplexGroupId(this.swingIdValueField.getText());
            }
            catch (LocoNetException locoNetException) {
                this.updateStatusLineMessage("ErrorBadGroupId", COLOR_STATUS_ERROR);
                this.swingIdValueField.requestFocusInWindow();
                return;
            }
            this.readButtonActionPerformed();
        }
    }

    private String convertToHtml(String s, int width) {
        String result = "<html><body><div align=center style='width: ";
        result = s.length() == 1 ? " " : String.valueOf(result) + width + "'>" + Bundle.getMessage(s);
        return result;
    }

    private void updateDisplayOfUr92Count() {
        Object[] messageArguments = new Object[]{this.numUr92, this.numUr92};
        MessageFormat formatter = new MessageFormat("");
        try {
            formatter.applyPattern(Bundle.getMessage("LabelDeviceCountUR92"));
            double[] pluralLimits = new double[]{0.0, 1.0, 2.0};
            String[] devicePlurals = new String[]{Bundle.getMessage("LabelDeviceCountUR92Plural0"), Bundle.getMessage("LabelDeviceCountUR92Plural1"), Bundle.getMessage("LabelDeviceCountUR92Plural2")};
            ChoiceFormat pluralForm = new ChoiceFormat(pluralLimits, devicePlurals);
            Format[] messageFormats = new Format[]{NumberFormat.getInstance(), pluralForm};
            formatter.setFormats(messageFormats);
            String ur92CountString = formatter.format(messageArguments);
            this.swingNumUr92Label.setText(ur92CountString);
        }
        catch (RuntimeException runtimeException) {
            this.swingNumUr92Label.setText(Bundle.getMessage("LabelDeviceCountUR92Except", this.numUr92));
        }
        this.swingNumUr92Label.repaint();
    }

    private void updateStatusLineMessage(String statusMessage, Color fgColor) {
        if (statusMessage == null) {
            this.swingStatusValueLabel.setForeground(fgColor);
            this.swingStatusValueLabel.setName(" ");
            this.swingStatusValueLabel.setText(this.convertToHtml(this.swingStatusValueLabel.getName(), this.minWindowWidth));
        } else {
            this.swingStatusValueLabel.setForeground(fgColor);
            this.swingStatusValueLabel.setName(statusMessage);
            this.swingStatusValueLabel.setText(this.convertToHtml(this.swingStatusValueLabel.getName(), this.minWindowWidth));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("DPLXPCK_STAT_LN_ON_OVER_UPDATE")) {
            if (this.swingStatusValueLabel == null) {
                return;
            }
            if (this.swingStatusValueLabel.getForeground().equals(COLOR_STATUS_ERROR)) {
                return;
            }
            String statusMessage = (String)evt.getNewValue();
            Color fgColor = COLOR_STATUS_OK;
            if (statusMessage == null) {
                this.updateStatusLineMessage(" ", COLOR_STATUS_OK);
                return;
            }
            if (statusMessage.startsWith("Error") || this.swingStatusValueLabel.getForeground().equals(COLOR_STATUS_ERROR)) {
                return;
            }
            this.updateStatusLineMessage(statusMessage, fgColor);
        } else if (eventName.equals("VTFPCK_STAT_LN_UPDATE") || eventName.equals("DPLXPCK_STAT_LN_UPDATE")) {
            if (this.swingStatusValueLabel == null) {
                return;
            }
            String statusMessage = (String)evt.getNewValue();
            if (statusMessage == null) {
                this.updateStatusLineMessage(" ", COLOR_STATUS_OK);
                return;
            }
            Color fgColor = COLOR_STATUS_OK;
            if (statusMessage.startsWith("ERROR:")) {
                fgColor = COLOR_STATUS_ERROR;
                statusMessage = statusMessage.substring(6);
            } else if (statusMessage.startsWith("Error")) {
                fgColor = COLOR_STATUS_ERROR;
            }
            this.updateStatusLineMessage(statusMessage, fgColor);
        } else if (eventName.equals("NumberOfUr92sUpdate")) {
            this.numUr92 = (Integer)evt.getNewValue();
            this.updateDisplayOfUr92Count();
        } else if (eventName.equals("DPLXPCK_NAME_VALID")) {
            this.swingNameValueField.setForeground(COLOR_OK);
            this.swingNameValueField.setEnabled(evt.getNewValue().equals(true));
            if (this.swingNameValueField.isEnabled() && this.swingChannelValueField.isEnabled() && this.swingPasswordValueField.isEnabled() && this.swingIdValueField.isEnabled()) {
                this.swingSetButton.setEnabled(true);
            } else {
                this.swingSetButton.setEnabled(false);
            }
        } else if (eventName.equals("DPLXPCK_CH_VALID")) {
            this.swingChannelValueField.setForeground(COLOR_OK);
            this.swingChannelValueField.setEnabled(evt.getNewValue().equals(true));
            if (this.swingNameValueField.isEnabled() && this.swingChannelValueField.isEnabled() && this.swingPasswordValueField.isEnabled() && this.swingIdValueField.isEnabled()) {
                this.swingSetButton.setEnabled(true);
            } else {
                this.swingSetButton.setEnabled(false);
            }
        } else if (eventName.equals("DPLXPCK_PW_VALID")) {
            this.swingPasswordValueField.setForeground(COLOR_OK);
            this.swingPasswordValueField.setEnabled(evt.getNewValue().equals(true));
            if (this.swingNameValueField.isEnabled() && this.swingChannelValueField.isEnabled() && this.swingPasswordValueField.isEnabled() && this.swingIdValueField.isEnabled()) {
                this.swingSetButton.setEnabled(true);
            } else {
                this.swingSetButton.setEnabled(false);
            }
        } else if (eventName.equals("DPLXPCK_ID_VALID")) {
            this.swingIdValueField.setForeground(COLOR_OK);
            this.swingIdValueField.setEnabled(evt.getNewValue().equals(true));
            if (this.swingNameValueField.isEnabled() && this.swingChannelValueField.isEnabled() && this.swingPasswordValueField.isEnabled() && this.swingIdValueField.isEnabled()) {
                this.swingSetButton.setEnabled(true);
            } else {
                this.swingSetButton.setEnabled(false);
            }
        } else if (eventName.equals("DPLXPCK_NAME_UPDATE")) {
            if (evt.getNewValue().equals(true)) {
                String s = this.duplexGroupImplementation.getFetchedDuplexGroupName();
                this.showValidGroupName(s);
                this.swingNameValueField.setLastQueriedValue(s);
            } else {
                this.disableGroupName();
            }
        } else if (eventName.equals("DPLXPCK_CH_UPDATE")) {
            if (evt.getNewValue().equals(true)) {
                String s = this.duplexGroupImplementation.getFetchedDuplexGroupChannel();
                this.showValidGroupChannel(s);
                this.swingChannelValueField.setLastQueriedValue(s);
            } else {
                this.disableGroupChannel();
            }
        } else if (eventName.equals("DPLXPCK_PW_UPDATE")) {
            if (evt.getNewValue().equals(true)) {
                String s = this.duplexGroupImplementation.getFetchedDuplexGroupPassword();
                this.showValidGroupPassword(s);
                this.swingPasswordValueField.setLastQueriedValue(s);
            } else {
                this.disableGroupPassword();
            }
        } else if (eventName.equals("DPLXPCK_ID_UPDATE")) {
            if (evt.getNewValue().equals(true)) {
                String s = this.duplexGroupImplementation.getFetchedDuplexGroupId();
                this.showValidGroupId(s);
                this.swingIdValueField.setLastQueriedValue(s);
            } else {
                this.disableGroupId();
            }
        }
    }

    private void showValidGroupName(String gn) {
        this.swingNameValueField.setForeground(COLOR_OK);
        this.swingNameValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingNameValueField.setEnabled(true);
        this.swingNameValueField.setText(gn);
    }

    private void disableGroupName() {
        this.swingNameValueField.setForeground(COLOR_OK);
        this.swingNameValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingNameValueField.setEnabled(false);
        this.swingNameValueField.setText("????????");
    }

    private void showValidGroupChannel(String gc) {
        this.swingChannelValueField.setForeground(COLOR_OK);
        this.swingChannelValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingChannelValueField.setEnabled(true);
        this.swingChannelValueField.setText(gc);
    }

    private void disableGroupChannel() {
        this.swingChannelValueField.setForeground(COLOR_OK);
        this.swingChannelValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingChannelValueField.setEnabled(false);
        this.swingChannelValueField.setText("??");
    }

    private void showValidGroupPassword(String gp) {
        this.swingPasswordValueField.setForeground(COLOR_OK);
        this.swingPasswordValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingPasswordValueField.setEnabled(true);
        this.swingPasswordValueField.setText(gp);
    }

    private void disableGroupPassword() {
        this.swingPasswordValueField.setForeground(COLOR_OK);
        this.swingPasswordValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingPasswordValueField.setEnabled(false);
        this.swingPasswordValueField.setText("????");
    }

    private void showValidGroupId(String gi) {
        this.swingIdValueField.setForeground(COLOR_OK);
        this.swingIdValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingIdValueField.setEnabled(true);
        this.swingIdValueField.setText(gi);
    }

    private void disableGroupId() {
        this.swingIdValueField.setForeground(COLOR_OK);
        this.swingIdValueField.setBackground(COLOR_BG_UNEDITED);
        this.swingIdValueField.setEnabled(false);
        this.swingIdValueField.setText("???");
    }

    public static class Default
    extends LnNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemDuplexInfo"), new JmriJFrameInterface(), DuplexGroupInfoPanel.class.getName(), InstanceManager.getDefault(LocoNetSystemConnectionMemo.class));
        }
    }
}

