/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrix.loconet.SE8cSignalHead;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SE8cSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(SE8cSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        SE8cSignalHead p = (SE8cSignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.setAttribute("systemName", p.getSystemName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)this.addTurnoutElement(p.getNumber()));
        return element;
    }

    Element addTurnoutElement(int number) {
        Element el = new Element("turnout");
        el.setAttribute("systemName", "" + number);
        return el;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List l = shared.getChildren("turnout");
        int turnout = this.loadTurnout(l.get(0));
        String uname = this.getUserName(shared);
        jmri.implementation.SE8cSignalHead h = uname == null ? new jmri.implementation.SE8cSignalHead(turnout) : new jmri.implementation.SE8cSignalHead(turnout, uname);
        this.loadCommon(h, shared);
        SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(h.getSystemName());
        if (sh != null) {
            InstanceManager.getDefault(SignalHeadManager.class).deregister(sh);
        }
        InstanceManager.getDefault(SignalHeadManager.class).register(h);
        return true;
    }

    int loadTurnout(Object o) {
        Element e = (Element)o;
        try {
            return e.getAttribute("systemName").getIntValue();
        }
        catch (DataConversionException ex) {
            log.warn("Can't read turnout number for SE8cSignalHead because of {}", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

