/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.cmdstnconfig;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.cmdstnconfig.Bundle;
import jmri.jmrix.loconet.swing.LnPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdStnConfigPane
extends LnPanel
implements LocoNetListener {
    int CONFIG_SLOT = 127;
    int MIN_OPTION = 1;
    int MAX_OPTION = 96;
    String labelT;
    String labelC;
    String labelTop;
    String read;
    String write;
    int[] oldcontent = new int[10];
    JCheckBox optionBox;
    ResourceBundle rb;
    JButton readButton;
    JButton writeButton;
    JRadioButton[] closedButtons = new JRadioButton[this.MAX_OPTION];
    JRadioButton[] thrownButtons = new JRadioButton[this.MAX_OPTION];
    JLabel[] labels = new JLabel[this.MAX_OPTION];
    boolean[] isReserved = new boolean[this.MAX_OPTION];
    private static final Logger log = LoggerFactory.getLogger(CmdStnConfigPane.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.cmdstnconfig.CmdStnConfigFrame";
    }

    @Override
    public String getTitle() {
        String uName = "";
        if (this.memo != null) {
            uName = this.memo.getUserName();
            uName = !"LocoNet".equals(uName) ? String.valueOf(uName) + ": " : "";
        }
        return String.valueOf(uName) + Bundle.getMessage("MenuItemCmdStnConfig");
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        String name = "<unchanged>";
        try {
            name = memo.getSlotManager().getCommandStationType().getName();
            if (name.indexOf(32) != -1) {
                name = name.substring(0, name.indexOf(32));
            }
            log.debug("match /{}/", (Object)name);
            this.rb = ResourceBundle.getBundle("jmri.jmrix.loconet.cmdstnconfig." + name + "options");
        }
        catch (Exception e2) {
            log.warn("Failed to find properties for /{}/ command station type", (Object)name, (Object)e2);
            this.rb = ResourceBundle.getBundle("jmri.jmrix.loconet.cmdstnconfig.Defaultoptions");
        }
        try {
            this.CONFIG_SLOT = Integer.parseInt(this.rb.getString("CONFIG_SLOT"));
            this.MIN_OPTION = Integer.parseInt(this.rb.getString("MIN_OPTION"));
            this.MAX_OPTION = Integer.parseInt(this.rb.getString("MAX_OPTION"));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Failed to load values from /{}/ properties", (Object)name);
        }
        log.debug("Constants: {} {} {}", new Object[]{this.CONFIG_SLOT, this.MIN_OPTION, this.MAX_OPTION});
        this.labelT = Bundle.getMessage("StateThrownShort");
        this.labelC = Bundle.getMessage("StateClosedShort");
        this.labelTop = this.rb.getString("LabelTop");
        this.read = Bundle.getMessage("ButtonRead");
        this.write = Bundle.getMessage("ButtonWrite");
        String tooltip = Bundle.getMessage("CmdStnConfigFxToolTip");
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel(this.labelTop));
        this.readButton = new JButton(this.read);
        this.writeButton = new JButton(this.write);
        JPanel pane = new JPanel();
        pane.setLayout(new FlowLayout());
        pane.add(this.readButton);
        pane.add(this.writeButton);
        if (this.CONFIG_SLOT == -1) {
            this.readButton.setEnabled(false);
            this.writeButton.setEnabled(false);
        }
        this.add(pane);
        this.optionBox = new JCheckBox(Bundle.getMessage("CheckBoxReserved"));
        this.add(this.optionBox);
        this.add(new JLabel(Bundle.getMessage("HeadingText")));
        JPanel options = new JPanel();
        GridBagConstraints gc = new GridBagConstraints();
        GridBagLayout gl = new GridBagLayout();
        gc.gridy = 0;
        gc.ipady = 0;
        options.setLayout(gl);
        int i = this.MIN_OPTION;
        while (i <= this.MAX_OPTION) {
            String label;
            JPanel p2 = new JPanel();
            p2.setLayout(new FlowLayout());
            ButtonGroup g = new ButtonGroup();
            JRadioButton c = new JRadioButton(this.labelC);
            JRadioButton t = new JRadioButton(this.labelT);
            g.add(c);
            g.add(t);
            p2.add(t);
            p2.add(c);
            this.closedButtons[i - this.MIN_OPTION] = c;
            this.thrownButtons[i - this.MIN_OPTION] = t;
            gc.weightx = 1.0;
            gc.gridx = 0;
            gc.anchor = 10;
            gl.setConstraints(p2, gc);
            options.add(p2);
            gc.gridx = 1;
            gc.weightx = 0.0;
            gc.anchor = 17;
            try {
                label = this.rb.getString("Option" + i);
                this.isReserved[i - this.MIN_OPTION] = false;
            }
            catch (MissingResourceException missingResourceException) {
                label = i + ": " + Bundle.getMessage("Reserved");
                this.isReserved[i - this.MIN_OPTION] = true;
            }
            JLabel l = new JLabel(label);
            if (i > 20 && i < 24) {
                log.debug("CS name: {}", (Object)name);
                if (name.startsWith("DB150")) {
                    tooltip = this.rb.getString("DB150ConfigFxToolTip");
                }
                t.setToolTipText(tooltip);
                c.setToolTipText(tooltip);
                l.setToolTipText(tooltip);
            }
            this.labels[i - this.MIN_OPTION] = l;
            gl.setConstraints(l, gc);
            options.add(l);
            ++gc.gridy;
            ++i;
        }
        JScrollPane js = new JScrollPane(options);
        js.setVerticalScrollBarPolicy(20);
        js.setHorizontalScrollBarPolicy(30);
        this.add(js);
        this.optionBox.addActionListener(e -> this.updateVisibility(this.optionBox.isSelected()));
        this.readButton.addActionListener(e -> this.readButtonActionPerformed(e));
        this.writeButton.addActionListener(e -> this.writeButtonActionPerformed(e));
        this.updateVisibility(this.optionBox.isSelected());
        memo.getLnTrafficController().addLocoNetListener(-1, this);
        this.start();
    }

    void updateVisibility(boolean show) {
        int i = this.MIN_OPTION;
        while (i <= this.MAX_OPTION) {
            if (this.isReserved[i - this.MIN_OPTION]) {
                this.closedButtons[i - this.MIN_OPTION].setVisible(show);
                this.thrownButtons[i - this.MIN_OPTION].setVisible(show);
                this.labels[i - this.MIN_OPTION].setVisible(show);
            }
            ++i;
        }
        this.revalidate();
    }

    public void readButtonActionPerformed(ActionEvent e) {
        this.start();
    }

    public void writeButtonActionPerformed(ActionEvent e) {
        LocoNetMessage msg = new LocoNetMessage(14);
        msg.setElement(0, 239);
        msg.setElement(1, 14);
        msg.setElement(2, this.CONFIG_SLOT);
        int i = 0;
        while (i < 10) {
            msg.setElement(3 + i, this.oldcontent[i]);
            ++i;
        }
        i = 0;
        while (i <= this.MAX_OPTION - this.MIN_OPTION) {
            int byteIndex = i / 8;
            if (byteIndex > 3) {
                ++byteIndex;
            }
            byteIndex += 3;
            int bitIndex = i % 8;
            int bitMask = 1 << bitIndex;
            if (this.closedButtons[i].isSelected()) {
                msg.setElement(byteIndex, msg.getElement(byteIndex) | bitMask);
            } else {
                msg.setElement(byteIndex, msg.getElement(byteIndex) & ~bitMask);
            }
            ++i;
        }
        this.memo.getLnTrafficController().sendLocoNetMessage(msg);
    }

    public void start() {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setElement(0, 187);
        l.setElement(1, this.CONFIG_SLOT);
        l.setElement(2, 0);
        l.setElement(3, 0);
        this.memo.getLnTrafficController().sendLocoNetMessage(l);
    }

    @Override
    public void message(LocoNetMessage msg) {
        if (msg.getOpCode() != 231) {
            return;
        }
        if (msg.getElement(2) != this.CONFIG_SLOT) {
            return;
        }
        int i = 0;
        while (i < 10) {
            this.oldcontent[i] = msg.getElement(3 + i);
            ++i;
        }
        i = 0;
        while (i <= this.MAX_OPTION - this.MIN_OPTION) {
            int byteIndex = i / 8;
            if (byteIndex > 3) {
                ++byteIndex;
            }
            int bitIndex = i % 8;
            int bitMask = 1 << bitIndex;
            int data = msg.getElement(byteIndex += 3);
            if ((data & bitMask) != 0) {
                this.closedButtons[i].setSelected(true);
            } else {
                this.thrownButtons[i].setSelected(true);
            }
            ++i;
        }
        log.debug("Config Slot Data: {}", (Object)msg);
    }

    @Override
    public void dispose() {
        this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        super.dispose();
    }
}

