/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.bluetooth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.bluetooth.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetBluetoothAdapter
extends LnPortController {
    Vector<String> portNameVector = null;
    private boolean opened = false;
    private InputStream in = null;
    private OutputStream out = null;
    private static final Logger log = LoggerFactory.getLogger(LocoNetBluetoothAdapter.class);

    public LocoNetBluetoothAdapter() {
        this(new LocoNetSystemConnectionMemo());
    }

    public LocoNetBluetoothAdapter(LocoNetSystemConnectionMemo adapterMemo) {
        super(adapterMemo);
        this.option1Name = "CommandStation";
        this.option2Name = "TurnoutHandle";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationNames, false));
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("TurnoutHandling"), new String[]{Bundle.getMessage("HandleNormal"), Bundle.getMessage("HandleSpread"), Bundle.getMessage("HandleOneOnly"), Bundle.getMessage("HandleBoth")}));
    }

    @Override
    public Vector<String> getPortNames() {
        this.portNameVector = new Vector();
        try {
            RemoteDevice[] devices = LocalDevice.getLocalDevice().getDiscoveryAgent().retrieveDevices(1);
            if (devices != null) {
                RemoteDevice[] remoteDeviceArray = devices;
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteDevice device = remoteDeviceArray[n2];
                    this.portNameVector.add(device.getFriendlyName(false));
                    ++n2;
                }
            }
        }
        catch (IOException ex) {
            log.error("Unable to use bluetooth device", (Throwable)ex);
        }
        return this.portNameVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String openPort(String portName, String appName) {
        Exception[] exception;
        int[] responseCode;
        block20: {
            responseCode = new int[]{-1};
            exception = new Exception[1];
            try {
                RemoteDevice[] devices = LocalDevice.getLocalDevice().getDiscoveryAgent().retrieveDevices(1);
                if (devices == null) break block20;
                RemoteDevice[] remoteDeviceArray = devices;
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteDevice device = remoteDeviceArray[n2];
                    if (device.getFriendlyName(false).equals(portName)) {
                        final Object[] waitObj = new Object[]{};
                        LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(new int[]{256}, new UUID[]{new UUID(4353L)}, device, new DiscoveryListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
                                Object[] objectArray = waitObj;
                                synchronized (waitObj) {
                                    ServiceRecord[] serviceRecordArray = servRecord;
                                    int n = servRecord.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        block9: {
                                            ServiceRecord service = serviceRecordArray[n2];
                                            String url = service.getConnectionURL(0, false);
                                            if (url != null) {
                                                try {
                                                    Connection conn = Connector.open((String)url, (int)3);
                                                    if (conn instanceof StreamConnection) {
                                                        StreamConnection stream = (StreamConnection)conn;
                                                        LocoNetBluetoothAdapter.this.in = stream.openInputStream();
                                                        LocoNetBluetoothAdapter.this.out = stream.openOutputStream();
                                                        LocoNetBluetoothAdapter.this.opened = true;
                                                        break block9;
                                                    }
                                                    throw new IOException("Could not establish a two-way communication");
                                                }
                                                catch (IOException IOe) {
                                                    exception[0] = IOe;
                                                }
                                            }
                                        }
                                        ++n2;
                                    }
                                    if (!LocoNetBluetoothAdapter.this.opened) {
                                        exception[0] = new IOException("No service found to connect to");
                                    }
                                    // ** MonitorExit[var3_3] (shouldn't be in output)
                                    return;
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void serviceSearchCompleted(int transID, int respCode) {
                                Object[] objectArray = waitObj;
                                synchronized (waitObj) {
                                    responseCode[0] = respCode;
                                    waitObj.notify();
                                    // ** MonitorExit[var3_3] (shouldn't be in output)
                                    return;
                                }
                            }

                            public void inquiryCompleted(int discType) {
                            }

                            public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
                            }
                        });
                        Object[] objectArray = waitObj;
                        // MONITORENTER : waitObj
                        while (true) {
                            if (this.opened || responseCode[0] != -1) {
                                // MONITOREXIT : objectArray
                                break block20;
                            }
                            try {
                                waitObj.wait();
                            }
                            catch (InterruptedException ex) {
                                log.error("Thread unexpectedly interrupted", (Throwable)ex);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (BluetoothStateException BSe) {
                log.error("Exception when using bluetooth");
                return BSe.getLocalizedMessage();
            }
            catch (IOException IOe) {
                log.error("Unknown IOException when establishing connection to {}", (Object)portName);
                return IOe.getLocalizedMessage();
            }
        }
        if (this.opened) return null;
        ConnectionStatus.instance().setConnectionState(null, portName, "Not Connected");
        if (exception[0] != null) {
            log.error("Exception when connecting to {}", (Object)portName);
            return exception[0].getLocalizedMessage();
        }
        switch (responseCode[0]) {
            case 1: {
                log.error("Bluetooth connection {} not opened, unknown error", (Object)portName);
                return "Unknown error: failed to connect to " + portName;
            }
            case 6: {
                log.error("Bluetooth device {} could not be reached", (Object)portName);
                return "Could not find " + portName;
            }
            case 3: {
                log.error("Error when searching for {}", (Object)portName);
                return "Error when searching for " + portName;
            }
            case 4: {
                log.error("No serial service found on {}", (Object)portName);
                return "Invalid bluetooth device: " + portName;
            }
            case 2: {
                log.error("Service search on {} ended prematurely", (Object)portName);
                return "Search for " + portName + " ended unexpectedly";
            }
        }
        log.warn("Unhandled response code: {}", (Object)responseCode[0]);
        log.error("Unknown error when connecting to {}", (Object)portName);
        return "Unknown error when connecting to " + portName;
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option1Name));
        this.setTurnoutHandling(this.getOptionState(this.option2Name));
        LnPacketizer packets = new LnPacketizer(this.getSystemConnectionMemo());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.in);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return new DataOutputStream(this.out);
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }
}

