/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.bluetooth;

import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import jmri.jmrix.AbstractSerialConnectionConfig;
import jmri.jmrix.SerialPortAdapter;
import jmri.jmrix.loconet.bluetooth.LocoNetBluetoothAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfig
extends AbstractSerialConnectionConfig {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);

    public ConnectionConfig(SerialPortAdapter p) {
        super(p);
    }

    public ConnectionConfig() {
    }

    @Override
    public String name() {
        return "BT Locobridge";
    }

    @Override
    protected void setInstance() {
        if (this.adapter == null) {
            this.adapter = new LocoNetBluetoothAdapter();
        }
    }

    @Override
    protected void showAdvancedItems() {
        super.showAdvancedItems();
        this._details.remove(this.baudBoxLabel);
        this._details.remove(this.baudBox);
        this.portBoxLabel.setText("Bluetooth adapter: ");
    }

    @Override
    protected int addStandardDetails(boolean incAdvanced, int i) {
        int out = super.addStandardDetails(incAdvanced, i);
        this._details.remove(this.baudBoxLabel);
        this._details.remove(this.baudBox);
        this.portBoxLabel.setText("Bluetooth adapter: ");
        return out;
    }

    @Override
    protected Vector<String> getPortNames() {
        Vector<String> portNameVector = new Vector<String>();
        try {
            RemoteDevice[] devices;
            RemoteDevice[] remoteDeviceArray = devices = LocalDevice.getLocalDevice().getDiscoveryAgent().retrieveDevices(1);
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteDevice device = remoteDeviceArray[n2];
                portNameVector.add(device.getFriendlyName(false));
                ++n2;
            }
        }
        catch (IOException ex) {
            log.error("Unable to use bluetooth device", (Throwable)ex);
        }
        return portNameVector;
    }

    @Override
    protected String[] getPortFriendlyNames() {
        return new String[0];
    }
}

