/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.SlotManager;
import jmri.jmrix.loconet.UhlenbrockSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UhlenbrockSlotManager
extends SlotManager {
    private static final Logger log = LoggerFactory.getLogger(UhlenbrockSlotManager.class);

    public UhlenbrockSlotManager(LnTrafficController tc) {
        super(tc);
    }

    @Override
    protected void loadSlots() {
        int i = 0;
        while (i < 128) {
            this._slots[i] = new UhlenbrockSlot(i);
            ++i;
        }
    }

    @Override
    protected boolean checkLackByte1(int Byte1) {
        return (Byte1 & 0xED) == 109;
    }

    @Override
    protected boolean checkLackTaskAccepted(int Byte2) {
        return Byte2 == 1 || Byte2 == 35 || Byte2 == 43 || Byte2 == 107;
    }

    @Override
    protected boolean checkLackAcceptedBlind(int Byte2) {
        return Byte2 == 64 || Byte2 == 127;
    }

    @Override
    public void message(LocoNetMessage m) {
        UhlenbrockSlot slot;
        if (m.getOpCode() == 163) {
            slot = (UhlenbrockSlot)this.slot(m.getElement(1));
            slot.iB2functionMessage(m);
        }
        if (m.getOpCode() == 212 && m.getElement(1) == 32) {
            slot = (UhlenbrockSlot)this.slot(m.getElement(2));
            slot.iBfunctionMessage(m);
        }
        super.message(m);
    }

    protected LocoNetMessage progOnMainMessage(int hopsa, int lopsa, int val, int cvnum) {
        LocoNetMessage m = new LocoNetMessage(31);
        m.setOpCode(237);
        m.setElement(1, 31);
        m.setElement(2, 1);
        m.setElement(3, 73);
        m.setElement(4, 66);
        m.setElement(5, 0x71 | (hopsa & 1) << 1 | (cvnum & 0x80) >> 4);
        m.setElement(6, 94);
        m.setElement(7, lopsa);
        m.setElement(8, hopsa / 2);
        m.setElement(9, cvnum & 0x7F);
        m.setElement(10, 0x70 | (val & 0x80) >> 6);
        m.setElement(11, cvnum / 256);
        m.setElement(12, val & 0x7F);
        m.setElement(15, 16);
        return m;
    }

    protected LocoNetMessage progOnProgrammingTrackMessage(int element6, int val, int cvnum) {
        LocoNetMessage m = new LocoNetMessage(31);
        m.setOpCode(237);
        m.setElement(1, 31);
        m.setElement(2, 1);
        m.setElement(3, 73);
        m.setElement(4, 66);
        m.setElement(5, 0x71 | (val & 0x80) >> 4 | (cvnum & 0x80) >> 6);
        m.setElement(6, element6);
        m.setElement(7, cvnum & 0x7F);
        m.setElement(8, cvnum / 256);
        m.setElement(9, val & 0x7F);
        m.setElement(10, 112);
        m.setElement(15, 16);
        return m;
    }

    @Override
    protected LocoNetMessage progTaskStart(int pcmd, int val, int cvnum, boolean write) {
        switch (pcmd) {
            case 103: {
                return this.progOnMainMessage(this.hopsa, this.lopsa, val, cvnum);
            }
            case 99: {
                return this.progOnProgrammingTrackMessage(111, val, cvnum);
            }
            case 107: {
                return this.progOnProgrammingTrackMessage(113, val, cvnum);
            }
            case 83: {
                return this.progOnProgrammingTrackMessage(109, val, cvnum);
            }
            case 35: {
                return this.progOnProgrammingTrackMessage(110, 0, cvnum);
            }
            case 43: {
                return this.progOnProgrammingTrackMessage(114, 0, cvnum);
            }
            case 19: {
                return this.progOnProgrammingTrackMessage(108, 0, cvnum);
            }
        }
        log.warn("Unhandled programming type: {}", (Object)pcmd);
        return this.stopIBComPT();
    }

    protected LocoNetMessage startIBComPT() {
        LocoNetMessage m = new LocoNetMessage(7);
        m.setOpCode(229);
        m.setElement(1, 7);
        m.setElement(2, 1);
        m.setElement(3, 73);
        m.setElement(4, 66);
        m.setElement(5, 65);
        return m;
    }

    protected LocoNetMessage stopIBComPT() {
        LocoNetMessage m = new LocoNetMessage(7);
        m.setOpCode(229);
        m.setElement(1, 7);
        m.setElement(2, 1);
        m.setElement(3, 73);
        m.setElement(4, 66);
        m.setElement(5, 64);
        return m;
    }

    @Override
    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        super.useProgrammer(p);
        this.tc.sendLocoNetMessage(this.startIBComPT());
    }

    @Override
    protected synchronized void doEndOfProgramming() {
        log.debug("Uhlenbrock doEndOfProgramming");
        this.tc.sendLocoNetMessage(this.stopIBComPT());
    }
}

