/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.CsOpSwAccess;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetException;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.LocoNetThrottledTransmitter;
import jmri.jmrix.loconet.SlotListener;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotManager
extends AbstractProgrammer
implements LocoNetListener,
CommandStation {
    public static int postProgDelay = 100;
    public int slotScanInterval = 50;
    public List<SlotMapEntry> slotMap = new ArrayList<SlotMapEntry>();
    protected LnTrafficController tc;
    protected static final int NUM_SLOTS = 128;
    protected final LocoNetSlot[] _slots = new LocoNetSlot[128];
    Timer staleSlotCheckTimer = null;
    Hashtable<Integer, SlotListener> mLocoAddrHash = new Hashtable();
    private final Vector<SlotListener> slotListeners = new Vector();
    LocoNetMessage immedPacket;
    private boolean acceptAnyLACK = false;
    ProgrammingMode csOpSwProgrammingMode = new ProgrammingMode("LOCONETCSOPSWMODE", Bundle.getMessage("LOCONETCSOPSWMODE"));
    private boolean mProgEndSequence = false;
    private boolean mCanRead = true;
    LocoNetThrottledTransmitter throttledTransmitter = null;
    boolean mTurnoutNoRetry = false;
    protected LnCommandStationType commandStationType = null;
    int progState = 0;
    boolean _progRead = false;
    boolean _progConfirm = false;
    int _confirmVal;
    boolean mServiceMode = true;
    int hopsa;
    int lopsa;
    CsOpSwAccess csOpSwAccessor;
    private ProgListener _usingProgrammer = null;
    Timer mPowerTimer = null;
    protected int nextReadSlot = 0;
    LocoNetSystemConnectionMemo adaptermemo;
    boolean transpondingAvailable = false;
    private static final Logger log = LoggerFactory.getLogger(SlotManager.class);

    public SlotManager(LnTrafficController tc) {
        this.tc = tc;
        this.LONG_TIMEOUT = 180000;
        this.SHORT_TIMEOUT = 8000;
        this.slotMap = Arrays.asList(new SlotMapEntry(0, 127));
        this.loadSlots();
        tc.addLocoNetListener(-1, this);
        this.staleSlotCheckTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlotManager.this.checkStaleSlots();
            }
        });
        this.staleSlotCheckTimer.setRepeats(true);
        this.staleSlotCheckTimer.setInitialDelay(30000);
        this.staleSlotCheckTimer.start();
    }

    protected void loadSlots() {
        int i = 0;
        while (i < 128) {
            this._slots[i] = new LocoNetSlot(i);
            ++i;
        }
    }

    @Override
    public boolean sendPacket(byte[] packet, int sendCount) {
        if (sendCount > 8) {
            log.warn("Ops Mode Accessory Packet 'Send count' reduced from {} to 8.", (Object)sendCount);
            sendCount = 8;
        }
        if (sendCount < 1) {
            log.warn("Ops Mode Accessory Packet 'Send count' of {} is illegal and is forced to 1.", (Object)sendCount);
            sendCount = 1;
        }
        if (packet.length <= 1) {
            log.error("Invalid DCC packet length: {}", (Object)packet.length);
        }
        if (packet.length > 6) {
            log.error("DCC packet length is too great: {} bytes were passed; ignoring the request. ", (Object)packet.length);
        }
        LocoNetMessage m = new LocoNetMessage(11);
        m.setElement(0, 237);
        m.setElement(1, 11);
        m.setElement(2, 127);
        int length = packet.length - 1;
        m.setElement(3, (sendCount - 1 & 7) + 16 * (length & 7));
        int highBits = 0;
        if (length >= 1 && (packet[0] & 0x80) != 0) {
            highBits |= 1;
        }
        if (length >= 2 && (packet[1] & 0x80) != 0) {
            highBits |= 2;
        }
        if (length >= 3 && (packet[2] & 0x80) != 0) {
            highBits |= 4;
        }
        if (length >= 4 && (packet[3] & 0x80) != 0) {
            highBits |= 8;
        }
        if (length >= 5 && (packet[4] & 0x80) != 0) {
            highBits |= 0x10;
        }
        m.setElement(4, highBits);
        m.setElement(5, 0);
        m.setElement(6, 0);
        m.setElement(7, 0);
        m.setElement(8, 0);
        m.setElement(9, 0);
        int i = 0;
        while (i < packet.length - 1) {
            m.setElement(5 + i, packet[i] & 0x7F);
            ++i;
        }
        if (this.throttledTransmitter != null) {
            this.throttledTransmitter.sendLocoNetMessage(m);
        } else {
            this.tc.sendLocoNetMessage(m);
        }
        return true;
    }

    public LocoNetSlot slot(int i) {
        return this._slots[i];
    }

    public void slotFromLocoAddress(int i, SlotListener l) {
        this.mLocoAddrHash.put(i, l);
        LocoNetMessage m = new LocoNetMessage(4);
        m.setOpCode(191);
        m.setElement(1, i / 128 & 0x7F);
        m.setElement(2, i & 0x7F);
        this.tc.sendLocoNetMessage(m);
    }

    private void checkStaleSlots() {
        long staleTimeout = System.currentTimeMillis() - 90000L;
        int i = 1;
        while (i <= 120) {
            LocoNetSlot slot = this._slots[i];
            if ((slot.slotStatus() == 48 || slot.slotStatus() == 16) && slot.getLastUpdateTime() <= staleTimeout) {
                this.sendReadSlot(i);
                break;
            }
            ++i;
        }
    }

    public synchronized void addSlotListener(SlotListener l) {
        if (!this.slotListeners.contains(l)) {
            this.slotListeners.addElement(l);
        }
    }

    public synchronized void removeSlotListener(SlotListener l) {
        if (this.slotListeners.contains(l)) {
            this.slotListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(LocoNetSlot s) {
        Vector v;
        SlotManager slotManager = this;
        synchronized (slotManager) {
            v = (Vector)this.slotListeners.clone();
        }
        log.debug("notify {} SlotListeners about slot {}", (Object)v.size(), (Object)s.getSlot());
        int cnt = v.size();
        int i = 0;
        while (i < cnt) {
            SlotListener client = (SlotListener)v.elementAt(i);
            client.notifyChangedSlot(s);
            ++i;
        }
    }

    @Override
    public void message(LocoNetMessage m) {
        if (m.getOpCode() == 138) {
            if (this.commandStationType.getSupportsLocoReset()) {
                Timer t = new Timer(500, e -> {
                    log.debug("Updating slots account received opcode 0x8a message");
                    this.update(this.slotMap, this.slotScanInterval);
                });
                t.stop();
                t.setInitialDelay(500);
                t.setRepeats(false);
                t.start();
            }
            return;
        }
        if (!this.mTurnoutNoRetry && this.immedPacket != null && m.getOpCode() == 180 && m.getElement(1) == 109 && m.getElement(2) == 0) {
            this.tc.sendLocoNetMessage(this.immedPacket);
            this.immedPacket = null;
        }
        this.immedPacket = m.getOpCode() == 237 && m.getElement(1) == 11 && m.getElement(2) == 127 ? m : null;
        int i = this.findSlotFromMessage(m);
        if (i != -1) {
            this.getMoreDetailsForSlot(m, i);
            this.forwardMessageToSlot(m, i);
            this.respondToAddrRequest(m, i);
            this.programmerOpMessage(m, i);
        }
        if (m.getOpCode() == 180) {
            this.handleLongAck(m);
        }
        if (this.isExtFunctionMessage(m)) {
            int addr = this.getDirectFunctionAddress(m);
            boolean found = false;
            int j = 0;
            while (j < 120) {
                LocoNetSlot slot = this.slot(j);
                if (slot != null && slot.locoAddr() == addr && slot.slotStatus() != 0) {
                    slot.functionMessage(this.getDirectDccPacket(m));
                    found = true;
                }
                ++j;
            }
            if (!found) {
                LocoNetMessage mo = new LocoNetMessage(4);
                mo.setOpCode(191);
                mo.setElement(1, addr / 128 & 0x7F);
                mo.setElement(2, addr & 0x7F);
                this.tc.sendLocoNetMessage(mo);
            }
        }
    }

    int getDirectFunctionAddress(LocoNetMessage m) {
        if (m.getOpCode() != 237) {
            return -1;
        }
        if (m.getElement(1) != 11) {
            return -1;
        }
        if (m.getElement(2) != 127) {
            return -1;
        }
        if ((m.getElement(3) & 0x70) < 32) {
            return -1;
        }
        int addr = -1;
        if ((m.getElement(4) & 1) == 0) {
            addr = m.getElement(5) & 0xFF;
            if ((m.getElement(4) & 1) != 0) {
                addr += 128;
            }
        } else if ((m.getElement(5) & 0x40) == 64) {
            addr = (m.getElement(5) & 0x3F) * 256 + (m.getElement(6) & 0xFF);
            if ((m.getElement(4) & 2) != 0) {
                addr += 128;
            }
        } else {
            addr = m.getElement(5) & 0x3F;
        }
        return addr;
    }

    int getDirectDccPacket(LocoNetMessage m) {
        int start;
        if (m.getOpCode() != 237) {
            return -1;
        }
        if (m.getElement(1) != 11) {
            return -1;
        }
        if (m.getElement(2) != 127) {
            return -1;
        }
        if ((m.getElement(3) & 0x70) < 32) {
            return -1;
        }
        int result = 0;
        int n = (m.getElement(3) & 0xF0) / 16;
        int high = m.getElement(4);
        if ((m.getElement(4) & 1) == 1 && (m.getElement(5) & 0x40) == 64) {
            start = 7;
            high >>= 2;
            n -= 2;
        } else {
            start = 6;
            high >>= 1;
            --n;
        }
        int i = 0;
        while (i < n) {
            result = result * 256 + (m.getElement(start + i) & 0x7F);
            if ((high & 1) != 0) {
                result += 128;
            }
            high >>= 1;
            ++i;
        }
        return result;
    }

    boolean isExtFunctionMessage(LocoNetMessage m) {
        int pkt = this.getDirectDccPacket(m);
        if (pkt < 0) {
            return false;
        }
        if ((pkt & 0xFFFFFF0) == 160) {
            return true;
        }
        return (pkt & 0xFFFFFE00) == 56832;
    }

    public int findSlotFromMessage(LocoNetMessage m) {
        int i = -1;
        switch (m.getOpCode()) {
            case 231: 
            case 239: {
                i = m.getElement(2);
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 181: 
            case 184: 
            case 185: {
                i = m.getElement(1);
                break;
            }
            case 186: {
                if (m.getElement(1) == 0) break;
                i = m.getElement(1);
                return i;
            }
            default: {
                return i;
            }
        }
        return i;
    }

    protected boolean checkLackByte1(int Byte1) {
        return (Byte1 & 0xEF) == 111;
    }

    protected boolean checkLackTaskAccepted(int Byte2) {
        return Byte2 == 1 || Byte2 == 35 || Byte2 == 43 || Byte2 == 107 || Byte2 == 127;
    }

    protected boolean checkLackProgrammerBusy(int Byte2) {
        return Byte2 == 0;
    }

    protected boolean checkLackAcceptedBlind(int Byte2) {
        return Byte2 == 64;
    }

    public final void setAcceptAnyLACK() {
        this.acceptAnyLACK = true;
    }

    protected void handleLongAck(LocoNetMessage m) {
        log.debug("LACK in state {} message: {}", (Object)this.progState, (Object)m.toString());
        if (this.checkLackByte1(m.getElement(1)) && this.progState == 1) {
            if (this.acceptAnyLACK) {
                if (this._progRead || this._progConfirm) {
                    this.startShortTimer();
                    this.progState = 2;
                } else {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEndAfterDelay();
                }
                this.acceptAnyLACK = false;
            } else if (this.checkLackTaskAccepted(m.getElement(2))) {
                log.debug("LACK accepted, next state 2");
                if ((this._progRead || this._progConfirm) && this.mServiceMode) {
                    this.startLongTimer();
                } else {
                    this.startShortTimer();
                }
                this.progState = 2;
            } else if (this.checkLackProgrammerBusy(m.getElement(2))) {
                this.progState = 0;
                this.stopTimer();
                this.notifyProgListenerLack(4);
            } else if (this.checkLackAcceptedBlind(m.getElement(2))) {
                if ((this._progRead || this._progConfirm) && !this.mServiceMode) {
                    log.debug("LACK accepted (ignoring incorrect OpSw), next state 2");
                    this.startShortTimer();
                    this.progState = 2;
                } else {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEndAfterDelay();
                }
            } else {
                log.warn("unexpected LACK reply code {}", (Object)m.getElement(2));
                this.progState = 0;
                this.stopTimer();
                this.notifyProgListenerLack(1);
            }
        }
    }

    protected void notifyProgListenerEndAfterDelay() {
        Timer timer = new Timer(postProgDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlotManager.this.notifyProgListenerEnd(-1, 0);
            }
        });
        timer.stop();
        timer.setInitialDelay(postProgDelay);
        timer.setRepeats(false);
        timer.start();
    }

    public void forwardMessageToSlot(LocoNetMessage m, int i) {
        if (i >= this._slots.length || i < 0) {
            log.error("Received slot number {} is greater than array length {} Message was {}", new Object[]{i, this._slots.length, m.toString()});
            return;
        }
        try {
            this._slots[i].setSlot(m);
        }
        catch (LocoNetException locoNetException) {
            log.error("slot rejected LocoNetMessage {}", (Object)m);
            return;
        }
        this.notify(this._slots[i]);
    }

    protected void respondToAddrRequest(LocoNetMessage m, int i) {
        if (m.getOpCode() == 231) {
            int addr = this._slots[i].locoAddr();
            log.debug("LOCO_ADR resp is slot {} for addr {}", (Object)i, (Object)addr);
            SlotListener l = this.mLocoAddrHash.get(addr);
            if (l != null) {
                this.mLocoAddrHash.remove(addr);
                log.debug("notify listener");
                l.notifyChangedSlot(this._slots[i]);
            } else {
                log.debug("no request for addr {}", (Object)addr);
            }
        }
    }

    protected void getMoreDetailsForSlot(LocoNetMessage m, int i) {
        if (m.getOpCode() == 181 && (m.getElement(2) & 0x30) == 16) {
            this.sendReadSlotDelayed(i, 100L);
        } else if (m.getOpCode() == 186) {
            int slotTwo = m.getElement(2);
            if (i != 0 && slotTwo != 0 && i != slotTwo) {
                this.sendReadSlotDelayed(i, 100L);
            }
        } else if (m.getOpCode() == 185 || m.getOpCode() == 184) {
            int slotTwo = m.getElement(2);
            if (i != 0 && slotTwo != 0) {
                this.sendReadSlotDelayed(slotTwo, 100L);
            }
        }
    }

    protected void sendReadSlotDelayed(int slotNo, long delay) {
        TimerTask meterTask = new TimerTask(slotNo){
            int slotNumber;
            {
                this.slotNumber = n;
            }

            @Override
            public void run() {
                try {
                    SlotManager.this.sendReadSlot(this.slotNumber);
                }
                catch (Exception e) {
                    log.error("Exception occurred sendReadSlotDelayed:", (Throwable)e);
                }
            }
        };
        TimerUtil.schedule(meterTask, delay);
    }

    protected void programmerOpMessage(LocoNetMessage m, int i) {
        if (i == 124) {
            log.debug("Prog Message {} for slot 124 in state {}", (Object)m.getOpCodeHex(), (Object)this.progState);
            switch (this.progState) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (m.getOpCode() != 231) break;
                    log.debug("  was OPC_SL_RD_DATA");
                    this.stopTimer();
                    this.progState = 0;
                    int value = -1;
                    int status = 0;
                    if (this._progConfirm && (value = this._slots[i].cvval()) != this._confirmVal) {
                        status |= 0x40;
                    }
                    if (this._progRead) {
                        value = this._slots[i].cvval();
                    }
                    if ((this._slots[i].pcmd() & 1) != 0) {
                        status |= 2;
                    }
                    if ((this._slots[i].pcmd() & 2) != 0) {
                        status |= 0x20;
                    }
                    if ((this._slots[i].pcmd() & 4) != 0) {
                        status |= 0x20;
                    }
                    if ((this._slots[i].pcmd() & 8) != 0) {
                        status |= 0x10;
                    }
                    this.notifyProgListenerEnd(value, status);
                    break;
                }
                default: {
                    log.error("unexpected programming state {}", (Object)this.progState);
                }
            }
        }
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        ret.add(ProgrammingMode.PAGEMODE);
        ret.add(ProgrammingMode.REGISTERMODE);
        ret.add(ProgrammingMode.ADDRESSMODE);
        ret.add(this.csOpSwProgrammingMode);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return this.mCanRead;
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        return Programmer.WriteConfirmMode.DecoderReply;
    }

    public void setCommandStationType(LnCommandStationType value) {
        this.commandStationType = value;
        this.mCanRead = value.getCanRead();
        this.mProgEndSequence = value.getProgPowersOff();
    }

    public void setThrottledTransmitter(LocoNetThrottledTransmitter value, boolean m) {
        this.throttledTransmitter = value;
        this.mTurnoutNoRetry = m;
    }

    public LnCommandStationType getCommandStationType() {
        return this.commandStationType;
    }

    @Override
    protected synchronized void timeout() {
        log.debug("timeout fires in state {}", (Object)this.progState);
        if (this.progState != 0) {
            log.debug("timeout while programming");
            this.progState = 0;
            if (this.progState == 2 && !this.mServiceMode) {
                this.notifyProgListenerEnd(this._slots[124].cvval(), 32);
            } else {
                this.notifyProgListenerEnd(this._slots[124].cvval(), 128);
            }
            this.acceptAnyLACK = false;
        }
    }

    public void writeCVOpsMode(String CVname, int val, ProgListener p, int addr, boolean longAddr) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        this.lopsa = addr & 0x7F;
        this.hopsa = addr / 128 & 0x7F;
        this.mServiceMode = false;
        this.doWrite(CV, val, p, 103);
    }

    @Override
    public void writeCV(String cvNum, int val, ProgListener p) throws ProgrammerException {
        log.debug("writeCV(string): cvNum={}, value={}", (Object)cvNum, (Object)val);
        if (this.getMode().equals(this.csOpSwProgrammingMode)) {
            log.debug("cvOpSw mode write!");
            String[] parts = cvNum.split("\\.");
            if (parts[0].equals("csOpSw") && parts.length == 2) {
                if (this.csOpSwAccessor == null) {
                    this.csOpSwAccessor = new CsOpSwAccess(this.adaptermemo, p);
                } else {
                    this.csOpSwAccessor.setProgrammerListener(p);
                }
                log.debug("going to try the opsw access");
                this.csOpSwAccessor.writeCsOpSw(cvNum, val, p);
                return;
            }
            log.warn("rejecting the cs opsw access account unsupported CV name format");
            this.notifyProgListenerEnd(p, 1, 512);
            return;
        }
        int CV = Integer.parseInt(cvNum);
        this.lopsa = 0;
        this.hopsa = 0;
        this.mServiceMode = true;
        int pcmd = 67;
        if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
            pcmd |= 0x20;
        } else if (this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            pcmd |= 0x28;
        } else if (this.getMode().equals(ProgrammingMode.REGISTERMODE) || this.getMode().equals(ProgrammingMode.ADDRESSMODE)) {
            pcmd |= 0x10;
        } else {
            throw new ProgrammerException("mode not supported");
        }
        this.doWrite(CV, val, p, pcmd);
    }

    public void doWrite(int CV, int val, ProgListener p, int pcmd) throws ProgrammerException {
        log.debug("writeCV: {}", (Object)CV);
        this.stopEndOfProgrammingTimer();
        this.useProgrammer(p);
        this._progRead = false;
        this._progConfirm = false;
        this.progState = 1;
        this.startShortTimer();
        this.tc.sendLocoNetMessage(this.progTaskStart(pcmd, val, CV, true));
    }

    public void confirmCVOpsMode(String CVname, int val, ProgListener p, int addr, boolean longAddr) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        this.lopsa = addr & 0x7F;
        this.hopsa = addr / 128 & 0x7F;
        this.mServiceMode = false;
        this.doConfirm(CV, val, p, 47);
    }

    @Override
    public void confirmCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        this.lopsa = 0;
        this.hopsa = 0;
        this.mServiceMode = true;
        if (this.getMode().equals(this.csOpSwProgrammingMode)) {
            log.debug("cvOpSw mode!");
            String[] parts = CVname.split("\\.");
            if (parts[0].equals("csOpSw") && parts.length == 2) {
                if (this.csOpSwAccessor == null) {
                    this.csOpSwAccessor = new CsOpSwAccess(this.adaptermemo, p);
                } else {
                    this.csOpSwAccessor.setProgrammerListener(p);
                }
                log.debug("going to try the opsw access");
                this.csOpSwAccessor.readCsOpSw(CVname, p);
                return;
            }
            log.warn("rejecting the cs opsw access account unsupported CV name format");
            this.notifyProgListenerEnd(p, 1, 512);
            return;
        }
        int pcmd = 3;
        if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
            pcmd |= 0x20;
        } else if (this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            pcmd |= 0x28;
        } else if (this.getMode().equals(ProgrammingMode.REGISTERMODE) || this.getMode().equals(ProgrammingMode.ADDRESSMODE)) {
            pcmd |= 0x10;
        } else {
            throw new ProgrammerException("mode not supported");
        }
        this.doConfirm(CV, val, p, pcmd);
    }

    public void doConfirm(int CV, int val, ProgListener p, int pcmd) throws ProgrammerException {
        log.debug("confirmCV: {}, val: {}", (Object)CV, (Object)val);
        this.stopEndOfProgrammingTimer();
        this.useProgrammer(p);
        this._progRead = false;
        this._progConfirm = true;
        this._confirmVal = val;
        this.progState = 1;
        this.startShortTimer();
        this.tc.sendLocoNetMessage(this.progTaskStart(pcmd, val, CV, false));
    }

    @Override
    public void readCV(String cvNum, ProgListener p) throws ProgrammerException {
        this.readCV(cvNum, p, 0);
    }

    @Override
    public void readCV(String cvNum, ProgListener p, int startVal) throws ProgrammerException {
        log.debug("readCV(string): cvNum={}, startVal={}, mode={}", new Object[]{cvNum, startVal, this.getMode()});
        if (this.getMode().equals(this.csOpSwProgrammingMode)) {
            log.debug("cvOpSw mode!");
            String[] parts = cvNum.split("\\.");
            if (parts[0].equals("csOpSw") && parts.length == 2) {
                if (this.csOpSwAccessor == null) {
                    this.csOpSwAccessor = new CsOpSwAccess(this.adaptermemo, p);
                } else {
                    this.csOpSwAccessor.setProgrammerListener(p);
                }
                log.debug("going to try the opsw access");
                this.csOpSwAccessor.readCsOpSw(cvNum, p);
                return;
            }
            log.warn("rejecting the cs opsw access account unsupported CV name format");
            this.notifyProgListenerEnd(p, 1, 512);
            return;
        }
        int CV = Integer.parseInt(cvNum);
        this.lopsa = 0;
        this.hopsa = 0;
        this.mServiceMode = true;
        int pcmd = 3;
        if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
            pcmd |= 0x20;
        } else if (this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            pcmd |= 0x28;
        } else if (this.getMode().equals(ProgrammingMode.REGISTERMODE) || this.getMode().equals(ProgrammingMode.ADDRESSMODE)) {
            pcmd |= 0x10;
        } else {
            throw new ProgrammerException("mode not supported");
        }
        this.doRead(CV, p, pcmd, startVal);
    }

    public void readCVOpsMode(String CVname, ProgListener p, int addr, boolean longAddr) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        this.lopsa = addr & 0x7F;
        this.hopsa = addr / 128 & 0x7F;
        this.mServiceMode = false;
        this.doRead(CV, p, 47, 0);
    }

    void doRead(int CV, ProgListener p, int progByte, int startVal) throws ProgrammerException {
        log.debug("readCV: {} with startVal: {}", (Object)CV, (Object)startVal);
        this.stopEndOfProgrammingTimer();
        this.useProgrammer(p);
        this._progRead = true;
        this._progConfirm = false;
        this.progState = 1;
        this.startShortTimer();
        this.tc.sendLocoNetMessage(this.progTaskStart(progByte, startVal, CV, false));
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    protected LocoNetMessage progTaskStart(int pcmd, int val, int cvnum, boolean write) {
        int addr = cvnum - 1;
        LocoNetMessage m = new LocoNetMessage(14);
        m.setOpCode(239);
        m.setElement(1, 14);
        m.setElement(2, 124);
        m.setElement(3, pcmd);
        m.setElement(4, 0);
        m.setElement(5, this.hopsa);
        m.setElement(6, this.lopsa);
        m.setElement(7, 0);
        m.setElement(8, (addr & 0x300) >> 4 | (addr & 0x80) >> 7 | (val & 0x80) >> 6);
        m.setElement(9, addr & 0x7F);
        m.setElement(10, val & 0x7F);
        m.setElement(11, 127);
        m.setElement(12, 127);
        return m;
    }

    protected void notifyProgListenerEnd(int value, int status) {
        log.debug("  notifyProgListenerEnd with {}, {} and _usingProgrammer = {}", new Object[]{value, status, this._usingProgrammer});
        this.restartEndOfProgrammingTimer();
        ProgListener p = this._usingProgrammer;
        this._usingProgrammer = null;
        if (p != null) {
            this.sendProgrammingReply(p, value, status);
        }
    }

    protected void notifyProgListenerLack(int status) {
        this.restartEndOfProgrammingTimer();
        this.sendProgrammingReply(this._usingProgrammer, -1, status);
        this._usingProgrammer = null;
    }

    protected void sendProgrammingReply(final ProgListener p, final int value, final int status) {
        int delay = 20;
        if (!this.mServiceMode) {
            delay = 100;
        }
        Timer timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlotManager.this.notifyProgListenerEnd(p, value, status);
            }
        });
        timer.setInitialDelay(delay);
        timer.setRepeats(false);
        timer.start();
    }

    protected void stopEndOfProgrammingTimer() {
        if (this.mPowerTimer != null) {
            this.mPowerTimer.stop();
        }
    }

    protected void restartEndOfProgrammingTimer() {
        if (this.mProgEndSequence) {
            if (this.mPowerTimer == null) {
                this.mPowerTimer = new Timer(10000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SlotManager.this.doEndOfProgramming();
                    }
                });
            }
            this.mPowerTimer.stop();
            this.mPowerTimer.setInitialDelay(10000);
            this.mPowerTimer.setRepeats(false);
            this.mPowerTimer.start();
        }
    }

    protected synchronized void doEndOfProgramming() {
        if (this.progState == 0) {
            if (this.mServiceMode) {
                log.debug("end service-mode programming: turn power on");
                try {
                    InstanceManager.getDefault(PowerManager.class).setPower(2);
                }
                catch (JmriException e) {
                    log.error("exception during power on at end of programming: {}", (Throwable)e);
                }
            } else {
                log.debug("end ops-mode programming: no power change");
            }
        }
    }

    public synchronized void update(List<SlotMapEntry> inputSlotMap, int interval) {
        for (SlotMapEntry item : inputSlotMap) {
            this.nextReadSlot = item.getFrom();
            this.readNextSlot(item.getTo(), interval);
        }
    }

    public void update() {
        this.update(this.slotMap, this.slotScanInterval);
    }

    public void sendReadSlot(int slot) {
        LocoNetMessage m = new LocoNetMessage(4);
        m.setOpCode(187);
        m.setElement(1, slot & 0x7F);
        if (slot > 127) {
            m.setElement(2, slot / 128 & 7);
            m.setElement(2, m.getElement(2) | 0x40);
        } else {
            m.setElement(2, 0);
        }
        this.tc.sendLocoNetMessage(m);
    }

    protected synchronized void readNextSlot(final int toSlot, final int interval) {
        this.sendReadSlot(this.nextReadSlot++);
        if (this.nextReadSlot < toSlot) {
            Timer t = new Timer(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SlotManager.this.readNextSlot(toSlot, interval);
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    public int getInUseCount() {
        int result = 0;
        int i = 0;
        while (i <= 120) {
            if (this.slot(i).slotStatus() == 48) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void setSystemConnectionMemo(LocoNetSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    @Override
    public String getUserName() {
        if (this.adaptermemo == null) {
            return "LocoNet";
        }
        return this.adaptermemo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "L";
        }
        return this.adaptermemo.getSystemPrefix();
    }

    public void setTranspondingAvailable(boolean val) {
        this.transpondingAvailable = val;
    }

    public boolean getTranspondingAvailable() {
        return this.transpondingAvailable;
    }

    public LocoNetSystemConnectionMemo getSystemConnectionMemo() {
        return this.adaptermemo;
    }

    public void dispose() {
        if (this.staleSlotCheckTimer != null) {
            this.staleSlotCheckTimer.stop();
        }
    }

    public static class SlotMapEntry {
        int fromSlot;
        int toSlot;

        public SlotMapEntry(int from, int to) {
            this.fromSlot = from;
            this.toSlot = to;
        }

        public int getFrom() {
            return this.fromSlot;
        }

        public int getTo() {
            return this.toSlot;
        }
    }
}

