/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pr2Throttle
extends AbstractThrottle {
    private final int addr;
    DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(Pr2Throttle.class);

    public Pr2Throttle(LocoNetSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.address = address;
        this.addr = address.getNumber();
        this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
    }

    protected float floatSpeed(int lSpeed) {
        if (lSpeed == 0) {
            return 0.0f;
        }
        if (lSpeed == 1) {
            return -1.0f;
        }
        if (this.getSpeedStepMode() == SpeedStepMode.NMRA_DCC_28) {
            if (lSpeed <= 15) {
                return 0.0f;
            }
            return (float)(lSpeed - 12) / 4.0f / 28.0f;
        }
        if (this.getSpeedStepMode() == SpeedStepMode.NMRA_DCC_14) {
            if (lSpeed <= 15) {
                return 0.0f;
            }
            return (float)(lSpeed - 8) / 8.0f / 14.0f;
        }
        return (float)(lSpeed - 1) / 126.0f;
    }

    @Override
    protected int intSpeed(float fSpeed) {
        if ((double)fSpeed < 0.0) {
            return 1;
        }
        switch (this.getSpeedStepMode()) {
            case NMRA_DCC_28: 
            case MOTOROLA_28: {
                return (int)(fSpeed * 28.0f * 4.0f) + 12;
            }
            case NMRA_DCC_14: {
                return (int)(fSpeed * 14.0f * 8.0f) + 8;
            }
        }
        log.warn("Unhandled speed step mode: {}", (Object)this.getSpeedStepMode());
        return super.intSpeed(fSpeed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData() {
        int speed;
        int stat = 0;
        Pr2Throttle pr2Throttle = this;
        synchronized (pr2Throttle) {
            speed = this.intSpeed(this.speedSetting);
        }
        int dirf = 0;
        if (this.getF0()) {
            dirf |= 0x10;
        }
        if (this.getF1()) {
            dirf |= 1;
        }
        if (this.getF2()) {
            dirf |= 2;
        }
        if (this.getF3()) {
            dirf |= 4;
        }
        if (this.getF4()) {
            dirf |= 8;
        }
        if (!this.getIsForward()) {
            dirf |= 0x20;
        }
        int f11 = 0;
        if (this.getF5()) {
            f11 |= 1;
        }
        if (this.getF6()) {
            f11 |= 2;
        }
        if (this.getF7()) {
            f11 |= 4;
        }
        if (this.getF8()) {
            f11 |= 8;
        }
        if (this.getF9()) {
            f11 |= 0x10;
        }
        if (this.getF10()) {
            f11 |= 0x20;
        }
        if (this.getF11()) {
            f11 |= 0x40;
        }
        int f19 = 0;
        int f27 = 0;
        int f28 = 0;
        if (this.getF12()) {
            f28 |= 0x10;
        }
        LocoNetMessage l = new LocoNetMessage(21);
        l.setOpCode(238);
        int i = 1;
        l.setElement(i++, 21);
        l.setElement(i++, 0);
        l.setElement(i++, 1);
        l.setElement(i++, stat & 0x7F);
        l.setElement(i++, this.addr & 0x7F);
        l.setElement(i++, this.addr / 128 & 0x7F);
        l.setElement(i++, 0);
        l.setElement(i++, speed & 0x7F);
        l.setElement(i++, f28 & 0x7F);
        l.setElement(i++, dirf & 0x7F);
        l.setElement(i++, f11 & 0x7F);
        l.setElement(i++, f19 & 0x7F);
        l.setElement(i++, f27 & 0x7F);
        ((LocoNetSystemConnectionMemo)this.adapterMemo).getLnTrafficController().sendLocoNetMessage(l);
    }

    @Override
    protected void sendFunctionGroup1() {
        this.writeData();
    }

    @Override
    protected void sendFunctionGroup2() {
        this.writeData();
    }

    @Override
    protected void sendFunctionGroup3() {
        this.writeData();
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        this.speedSetting = speed;
        if (speed < 0.0f) {
            this.speedSetting = -1.0f;
        }
        this.writeData();
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        this.sendFunctionGroup1();
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    public String toString() {
        return this.getLocoAddress().toString();
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

