/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.CabSignalManager;
import jmri.ClockControl;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.StringIOManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.debugthrottle.DebugThrottleManager;
import jmri.jmrix.loconet.LnCabSignalManager;
import jmri.jmrix.loconet.LnClockControl;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnLightManager;
import jmri.jmrix.loconet.LnMessageManager;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnPowerManager;
import jmri.jmrix.loconet.LnPredefinedMeters;
import jmri.jmrix.loconet.LnProgrammerManager;
import jmri.jmrix.loconet.LnReporterManager;
import jmri.jmrix.loconet.LnSensorManager;
import jmri.jmrix.loconet.LnStringIOManager;
import jmri.jmrix.loconet.LnThrottleManager;
import jmri.jmrix.loconet.LnThrottleStringIO;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LnTurnoutManager;
import jmri.jmrix.loconet.LncvDevicesManager;
import jmri.jmrix.loconet.LocoNetConsistManager;
import jmri.jmrix.loconet.LocoNetThrottledTransmitter;
import jmri.jmrix.loconet.SlotManager;
import jmri.jmrix.loconet.TranspondingTagManager;
import jmri.jmrix.loconet.swing.LnComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.managers.DefaultProgrammerManager;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    ComponentFactory cf = null;
    private LnTrafficController lt;
    protected LocoNetThrottledTransmitter tm;
    private SlotManager sm;
    private LncvDevicesManager lncvdm = null;
    private LnMessageManager lnm = null;
    protected boolean mTurnoutNoRetry = false;
    protected boolean mTurnoutExtraSpace = false;
    protected LnPredefinedMeters predefinedMeters;
    LnThrottleStringIO throttleStringIO;
    protected static TranspondingTagManager tagManager;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(LocoNetSystemConnectionMemo.class);
    }

    public LocoNetSystemConnectionMemo(LnTrafficController lt, SlotManager sm) {
        super("L", "LocoNet");
        this.lt = lt;
        this.sm = sm;
        this.cf = new LnComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
    }

    public LocoNetSystemConnectionMemo() {
        this("L", "LocoNet");
    }

    public LocoNetSystemConnectionMemo(@Nonnull String prefix, @Nonnull String name) {
        super(prefix, name);
        this.cf = new LnComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
    }

    @Override
    public void register() {
        super.register();
        InstanceManager.store(this, LocoNetSystemConnectionMemo.class);
    }

    public SlotManager getSlotManager() {
        if (this.sm == null) {
            log.debug("slot manager is null, but there should always be a valid SlotManager", (Throwable)new Exception("Traceback"));
        }
        return this.sm;
    }

    public LnTrafficController getLnTrafficController() {
        if (this.lt == null) {
            this.setLnTrafficController(new LnPacketizer(this));
            log.debug("Auto create of LnTrafficController for initial configuration");
        }
        return this.lt;
    }

    public void setLnTrafficController(LnTrafficController lt) {
        this.lt = lt;
    }

    public LnMessageManager getLnMessageManager() {
        if (this.lnm == null) {
            this.lnm = new LnMessageManager(this.getLnTrafficController());
        }
        return this.lnm;
    }

    public DefaultProgrammerManager getProgrammerManager() {
        return (DefaultProgrammerManager)this.classObjectMap.computeIfAbsent(DefaultProgrammerManager.class, c -> new LnProgrammerManager(this));
    }

    public void setProgrammerManager(DefaultProgrammerManager p) {
        this.store(p, DefaultProgrammerManager.class);
    }

    public void setLncvDevicesManager(LncvDevicesManager lncvdm) {
        this.lncvdm = lncvdm;
    }

    public void configureCommandStation(LnCommandStationType type, boolean mTurnoutNoRetry, boolean mTurnoutExtraSpace, boolean mTranspondingAvailable) {
        this.mTurnoutNoRetry = mTurnoutNoRetry;
        this.mTurnoutExtraSpace = mTurnoutExtraSpace;
        if (this.sm != null) {
            log.error("Installing SlotManager twice", (Throwable)new Exception("TraceBack"));
        }
        this.sm = type.getSlotManager(this.lt);
        if (this.sm != null) {
            this.sm.setThrottledTransmitter(this.tm, mTurnoutNoRetry);
            this.sm.setCommandStationType(type);
            this.sm.setSystemConnectionMemo(this);
            this.sm.setTranspondingAvailable(mTranspondingAvailable);
            InstanceManager.store(this.sm, CommandStation.class);
            this.store(this.sm, CommandStation.class);
        }
    }

    @Override
    public void configureManagers() {
        this.tm = new LocoNetThrottledTransmitter(this.getLnTrafficController(), this.mTurnoutExtraSpace);
        log.debug("ThrottleTransmitted configured with: {}", (Object)this.mTurnoutExtraSpace);
        if (this.sm != null) {
            this.sm.setThrottledTransmitter(this.tm, this.mTurnoutNoRetry);
            log.debug("set turnout retry: {}", (Object)this.mTurnoutNoRetry);
        }
        InstanceManager.store(this.getPowerManager(), PowerManager.class);
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setLightManager(this.getLightManager());
        InstanceManager.setDefault(StringIOManager.class, this.getStringIOManager());
        InstanceManager.setThrottleManager(this.getThrottleManager());
        DefaultProgrammerManager programmerManager = this.getProgrammerManager();
        if (programmerManager.isAddressedModePossible()) {
            this.store(programmerManager, AddressedProgrammerManager.class);
            InstanceManager.store(programmerManager, AddressedProgrammerManager.class);
        }
        if (programmerManager.isGlobalProgrammerAvailable()) {
            this.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        InstanceManager.setReporterManager(this.getReporterManager());
        InstanceManager.setDefault(CabSignalManager.class, this.getCabSignalManager());
        this.setConsistManager(new LocoNetConsistManager(this));
        this.setLncvDevicesManager(new LncvDevicesManager(this));
        LnClockControl cc = this.getClockControl();
        InstanceManager.setDefault(ClockControl.class, cc);
        LocoNetSystemConnectionMemo.getIdTagManager();
        this.register();
        this.getPredefinedMeters();
        this.getThrottleStringIO();
    }

    public LnPowerManager getPowerManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnPowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> new LnPowerManager(this));
    }

    public ThrottleManager getThrottleManager() {
        if (this.getSlotManager() != null) {
            log.debug("GetThrottleManager for {}", (Object)this.getSlotManager().getCommandStationType());
        }
        if (this.getDisabled()) {
            return null;
        }
        ThrottleManager throttleManager = (ThrottleManager)this.get(ThrottleManager.class);
        if (throttleManager == null && this.getSlotManager() != null) {
            LnCommandStationType cmdstation = this.getSlotManager().getCommandStationType();
            log.debug("getThrottleManager constructs for {}", (Object)cmdstation.getName());
            throttleManager = cmdstation.getThrottleManager(this);
            log.debug("result was type {}", throttleManager.getClass());
            this.store(throttleManager, ThrottleManager.class);
        }
        return throttleManager;
    }

    public void setThrottleManager(ThrottleManager t) {
        this.store(t, ThrottleManager.class);
    }

    public LnTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnTurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> new LnTurnoutManager(this, this.tm, this.mTurnoutNoRetry));
    }

    public LnClockControl getClockControl() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnClockControl)this.classObjectMap.computeIfAbsent(ClockControl.class, c -> new LnClockControl(this));
    }

    public LnReporterManager getReporterManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnReporterManager)this.classObjectMap.computeIfAbsent(ReporterManager.class, c -> new LnReporterManager(this));
    }

    public LnSensorManager getSensorManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnSensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> new LnSensorManager(this));
    }

    public LnLightManager getLightManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnLightManager)this.classObjectMap.computeIfAbsent(LightManager.class, c -> new LnLightManager(this));
    }

    public LncvDevicesManager getLncvDevicesManager() {
        if (this.getDisabled()) {
            return null;
        }
        if (this.lncvdm == null) {
            this.setLncvDevicesManager(new LncvDevicesManager(this));
            log.debug("Auto create of LncvDevicesManager for initial configuration");
        }
        return this.lncvdm;
    }

    public LnStringIOManager getStringIOManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnStringIOManager)this.classObjectMap.computeIfAbsent(StringIOManager.class, c -> new LnStringIOManager(this));
    }

    public LnPredefinedMeters getPredefinedMeters() {
        if (this.getDisabled()) {
            log.warn("Aborting getPredefinedMeters account is disabled!");
            return null;
        }
        if (this.predefinedMeters == null) {
            this.predefinedMeters = new LnPredefinedMeters(this);
        }
        return this.predefinedMeters;
    }

    public void getThrottleStringIO() {
        if (this.getDisabled()) {
            log.warn("Aborting getThrottleStringIO account is disabled!");
            return;
        }
        if (this.throttleStringIO == null) {
            this.throttleStringIO = new LnThrottleStringIO(this);
            InstanceManager.getDefault(StringIOManager.class).register(this.throttleStringIO);
        }
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.loconet.LocoNetActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TranspondingTagManager getIdTagManager() {
        Class<LocoNetSystemConnectionMemo> clazz = LocoNetSystemConnectionMemo.class;
        synchronized (LocoNetSystemConnectionMemo.class) {
            if (tagManager == null) {
                tagManager = new TranspondingTagManager();
                InstanceManager.setIdTagManager(tagManager);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tagManager;
        }
    }

    public LnCabSignalManager getCabSignalManager() {
        return (LnCabSignalManager)this.classObjectMap.computeIfAbsent(CabSignalManager.class, c -> new LnCabSignalManager(this));
    }

    @Override
    public void dispose() {
        ThrottleManager throttleManager;
        if (this.throttleStringIO != null) {
            this.throttleStringIO = null;
        }
        if (this.predefinedMeters != null) {
            this.predefinedMeters.dispose();
        }
        InstanceManager.deregister(this, LocoNetSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
            this.cf = null;
        }
        if ((throttleManager = (ThrottleManager)this.get(ThrottleManager.class)) != null) {
            if (throttleManager instanceof LnThrottleManager) {
                InstanceManager.deregister((LnThrottleManager)throttleManager, LnThrottleManager.class);
            } else if (throttleManager instanceof DebugThrottleManager) {
                InstanceManager.deregister((DebugThrottleManager)throttleManager, DebugThrottleManager.class);
            }
            this.deregister(throttleManager, ThrottleManager.class);
        }
        if (this.tm != null) {
            this.tm.dispose();
            this.tm = null;
        }
        if (this.sm != null) {
            this.sm.dispose();
            this.sm = null;
        }
        if (this.lt != null) {
            this.lt.dispose();
            this.lt = null;
        }
        super.dispose();
    }
}

