/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import jmri.jmrix.loconet.LocoNetException;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.SlotListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetSlot {
    boolean localF9 = false;
    boolean localF10 = false;
    boolean localF11 = false;
    boolean localF12 = false;
    boolean localF13 = false;
    boolean localF14 = false;
    boolean localF15 = false;
    boolean localF16 = false;
    boolean localF17 = false;
    boolean localF18 = false;
    boolean localF19 = false;
    boolean localF20 = false;
    boolean localF21 = false;
    boolean localF22 = false;
    boolean localF23 = false;
    boolean localF24 = false;
    boolean localF25 = false;
    boolean localF26 = false;
    boolean localF27 = false;
    boolean localF28 = false;
    private final int slot;
    private int stat;
    private int addr;
    private int spd;
    private int dirf;
    private int trk = 7;
    private int ss2;
    private int snd;
    private int id;
    private int _pcmd;
    private long lastUpdateTime;
    private final List<SlotListener> slotListeners = new ArrayList<SlotListener>();
    private static final Logger log = LoggerFactory.getLogger(LocoNetSlot.class);

    public LocoNetSlot(int slotNum) {
        this.slot = slotNum;
    }

    public LocoNetSlot(LocoNetMessage l) throws LocoNetException {
        this.slot = l.getElement(2);
        this.setSlot(l);
    }

    public int getSlot() {
        return this.slot;
    }

    public int decoderType() {
        return this.stat & 7;
    }

    public int slotStatus() {
        return this.stat & 0x30;
    }

    public int ss2() {
        return this.ss2;
    }

    public int consistStatus() {
        return this.stat & 0x48;
    }

    public boolean isForward() {
        return (this.dirf & 0x20) == 0;
    }

    private boolean[] getFuncArray() {
        return new boolean[]{this.isF0(), this.isF1(), this.isF2(), this.isF3(), this.isF4(), this.isF5(), this.isF6(), this.isF7(), this.isF8(), this.isF9(), this.isF10(), this.isF11(), this.isF12(), this.isF13(), this.isF14(), this.isF15(), this.isF16(), this.isF17(), this.isF18(), this.isF19(), this.isF20(), this.isF21(), this.isF22(), this.isF23(), this.isF24(), this.isF25(), this.isF26(), this.isF27(), this.isF28()};
    }

    public boolean isFunction(int Fn) {
        return this.getFuncArray()[Fn];
    }

    public boolean isF0() {
        return (this.dirf & 0x10) != 0;
    }

    public boolean isF1() {
        return (this.dirf & 1) != 0;
    }

    public boolean isF2() {
        return (this.dirf & 2) != 0;
    }

    public boolean isF3() {
        return (this.dirf & 4) != 0;
    }

    public boolean isF4() {
        return (this.dirf & 8) != 0;
    }

    public boolean isF5() {
        return (this.snd & 1) != 0;
    }

    public boolean isF6() {
        return (this.snd & 2) != 0;
    }

    public boolean isF7() {
        return (this.snd & 4) != 0;
    }

    public boolean isF8() {
        return (this.snd & 8) != 0;
    }

    public boolean isF9() {
        return this.localF9;
    }

    public boolean isF10() {
        return this.localF10;
    }

    public boolean isF11() {
        return this.localF11;
    }

    public boolean isF12() {
        return this.localF12;
    }

    public boolean isF13() {
        return this.localF13;
    }

    public boolean isF14() {
        return this.localF14;
    }

    public boolean isF15() {
        return this.localF15;
    }

    public boolean isF16() {
        return this.localF16;
    }

    public boolean isF17() {
        return this.localF17;
    }

    public boolean isF18() {
        return this.localF18;
    }

    public boolean isF19() {
        return this.localF19;
    }

    public boolean isF20() {
        return this.localF20;
    }

    public boolean isF21() {
        return this.localF21;
    }

    public boolean isF22() {
        return this.localF22;
    }

    public boolean isF23() {
        return this.localF23;
    }

    public boolean isF24() {
        return this.localF24;
    }

    public boolean isF25() {
        return this.localF25;
    }

    public boolean isF26() {
        return this.localF26;
    }

    public boolean isF27() {
        return this.localF27;
    }

    public boolean isF28() {
        return this.localF28;
    }

    public int locoAddr() {
        return this.addr;
    }

    public int speed() {
        return this.spd;
    }

    public int dirf() {
        return this.dirf;
    }

    public int snd() {
        return this.snd;
    }

    public int id() {
        return this.id;
    }

    public int pcmd() {
        return this._pcmd;
    }

    public int cvval() {
        return this.snd + (this.ss2 & 2) * 64;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public void setSlot(LocoNetMessage l) throws LocoNetException {
        switch (l.getOpCode()) {
            case 231: {
                this.lastUpdateTime = System.currentTimeMillis();
            }
            case 239: {
                if (l.getElement(1) != 14) {
                    return;
                }
                if (this.slot != l.getElement(2)) {
                    log.error("Asked to handle message not for this slot ({}) {}", (Object)this.slot, (Object)l);
                }
                this.stat = l.getElement(3);
                this._pcmd = l.getElement(4);
                this.addr = l.getElement(4) + 128 * l.getElement(9);
                this.spd = l.getElement(5);
                this.dirf = l.getElement(6);
                this.trk = l.getElement(7);
                this.ss2 = l.getElement(8);
                this.snd = l.getElement(10);
                this.id = l.getElement(11) + 128 * l.getElement(12);
                this.notifySlotListeners();
                return;
            }
            case 181: {
                if (this.slot != l.getElement(1)) {
                    log.error("Asked to handle message not for this slot {}", (Object)l);
                }
                this.stat = l.getElement(2);
                this.notifySlotListeners();
                this.lastUpdateTime = System.currentTimeMillis();
                return;
            }
            case 162: {
                this.snd &= 0xFFFFFFF0;
                this.snd |= 0xF & l.getElement(2);
                this.notifySlotListeners();
                this.lastUpdateTime = System.currentTimeMillis();
                return;
            }
            case 161: {
                if ((this.stat & 0x48) == 72 || (this.stat & 0x48) == 64) {
                    this.dirf &= 0xFFFFFFE0;
                    this.dirf += 0x1F & l.getElement(2);
                } else {
                    this.dirf &= 0xFFFFFFC0;
                    this.dirf += 0x3F & l.getElement(2);
                }
                this.notifySlotListeners();
                this.lastUpdateTime = System.currentTimeMillis();
                return;
            }
            case 184: 
            case 185: 
            case 186: {
                this.lastUpdateTime = System.currentTimeMillis();
                this.notifySlotListeners();
                return;
            }
            case 160: {
                if ((this.stat & 0x48) != 72 && (this.stat & 0x48) != 64) {
                    this.spd = l.getElement(2);
                    this.notifySlotListeners();
                    this.lastUpdateTime = System.currentTimeMillis();
                } else {
                    log.info("Ignoring speed change for slot {} marked as consist-mid or consist-sub.", (Object)this.slot);
                }
                return;
            }
            case 182: {
                if ((this.stat & 0x48) == 72 || (this.stat & 0x48) == 64) {
                    this.dirf &= 0xFFFFFFE0;
                    this.dirf += 0x1F & l.getElement(2);
                    this.notifySlotListeners();
                    this.lastUpdateTime = System.currentTimeMillis();
                }
                return;
            }
        }
        throw new LocoNetException("message can't be parsed");
    }

    public void functionMessage(long pkt) {
        if ((pkt & 0xFFFFFF0L) == 160L) {
            this.localF9 = (pkt & 1L) != 0L;
            this.localF10 = (pkt & 2L) != 0L;
            this.localF11 = (pkt & 4L) != 0L;
            this.localF12 = (pkt & 8L) != 0L;
            this.notifySlotListeners();
        } else if ((pkt & 0xFFFFFFFFFFFFFF00L) == 56832L) {
            this.localF13 = (pkt & 1L) != 0L;
            this.localF14 = (pkt & 2L) != 0L;
            this.localF15 = (pkt & 4L) != 0L;
            this.localF16 = (pkt & 8L) != 0L;
            this.localF17 = (pkt & 0x10L) != 0L;
            this.localF18 = (pkt & 0x20L) != 0L;
            this.localF19 = (pkt & 0x40L) != 0L;
            this.localF20 = (pkt & 0x80L) != 0L;
            this.notifySlotListeners();
        } else if ((pkt & 0xFFFFFFFFFFFFFF00L) == 57088L) {
            this.localF21 = (pkt & 1L) != 0L;
            this.localF22 = (pkt & 2L) != 0L;
            this.localF23 = (pkt & 4L) != 0L;
            this.localF24 = (pkt & 8L) != 0L;
            this.localF25 = (pkt & 0x10L) != 0L;
            this.localF26 = (pkt & 0x20L) != 0L;
            this.localF27 = (pkt & 0x40L) != 0L;
            this.localF28 = (pkt & 0x80L) != 0L;
            this.notifySlotListeners();
        }
    }

    public LocoNetMessage writeMode(int status) {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setOpCode(181);
        l.setElement(1, this.slot);
        l.setElement(2, this.stat & 0xFFFFFFF8 | status);
        return l;
    }

    public LocoNetMessage writeThrottleID(int newID) {
        this.id = newID & 0x17F;
        return this.writeSlot();
    }

    public LocoNetMessage writeStatus(int status) {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setOpCode(181);
        l.setElement(1, this.slot);
        l.setElement(2, this.stat & 0xFFFFFFCF | status);
        return l;
    }

    public LocoNetMessage dispatchSlot() {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setOpCode(186);
        l.setElement(1, this.slot);
        l.setElement(2, 0);
        return l;
    }

    public LocoNetMessage releaseSlot() {
        return this.writeStatus(16);
    }

    public LocoNetMessage writeSlot() {
        LocoNetMessage l = new LocoNetMessage(14);
        l.setOpCode(239);
        l.setElement(1, 14);
        l.setElement(2, this.slot & 0x7F);
        l.setElement(3, this.stat & 0x7F);
        l.setElement(4, this.addr & 0x7F);
        l.setElement(9, this.addr / 128 & 0x7F);
        l.setElement(5, this.spd & 0x7F);
        l.setElement(6, this.dirf & 0x7F);
        l.setElement(7, this.trk & 0x7F);
        l.setElement(8, this.ss2 & 0x7F);
        l.setElement(10, this.snd & 0x7F);
        l.setElement(11, this.id & 0x7F);
        l.setElement(12, this.id / 128 & 0x7F);
        return l;
    }

    public synchronized void addSlotListener(SlotListener l) {
        if (!this.slotListeners.contains(l)) {
            this.slotListeners.add(l);
        }
    }

    public synchronized void removeSlotListener(SlotListener l) {
        if (this.slotListeners.contains(l)) {
            this.slotListeners.remove(l);
        }
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySlotListeners() {
        ArrayList<SlotListener> v;
        LocoNetSlot locoNetSlot = this;
        synchronized (locoNetSlot) {
            v = new ArrayList<SlotListener>(this.slotListeners);
        }
        log.debug("notify {} SlotListeners", (Object)v.size());
        int cnt = v.size();
        int i = 0;
        while (i < cnt) {
            SlotListener client = (SlotListener)v.get(i);
            client.notifyChangedSlot(this);
            ++i;
        }
    }

    public int getTrackStatus() {
        return this.trk;
    }

    public void setTrackStatus(int status) {
        this.trk = status;
    }

    public int getFcDays() {
        if (this.getSlot() != 123) {
            log.error("getFcDays invalid for slot {}", (Object)this.getSlot());
        }
        return (this.addr & 0x3F80) / 128;
    }

    public void setFcDays(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcDays invalid for slot {}", (Object)this.getSlot());
        }
        this.addr = val * 128 + (this.addr & 0x7F);
    }

    public int getFcHours() {
        if (this.getSlot() != 123) {
            log.error("getFcHours invalid for slot {}", (Object)this.getSlot());
        }
        int temp = (256 - this.ss2 & 0x7F) % 24;
        return (24 - temp) % 24;
    }

    public void setFcHours(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcHours invalid for slot {}", (Object)this.getSlot());
        }
        this.ss2 = 256 - (24 - val) & 0x7F;
    }

    public int getFcMinutes() {
        if (this.getSlot() != 123) {
            log.error("getFcMinutes invalid for slot {}", (Object)this.getSlot());
        }
        int temp = (255 - this.dirf & 0x7F) % 60;
        return (60 - temp) % 60;
    }

    public void setFcMinutes(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcMinutes invalid for slot {}", (Object)this.getSlot());
        }
        this.dirf = 255 - (60 - val) & 0x7F;
    }

    public int getFcFracMins() {
        if (this.getSlot() != 123) {
            log.error("getFcFracMins invalid for slot {}", (Object)this.getSlot());
        }
        return 16383 - (this.addr & 0x7F | (this.spd & 0x7F) << 7);
    }

    public void setFcFracMins(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcFracMins invalid for slot {}", (Object)this.getSlot());
        }
        int temp = 16383 - val;
        this.addr |= temp & 0x7F;
        this.spd = temp >> 7 & 0x7F;
    }

    public int getFcRate() {
        if (this.getSlot() != 123) {
            log.error("getFcRate invalid for slot {}", (Object)this.getSlot());
        }
        return this.stat;
    }

    public void setFcRate(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcRate invalid for slot {}", (Object)this.getSlot());
        }
        this.stat = val & 0x7F;
    }
}

