/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.loconet.messageinterp.LocoNetMessageInterpret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetMessage
extends AbstractMessage
implements Serializable {
    static final long serialVersionUID = -7904918731667071828L;
    static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger log = LoggerFactory.getLogger(LocoNetMessage.class);

    public LocoNetMessage() {
        this._nDataChars = 0;
        this._dataChars = new int[1];
        log.error("LocoNetMessage does not allow a constructor with no argument");
    }

    public LocoNetMessage(int len) {
        if (len < 2) {
            this._nDataChars = 0;
            this._dataChars = new int[1];
            log.error("LocoNetMessage does not allow object creation if length is less than 2.");
            return;
        }
        this._nDataChars = len;
        this._dataChars = new int[len];
    }

    public LocoNetMessage(String s) {
        this._nDataChars = 0;
        this._dataChars = new int[1];
        log.error("LocoNetMessage does not allow a constructor with a 'String' argument");
    }

    public LocoNetMessage(int[] contents) {
        if (contents.length < 2) {
            this._nDataChars = 0;
            this._dataChars = new int[1];
            log.error("Cannot create a LocoNet message of length shorter than two.");
        }
        this._nDataChars = contents.length;
        this._dataChars = new int[contents.length];
        int i = 0;
        while (i < contents.length) {
            this.setElement(i, contents[i]);
            ++i;
        }
    }

    public LocoNetMessage(byte[] contents) {
        if (contents.length < 2) {
            this._nDataChars = 0;
            this._dataChars = new int[1];
            log.error("Cannot create a LocoNet message of length shorter than two.");
        }
        this._nDataChars = contents.length;
        this._dataChars = new int[contents.length];
        int i = 0;
        while (i < contents.length) {
            this._dataChars[i] = contents[i] & 0xFF;
            ++i;
        }
    }

    public LocoNetMessage(LocoNetMessage original) {
        Objects.requireNonNull(original, "Unable to create message by copying a null message");
        this._nDataChars = original.getNumDataElements();
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < original.getNumDataElements()) {
            this._dataChars[i] = original._dataChars[i];
            ++i;
        }
    }

    public void setOpCode(int i) {
        this._dataChars[0] = i;
    }

    public int getOpCode() {
        return this._dataChars[0];
    }

    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    @Override
    public int getElement(int n) {
        if (n < 0 || n >= this._dataChars.length) {
            log.error("reference element {} in message of {} elements: {}", new Object[]{n, this._dataChars.length, this.toString()});
            return -1;
        }
        return this._dataChars[n] & 0xFF;
    }

    @Override
    public void setElement(int n, int v) {
        if (n < 0 || n >= this._dataChars.length) {
            log.error("reference element {} in message of {} elements: {}", new Object[]{n, this._dataChars.length, this.toString()});
            return;
        }
        this._dataChars[n] = v & 0xFF;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._nDataChars) {
            if (i > 0) {
                sb.append(' ');
            }
            int val = this._dataChars[i] & 0xFF;
            sb.append(hexChars[val >> 4]);
            sb.append(hexChars[val & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public void setParity() {
        if (this.getOpCode() == 211 && this.getNumDataElements() > 6) {
            int sum = 255;
            int i = 0;
            while (i < 5) {
                sum ^= this.getElement(i);
                ++i;
            }
            this.setElement(5, sum);
            sum = 255;
            i = 6;
            while (i < this.getNumDataElements() - 1) {
                sum ^= this.getElement(i);
                ++i;
            }
            this.setElement(this.getNumDataElements() - 1, sum);
            return;
        }
        int len = this.getNumDataElements();
        int chksum = 255;
        int loop = 0;
        while (loop < len - 1) {
            chksum ^= this.getElement(loop);
            ++loop;
        }
        this.setElement(len - 1, chksum);
    }

    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 255;
        if (this.getOpCode() == 211 && len > 6) {
            int sum = 255;
            int loop = 0;
            while (loop < 5) {
                sum ^= this.getElement(loop);
                ++loop;
            }
            if (this.getElement(5) != sum) {
                return false;
            }
            sum = 255;
            loop = 6;
            while (loop < len - 1) {
                sum ^= this.getElement(loop);
                ++loop;
            }
            return this.getElement(len - 1) == sum;
        }
        int loop = 0;
        while (loop < len - 1) {
            chksum ^= this.getElement(loop);
            ++loop;
        }
        return chksum == this.getElement(len - 1);
    }

    public int[] getPeerXfrData() {
        if (this.getOpCode() != 229) {
            log.error("getPeerXfrData called with wrong opcode {}", (Object)this.getOpCode());
        }
        if (this.getElement(1) != 16) {
            log.error("getPeerXfrData called with wrong secondary code {}", (Object)this.getElement(1));
        }
        if (this.getNumDataElements() != 16) {
            log.error("getPeerXfrData called with wrong length {}", (Object)this.getNumDataElements());
            return new int[1];
        }
        int[] data = new int[8];
        int pxct1 = this.getElement(5);
        int pxct2 = this.getElement(10);
        data[0] = (this.getElement(6) & 0x7F) + ((pxct1 & 1) != 0 ? 128 : 0);
        data[1] = (this.getElement(7) & 0x7F) + ((pxct1 & 2) != 0 ? 128 : 0);
        data[2] = (this.getElement(8) & 0x7F) + ((pxct1 & 4) != 0 ? 128 : 0);
        data[3] = (this.getElement(9) & 0x7F) + ((pxct1 & 8) != 0 ? 128 : 0);
        data[4] = (this.getElement(11) & 0x7F) + ((pxct2 & 1) != 0 ? 128 : 0);
        data[5] = (this.getElement(12) & 0x7F) + ((pxct2 & 2) != 0 ? 128 : 0);
        data[6] = (this.getElement(13) & 0x7F) + ((pxct2 & 4) != 0 ? 128 : 0);
        data[7] = (this.getElement(14) & 0x7F) + ((pxct2 & 8) != 0 ? 128 : 0);
        return data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LocoNetMessage)) {
            return false;
        }
        LocoNetMessage m = (LocoNetMessage)o;
        if (m._nDataChars != this._nDataChars) {
            return false;
        }
        int i = 0;
        while (i < this._nDataChars - 1) {
            if ((m._dataChars[i] & 0xFF) != (this._dataChars[i] & 0xFF)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int r = this._nDataChars;
        if (this._nDataChars > 0) {
            r += this._dataChars[0];
        }
        if (this._nDataChars > 1) {
            r += this._dataChars[1] * 128;
        }
        if (this._nDataChars > 2) {
            r += this._dataChars[2] * 128 * 128;
        }
        return r;
    }

    @Override
    public String toMonitorString() {
        return this.toMonitorString("L");
    }

    public String toMonitorString(@Nonnull String prefix) {
        return LocoNetMessageInterpret.interpretMessage(this, String.valueOf(prefix) + "T", String.valueOf(prefix) + "S", String.valueOf(prefix) + "R");
    }

    public static LocoNetMessage makePeerXfr(int src, int dst, int[] d, int code) {
        LocoNetMessage msg = new LocoNetMessage(16);
        msg.setOpCode(229);
        msg.setElement(1, 16);
        int pxct1 = 0;
        int pxct2 = 0;
        pxct1 |= (code & 7) * 16;
        pxct2 |= (code & 0x38) / 8 * 16;
        msg.setElement(2, src & 0x7F);
        msg.setElement(3, dst & 0x7F);
        msg.setElement(4, LocoNetMessage.highByte(dst) & 0x7F);
        msg.setElement(6, d[0] & 0x7F);
        if (LocoNetMessage.highBit(d[0])) {
            pxct1 |= 1;
        }
        msg.setElement(7, d[1] & 0x7F);
        if (LocoNetMessage.highBit(d[1])) {
            pxct1 |= 2;
        }
        msg.setElement(8, d[2] & 0x7F);
        if (LocoNetMessage.highBit(d[2])) {
            pxct1 |= 4;
        }
        msg.setElement(9, d[3] & 0x7F);
        if (LocoNetMessage.highBit(d[3])) {
            pxct1 |= 8;
        }
        msg.setElement(11, d[4] & 0x7F);
        if (LocoNetMessage.highBit(d[4])) {
            pxct2 |= 1;
        }
        msg.setElement(12, d[5] & 0x7F);
        if (LocoNetMessage.highBit(d[5])) {
            pxct2 |= 2;
        }
        msg.setElement(13, d[6] & 0x7F);
        if (LocoNetMessage.highBit(d[6])) {
            pxct2 |= 4;
        }
        msg.setElement(14, d[7] & 0x7F);
        if (LocoNetMessage.highBit(d[7])) {
            pxct2 |= 8;
        }
        msg.setElement(5, pxct1);
        msg.setElement(10, pxct2);
        return msg;
    }

    protected static boolean highBit(int val) {
        if ((val & 0xFFFFFF00) != 0) {
            log.error("highBit called with too large value: 0x{}", (Object)Integer.toHexString(val));
        }
        return (val & 0x80) != 0;
    }

    protected static int lowByte(int val) {
        return val & 0xFF;
    }

    protected static int highByte(int val) {
        if ((val & 0xFFFF0000) != 0) {
            log.error("highByte called with too large value: {}", (Object)Integer.toHexString(val));
        }
        return (val & 0xFF00) / 256;
    }

    public int sensorAddr() {
        int sw1 = this.getElement(1);
        int sw2 = this.getElement(2);
        int as = sw2 & 0x20;
        int high = sw2 & 0xF;
        int low = sw1 & 0x7F;
        return high * 256 + low * 2 + (as != 0 ? 1 : 0);
    }

    public int inputRepAddr() {
        if (this.getOpCode() == 178) {
            return this.sensorAddr();
        }
        return -1;
    }

    public int turnoutAddr() {
        int a1 = this.getElement(1);
        int a2 = this.getElement(2);
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1;
    }
}

