/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.jmrix.loconet.LnConstants;
import jmri.jmrix.loconet.LnThrottleManager;
import jmri.jmrix.loconet.LocoNetConsist;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetConsistManager
extends AbstractConsistManager {
    private LocoNetSystemConnectionMemo memo = null;
    private boolean requestingUpdate = false;
    private static final Logger log = LoggerFactory.getLogger(LocoNetConsistManager.class);

    public LocoNetConsistManager(LocoNetSystemConnectionMemo lm) {
        this.memo = lm;
    }

    @Override
    public boolean isCommandStationConsistPossible() {
        return true;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return false;
    }

    @Override
    public Consist addConsist(LocoAddress address) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(address)) {
            return (Consist)this.consistTable.get(address);
        }
        LocoNetConsist consist = new LocoNetConsist((DccLocoAddress)address, this.memo);
        this.consistTable.put(address, consist);
        return consist;
    }

    @Override
    public void requestUpdateFromLayout() {
        DccLocoAddress address;
        LocoNetSlot s;
        if (!this.shouldRequestUpdateFromLayout()) {
            return;
        }
        this.requestingUpdate = true;
        SlotManager sm = this.memo.getSlotManager();
        int i = 0;
        while (i < 128) {
            s = sm.slot(i);
            address = new DccLocoAddress(s.locoAddr(), LnThrottleManager.isLongAddress(s.locoAddr()));
            if (log.isDebugEnabled()) {
                log.debug(" Slot {} Address {} consist status {}", new Object[]{i, address, LnConstants.CONSIST_STAT(s.consistStatus())});
            }
            if (!(s.consistStatus() != 8 && s.consistStatus() != 72 || this.consistTable.containsKey(address))) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding Consist with Address {} due to command station read", (Object)address);
                }
                this.addConsist(address);
                this.getConsist(address).add(address, true);
            }
            ++i;
        }
        i = 0;
        while (i < 128) {
            s = sm.slot(i);
            address = new DccLocoAddress(s.locoAddr(), LnThrottleManager.isLongAddress(s.locoAddr()));
            if (log.isDebugEnabled()) {
                log.debug(" Slot {} Address {} consist status {}", new Object[]{i, address, LnConstants.CONSIST_STAT(s.consistStatus())});
            }
            if (s.consistStatus() == 64 || s.consistStatus() == 72) {
                DccLocoAddress lead = new DccLocoAddress(sm.slot(s.speed()).locoAddr(), LnThrottleManager.isLongAddress(sm.slot(s.speed()).locoAddr()));
                this.getConsist(lead).add(address, s.isForward() == sm.slot(s.speed()).isForward());
            }
            ++i;
        }
        this.requestingUpdate = false;
    }

    @Override
    protected boolean shouldRequestUpdateFromLayout() {
        return !this.requestingUpdate;
    }
}

