/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.ArrayList;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.implementation.DccConsist;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.loconet.LnConstants;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.LocoNetThrottle;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.SlotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetConsist
extends DccConsist
implements SlotListener,
ThrottleListener {
    private SlotManager slotManager = null;
    private LnTrafficController trafficController = null;
    private AbstractThrottleManager throttleManager = null;
    private LocoNetSlot leadSlot = null;
    private ArrayList<DccLocoAddress> needToWrite = null;
    static final int IDLESTATE = 0;
    static final int LEADREQUESTSTATE = 1;
    static final int LINKSTAGEONESTATE = 2;
    static final int LINKSTAGETWOSTATE = 4;
    static final int LINKSTAGETHREESTATE = 8;
    static final int UNLINKSTAGEONESTATE = 16;
    private int consistRequestState = 0;
    private static final Logger log = LoggerFactory.getLogger(LocoNetConsist.class);

    public LocoNetConsist(int address, LocoNetSystemConnectionMemo lm) {
        super(address);
        this.slotManager = lm.getSlotManager();
        this.trafficController = lm.getLnTrafficController();
        this.throttleManager = (AbstractThrottleManager)lm.getThrottleManager();
        this.consistRequestState = 1;
        this.consistType = 1;
        this.needToWrite = new ArrayList();
        this.throttleManager.requestThrottle(this.consistAddress, (ThrottleListener)this, false);
    }

    public LocoNetConsist(DccLocoAddress address, LocoNetSystemConnectionMemo lm) {
        super(address);
        this.slotManager = lm.getSlotManager();
        this.trafficController = lm.getLnTrafficController();
        this.throttleManager = (AbstractThrottleManager)lm.getThrottleManager();
        this.consistRequestState = 1;
        this.consistType = 1;
        this.needToWrite = new ArrayList();
        this.throttleManager.requestThrottle(this.consistAddress, (ThrottleListener)this, false);
    }

    @Override
    public void setConsistType(int consist_type) {
        if (consist_type == 0) {
            this.consistType = consist_type;
            return;
        }
        if (consist_type == 1) {
            this.consistType = consist_type;
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
        }
    }

    @Override
    public boolean isAddressAllowed(DccLocoAddress address) {
        if (this.consistType == 1) {
            return true;
        }
        return address.getNumber() != 0;
    }

    @Override
    public int sizeLimit() {
        if (this.consistType == 0) {
            return -1;
        }
        if (this.consistType == 1) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean contains(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return this.consistList.contains(address);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    @Override
    public boolean getLocoDirection(DccLocoAddress address) {
        log.debug("consist {} obtaining direction for {} Consist List Size {}", new Object[]{this.consistAddress, address, this.consistList.size()});
        if (this.consistType == 0 || this.consistType == 1) {
            if (address == this.consistAddress) {
                return true;
            }
            if (this.consistList.contains(address)) {
                Boolean Direction2 = (Boolean)this.consistDir.get(address);
                return Direction2;
            }
            return true;
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    private synchronized void addToConsistList(DccLocoAddress LocoAddress2, boolean directionNormal) {
        Boolean Direction2 = directionNormal;
        if (!this.consistList.contains(LocoAddress2)) {
            this.consistList.add(LocoAddress2);
        }
        if (this.consistDir.containsKey(LocoAddress2)) {
            this.consistDir.remove(LocoAddress2);
        }
        this.consistDir.put(LocoAddress2, Direction2);
    }

    private synchronized void removeFromConsistList(DccLocoAddress LocoAddress2) {
        this.consistDir.remove(LocoAddress2);
        this.consistList.remove(LocoAddress2);
    }

    @Override
    public synchronized void add(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (LocoAddress2 == this.consistAddress) {
            this.addToConsistList(LocoAddress2, directionNormal);
            this.notifyConsistListeners(LocoAddress2, 2);
        } else if (this.consistType == 0) {
            if (this.consistList.contains(LocoAddress2)) {
                this.removeFromAdvancedConsist(LocoAddress2);
            }
            this.addToConsistList(LocoAddress2, directionNormal);
            if (this.leadSlot == null || this.consistRequestState != 0) {
                this.needToWrite.add(LocoAddress2);
            } else {
                this.addToAdvancedConsist(LocoAddress2, directionNormal);
            }
        } else if (this.consistType == 1) {
            if (this.consistList.contains(LocoAddress2)) {
                this.removeFromCSConsist(LocoAddress2);
            }
            this.addToConsistList(LocoAddress2, directionNormal);
            if (this.leadSlot == null || this.consistRequestState != 0) {
                this.needToWrite.add(LocoAddress2);
            } else {
                this.addToCSConsist(LocoAddress2, directionNormal);
            }
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(LocoAddress2, 1);
        }
    }

    private synchronized void delayedAdd() {
        DccLocoAddress LocoAddress2 = this.needToWrite.get(0);
        if (this.consistType == 0) {
            this.addToAdvancedConsist(LocoAddress2, this.getLocoDirection(LocoAddress2));
        } else if (this.consistType == 1) {
            this.addToCSConsist(LocoAddress2, this.getLocoDirection(LocoAddress2));
        }
        this.needToWrite.remove(LocoAddress2);
    }

    @Override
    public synchronized void restore(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (this.consistType == 0) {
            this.addToConsistList(LocoAddress2, directionNormal);
        } else if (this.consistType == 1) {
            this.addToConsistList(LocoAddress2, directionNormal);
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(LocoAddress2, 1);
        }
    }

    @Override
    public synchronized void remove(DccLocoAddress LocoAddress2) {
        if (this.consistType == 0) {
            this.removeFromAdvancedConsist(LocoAddress2);
            this.removeFromConsistList(LocoAddress2);
        } else if (this.consistType == 1) {
            this.removeFromCSConsist(LocoAddress2);
            this.removeFromConsistList(LocoAddress2);
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(LocoAddress2, 1);
        }
    }

    @Override
    protected synchronized void addToAdvancedConsist(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (log.isDebugEnabled()) {
            log.debug("Add Locomotive {} to advanced consist {} With Direction Normal {}.", new Object[]{LocoAddress2.toString(), this.consistAddress.toString(), directionNormal});
        }
        this.setRosterEntryCVValue(LocoAddress2);
        this.consistRequestState = 2;
        this.throttleManager.requestThrottle(LocoAddress2, (ThrottleListener)this, false);
    }

    @Override
    protected synchronized void removeFromAdvancedConsist(DccLocoAddress LocoAddress2) {
        if (log.isDebugEnabled()) {
            log.debug(" Remove Locomotive {} from advanced consist {}", (Object)LocoAddress2.toString(), (Object)this.consistAddress.toString());
        }
        this.resetRosterEntryCVValue(LocoAddress2);
        this.slotManager.slotFromLocoAddress(LocoAddress2.getNumber(), this);
        this.consistRequestState = 16;
    }

    private synchronized void addToCSConsist(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (log.isDebugEnabled()) {
            log.debug("Add Locomotive {} to Standard Consist {} With Direction Normal {}.", new Object[]{LocoAddress2.toString(), this.consistAddress.toString(), directionNormal});
        }
        if (this.consistList.size() <= 1 && LocoAddress2.equals(this.consistAddress)) {
            this.notifyConsistListeners(LocoAddress2, 2);
            return;
        }
        this.throttleManager.requestThrottle(LocoAddress2, (ThrottleListener)this, false);
        this.consistRequestState = 4;
    }

    public synchronized void removeFromCSConsist(DccLocoAddress LocoAddress2) {
        if (log.isDebugEnabled()) {
            log.debug("Remove Locomotive {} from Standard Consist {}.", (Object)LocoAddress2.toString(), (Object)this.consistAddress.toString());
        }
        if (this.consistList.size() == 1 && LocoAddress2.equals(this.consistAddress)) {
            this.notifyConsistListeners(LocoAddress2, 2);
            return;
        }
        this.slotManager.slotFromLocoAddress(LocoAddress2.getNumber(), this);
        this.consistRequestState = 16;
    }

    private void linkSlots(LocoNetSlot lead, LocoNetSlot follow) {
        if (lead != follow) {
            LocoNetMessage msg = new LocoNetMessage(4);
            msg.setOpCode(185);
            msg.setElement(1, follow.getSlot());
            msg.setElement(2, lead.getSlot());
            this.trafficController.sendLocoNetMessage(msg);
        } else {
            follow.removeSlotListener(this);
            this.notifyConsistListeners(new DccLocoAddress(follow.locoAddr(), this.throttleManager.canBeLongAddress(follow.locoAddr())), 4);
        }
        this.consistRequestState = 0;
        if (this.needToWrite.size() != 0) {
            this.delayedAdd();
        }
    }

    private void unlinkSlots(LocoNetSlot lead, LocoNetSlot follow) {
        if (lead != follow) {
            LocoNetMessage msg = new LocoNetMessage(4);
            msg.setOpCode(184);
            msg.setElement(1, follow.getSlot());
            msg.setElement(2, lead.getSlot());
            this.trafficController.sendLocoNetMessage(msg);
        } else {
            follow.removeSlotListener(this);
            this.notifyConsistListeners(new DccLocoAddress(follow.locoAddr(), this.throttleManager.canBeLongAddress(follow.locoAddr())), 516);
        }
        this.consistRequestState = 0;
        if (this.needToWrite.size() != 0) {
            this.delayedAdd();
        }
    }

    private void setDirection(LocoNetThrottle t) {
        log.debug("consist {} set direction for {}", (Object)this.consistAddress, (Object)t.getLocoAddress());
        Boolean directionNormal = this.getLocoDirection((DccLocoAddress)t.getLocoAddress());
        if (directionNormal.booleanValue()) {
            t.setIsForward(this.leadSlot.isForward());
        } else {
            t.setIsForward(!this.leadSlot.isForward());
        }
        this.consistRequestState = 4;
    }

    private void setSlotModeAdvanced(LocoNetSlot s) {
        int oldstatus = s.slotStatus();
        int newstatus = oldstatus | 4;
        this.trafficController.sendLocoNetMessage(s.writeStatus(newstatus));
    }

    @Override
    public void notifyChangedSlot(LocoNetSlot s) {
        log.debug("Notified slot {} changed with mode {} slot consist state: {}", new Object[]{s.getSlot(), this.consistRequestState, LnConstants.CONSIST_STAT(s.consistStatus())});
        switch (this.consistRequestState) {
            case 1: {
                this.leadSlot = s;
                this.consistRequestState = 0;
                break;
            }
            case 2: {
                s.addSlotListener(this);
                this.setSlotModeAdvanced(s);
                this.consistRequestState = 4;
                break;
            }
            case 4: {
                this.linkSlots(this.leadSlot, s);
                break;
            }
            case 16: {
                this.unlinkSlots(this.leadSlot, s);
                break;
            }
            default: {
                s.removeSlotListener(this);
                this.notifyConsistListeners(new DccLocoAddress(s.locoAddr(), this.throttleManager.canBeLongAddress(s.locoAddr())), 2);
                if (this.needToWrite.size() != 0) {
                    this.delayedAdd();
                    break;
                }
                this.consistRequestState = 0;
            }
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        block11: {
            log.debug("notified Throttle {} found with mode {}", (Object)t.getLocoAddress(), (Object)this.consistRequestState);
            try {
                if (this.consistRequestState == 1) {
                    ((LocoNetThrottle)t).setIsForward(true);
                    this.leadSlot = ((LocoNetThrottle)t).getLocoNetSlot();
                    this.consistRequestState = 0;
                    if (this.needToWrite.size() != 0) {
                        this.delayedAdd();
                    }
                } else {
                    LocoNetSlot tempSlot = ((LocoNetThrottle)t).getLocoNetSlot();
                    if (tempSlot != null) {
                        tempSlot.addSlotListener(this);
                        if (this.consistRequestState == 2) {
                            this.notifyChangedSlot(tempSlot);
                            this.setDirection((LocoNetThrottle)t);
                            this.consistRequestState = 4;
                        } else {
                            this.setDirection((LocoNetThrottle)t);
                        }
                    } else {
                        log.error("Cannot notify a throttle's slot if the slot is null!");
                    }
                }
            }
            catch (ClassCastException classCastException) {
                if (this.consistRequestState == 1) {
                    t.setIsForward(true);
                    this.consistRequestState = 0;
                    if (this.needToWrite.size() != 0) {
                        this.delayedAdd();
                    }
                }
                if (!(t instanceof LocoNetThrottle)) break block11;
                LocoNetThrottle lt = (LocoNetThrottle)t;
                this.setDirection(lt);
            }
        }
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        this.notifyConsistListeners((DccLocoAddress)address, 4);
        this.removeFromConsistList((DccLocoAddress)address);
        this.consistRequestState = 0;
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }
}

