/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.JOptionPane;
import jmri.AddressedProgrammer;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ProgrammingTool;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnProgrammerManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.uhlenbrock.LncvDevice;
import jmri.jmrix.loconet.uhlenbrock.LncvDevices;
import jmri.jmrix.loconet.uhlenbrock.LncvMessageContents;
import jmri.managers.DefaultProgrammerManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LncvDevicesManager
extends PropertyChangeSupport
implements LocoNetListener {
    private final LocoNetSystemConnectionMemo memo;
    @GuardedBy(value="this")
    private final LncvDevices lncvDevices;
    private static final Logger log = LoggerFactory.getLogger(LncvDevicesManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LncvDevicesManager(LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        if (memo.getLnTrafficController() != null) {
            memo.getLnTrafficController().addLocoNetListener(-1, this);
        } else {
            log.error("No LocoNet connection available, this tool cannot function");
        }
        LncvDevicesManager lncvDevicesManager = this;
        synchronized (lncvDevicesManager) {
            this.lncvDevices = new LncvDevices();
        }
    }

    public synchronized LncvDevices getDeviceList() {
        return this.lncvDevices;
    }

    public synchronized int getDeviceCount() {
        return this.lncvDevices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDevicesList() {
        LncvDevicesManager lncvDevicesManager = this;
        synchronized (lncvDevicesManager) {
            this.lncvDevices.removeAllDevices();
        }
        ThreadingUtil.runOnLayoutEventually(() -> this.firePropertyChange("DeviceListChanged", true, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(LocoNetMessage m) {
        if (LncvMessageContents.isSupportedLncvMessage(m) && LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ_REPLY) {
            LncvMessageContents contents = new LncvMessageContents(m);
            int art = contents.getLncvArticleNum();
            int addr = -1;
            int cv = contents.getCvNum();
            int val = contents.getCvValue();
            log.debug("LNCV read reply: art:{}, address:{} cv:{} val:{}", new Object[]{art, addr, cv, val});
            if (cv == 0) {
                addr = val;
                log.debug("LNCV read reply: device address {} of LNCV returns {}", (Object)addr, (Object)val);
                LncvDevicesManager lncvDevicesManager = this;
                synchronized (lncvDevicesManager) {
                    if (this.lncvDevices.addDevice(new LncvDevice(art, addr, cv, val, "", "", -1))) {
                        log.debug("new LncvDevice added to table");
                        int i = 0;
                        while (i < this.lncvDevices.size()) {
                            LncvDevice dev = this.lncvDevices.getDevice(i);
                            if (dev.getProductID() == art && dev.getDestAddr() == addr) {
                                if (dev.getRosterName() != null && dev.getRosterName().length() == 0) {
                                    log.debug("Looking for prodID {}/adr {} in Roster", (Object)dev.getProductID(), (Object)dev.getDestAddr());
                                    List<RosterEntry> l = Roster.getDefault().matchingList(Integer.toString(dev.getDestAddr()), Integer.toString(dev.getProductID()));
                                    log.debug("LncvDeviceManager found {} matches in Roster", (Object)l.size());
                                    if (l.size() == 0) {
                                        log.debug("No corresponding roster entry found");
                                    } else if (l.size() == 1) {
                                        log.debug("Matching roster entry found");
                                        dev.setRosterEntry(l.get(0));
                                    } else {
                                        JOptionPane.showMessageDialog(null, Bundle.getMessage("WarnMultipleLncvModsFound", art, addr, l.size()), Bundle.getMessage("WarningTitle"), 2);
                                        log.info("Found multiple matching roster entries. Cannot associate any one to this device.");
                                    }
                                }
                                this.firePropertyChange("DeviceListChanged", true, false);
                            }
                            ++i;
                        }
                    } else {
                        log.debug("LNCV device was already in list");
                    }
                }
            } else {
                log.debug("LNCV device check skipped as value not CV0/module address");
            }
        }
    }

    public synchronized LncvDevice getDevice(int art, int addr) {
        int i = 0;
        while (i < this.lncvDevices.size()) {
            LncvDevice dev = this.lncvDevices.getDevice(i);
            if (dev.getProductID() == art && dev.getDestAddr() == addr) {
                return dev;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgrammingResult prepareForSymbolicProgrammer(LncvDevice dev, ProgrammingTool t) {
        LncvDevicesManager lncvDevicesManager = this;
        synchronized (lncvDevicesManager) {
            if (this.lncvDevices.isDeviceExistant(dev) < 0) {
                return ProgrammingResult.FAIL_NO_SUCH_DEVICE;
            }
            int destAddr = dev.getDestAddr();
            if (destAddr == 0) {
                return ProgrammingResult.FAIL_DESTINATION_ADDRESS_IS_ZERO;
            }
            int deviceCount = 0;
            LncvDevice[] lncvDeviceArray = this.lncvDevices.getDevices();
            int n = lncvDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                LncvDevice d = lncvDeviceArray[n2];
                if (destAddr == d.getDestAddr()) {
                    ++deviceCount;
                }
                ++n2;
            }
            log.debug("prepareForSymbolicProgrammer found {} matches", (Object)deviceCount);
            if (deviceCount > 1) {
                return ProgrammingResult.FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS;
            }
        }
        if (dev.getRosterName() == null || dev.getRosterName().length() == 0) {
            return ProgrammingResult.FAIL_NO_MATCHING_ROSTER_ENTRY;
        }
        DefaultProgrammerManager pm = this.memo.getProgrammerManager();
        if (pm == null) {
            return ProgrammingResult.FAIL_NO_APPROPRIATE_PROGRAMMER;
        }
        AddressedProgrammer p = pm.getAddressedProgrammer(false, dev.getDestAddr());
        if (p == null) {
            return ProgrammingResult.FAIL_NO_ADDRESSED_PROGRAMMER;
        }
        if (!p.getSupportedModes().contains(LnProgrammerManager.LOCONETLNCVMODE)) {
            return ProgrammingResult.FAIL_NO_LNCV_PROGRAMMER;
        }
        p.setMode(LnProgrammerManager.LOCONETLNCVMODE);
        ProgrammingMode prgMode = p.getMode();
        if (!prgMode.equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            return ProgrammingResult.FAIL_NO_LNCV_PROGRAMMER;
        }
        RosterEntry re = Roster.getDefault().entryFromTitle(dev.getRosterName());
        String name = re.getId();
        t.openPaneOpsProgFrame(re, name, "programmers/Comprehensive.xml", p);
        return ProgrammingResult.SUCCESS_PROGRAMMER_OPENED;
    }

    public static enum ProgrammingResult {
        SUCCESS_PROGRAMMER_OPENED,
        FAIL_NO_SUCH_DEVICE,
        FAIL_NO_APPROPRIATE_PROGRAMMER,
        FAIL_NO_MATCHING_ROSTER_ENTRY,
        FAIL_DESTINATION_ADDRESS_IS_ZERO,
        FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS,
        FAIL_NO_ADDRESSED_PROGRAMMER,
        FAIL_NO_LNCV_PROGRAMMER;

    }
}

