/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.BooleanPropertyDescriptor;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.Turnout;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnTurnout;
import jmri.jmrix.loconet.LocoNetInterface;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnTurnoutManager
extends AbstractTurnoutManager
implements LocoNetListener {
    LocoNetInterface fastcontroller;
    LocoNetInterface throttledcontroller;
    boolean mTurnoutNoRetry;
    protected boolean _binaryOutput = false;
    protected boolean _useOffSwReqAsConfirmation = false;
    LocoNetMessage lastSWREQ = null;
    public static final String BYPASSBUSHBYBITKEY = "Bypass Bushby Bit";
    public static final String SENDONANDOFFKEY = "Send ON/OFF";
    private static final Logger log = LoggerFactory.getLogger(LnTurnoutManager.class);

    public LnTurnoutManager(LocoNetSystemConnectionMemo memo, LocoNetInterface throttledController, boolean mTurnoutNoRetry) {
        super(memo);
        this.fastcontroller = memo.getLnTrafficController();
        this.throttledcontroller = throttledController;
        this.mTurnoutNoRetry = mTurnoutNoRetry;
        if (this.fastcontroller != null) {
            this.fastcontroller.addLocoNetListener(-1, this);
        } else {
            log.error("No layout connection, turnout manager can't function");
        }
    }

    @Override
    @Nonnull
    public LocoNetSystemConnectionMemo getMemo() {
        return (LocoNetSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        if (this.fastcontroller != null) {
            this.fastcontroller.removeLocoNetListener(-1, this);
        }
        super.dispose();
    }

    public void setUhlenbrockMonitoring() {
        this._binaryOutput = true;
        this.mTurnoutNoRetry = true;
        this._useOffSwReqAsConfirmation = true;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        String prefix = this.getSystemPrefix();
        try {
            addr = Integer.parseInt(systemName.substring(prefix.length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't convert " + systemName.substring(prefix.length() + 1) + " to LocoNet turnout address");
        }
        LnTurnout t = new LnTurnout(prefix, addr, this.throttledcontroller);
        t.setUserName(userName);
        if (this._binaryOutput) {
            t.setBinaryOutput(true);
        }
        if (this._useOffSwReqAsConfirmation) {
            t.setUseOffSwReqAsConfirmation(true);
            t.setFeedbackMode("MONITORING");
        }
        return t;
    }

    @Override
    public void message(LocoNetMessage l) {
        int addr;
        log.debug("LnTurnoutManager message {}", (Object)l);
        String prefix = this.getSystemPrefix();
        switch (l.getOpCode()) {
            case 176: 
            case 189: {
                int sw1 = l.getElement(1);
                int sw2 = l.getElement(2);
                addr = this.address(sw1, sw2);
                this.lastSWREQ = new LocoNetMessage(l);
                if ((sw1 & 0xFC) == 120 && (sw2 & 0xCF) == 7) {
                    return;
                }
                log.debug("SW_REQ received with address {}", (Object)addr);
                break;
            }
            case 177: {
                this.lastSWREQ = null;
                int sw1 = l.getElement(1);
                int sw2 = l.getElement(2);
                addr = this.address(sw1, sw2);
                log.debug("SW_REP received with address {}", (Object)addr);
                break;
            }
            case 180: {
                if (this.lastSWREQ != null && l.getElement(1) == 48 && l.getElement(2) == 0 && !this.mTurnoutNoRetry) {
                    this.fastcontroller.sendLocoNetMessage(this.lastSWREQ);
                }
                this.lastSWREQ = null;
                return;
            }
            default: {
                this.lastSWREQ = null;
                return;
            }
        }
        String s = String.valueOf(prefix) + "T" + addr;
        LnTurnout lnT = (LnTurnout)this.getBySystemName(s);
        if (lnT == null) {
            String sx = String.valueOf(prefix) + "L" + addr;
            if (InstanceManager.lightManagerInstance().getBySystemName(sx) == null) {
                LnTurnout t = (LnTurnout)this.provideTurnout(s);
                t.messageFromManager(l);
            }
        } else {
            lnT.messageFromManager(l);
        }
    }

    private int address(int a1, int a2) {
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, 4096, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        ArrayList l = new ArrayList();
        l.add(new BooleanPropertyDescriptor(BYPASSBUSHBYBITKEY, false){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("LnByPassBushbyHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return bean.getClass().getName().contains("LnTurnout");
            }
        });
        l.add(new BooleanPropertyDescriptor(SENDONANDOFFKEY, !this._binaryOutput){

            @Override
            public String getColumnHeaderText() {
                return Bundle.getMessage("SendOnOffHeader");
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return bean.getClass().getName().contains("LnTurnout");
            }
        });
        return l;
    }
}

