/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.loconet.LocoNetInterface;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnTurnout
extends AbstractTurnout {
    LocoNetInterface controller;
    protected String _prefix = "L";
    boolean feedbackDeliberatelySet = false;
    static String[] modeNames = null;
    static int[] modeValues = null;
    boolean _useOffSwReqAsConfirmation = false;
    boolean pending = false;
    int _number;
    static final int METERINTERVAL = 100;
    private TimerTask meterTask = null;
    static final int CONSISTENCYTIMER = 3000;
    int noConsistencyTimersRunning = 0;
    private TimerTask consistencyTask = null;
    private static final Logger log = LoggerFactory.getLogger(LnTurnout.class);

    public LnTurnout(String prefix, int number, LocoNetInterface controller) throws IllegalArgumentException {
        super(String.valueOf(prefix) + "T" + number);
        this._prefix = prefix;
        log.debug("new turnout {}", (Object)number);
        if (number < 1 || number > 2048) {
            throw new IllegalArgumentException("Turnout value: " + number + " not in the range " + 1 + " to " + 2048);
        }
        this.controller = controller;
        this._number = number;
        this._validFeedbackTypes |= 0xE;
        this._activeFeedbackType = 8;
        if (modeNames == null) {
            this.initFeedbackModes();
        }
        this._validFeedbackNames = modeNames;
        this._validFeedbackModes = modeValues;
    }

    @Override
    public void setBinaryOutput(boolean state) {
        this.setProperty("Send ON/OFF", !state);
        this.binaryOutput = state;
    }

    @Override
    public void setFeedbackMode(@Nonnull String mode) throws IllegalArgumentException {
        this.feedbackDeliberatelySet = true;
        super.setFeedbackMode(mode);
    }

    @Override
    public void setFeedbackMode(int mode) throws IllegalArgumentException {
        this.feedbackDeliberatelySet = true;
        super.setFeedbackMode(mode);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during creation of 1st turnout")
    private void initFeedbackModes() {
        if (this._validFeedbackNames.length != this._validFeedbackModes.length) {
            log.error("int and string feedback arrays different length");
        }
        String[] tempModeNames = new String[this._validFeedbackNames.length + 3];
        int[] tempModeValues = new int[this._validFeedbackNames.length + 3];
        int i = 0;
        while (i < this._validFeedbackNames.length) {
            tempModeNames[i] = this._validFeedbackNames[i];
            tempModeValues[i] = this._validFeedbackModes[i];
            ++i;
        }
        tempModeNames[this._validFeedbackNames.length] = "MONITORING";
        tempModeValues[this._validFeedbackNames.length] = 8;
        tempModeNames[this._validFeedbackNames.length + 1] = "INDIRECT";
        tempModeValues[this._validFeedbackNames.length + 1] = 4;
        tempModeNames[this._validFeedbackNames.length + 2] = "EXACT";
        tempModeValues[this._validFeedbackNames.length + 2] = 2;
        modeNames = tempModeNames;
        modeValues = tempModeValues;
    }

    public int getNumber() {
        return this._number;
    }

    public void setUseOffSwReqAsConfirmation(boolean state) {
        this._useOffSwReqAsConfirmation = state;
    }

    public boolean isByPassBushbyBit() {
        Object returnVal = this.getProperty("Bypass Bushby Bit");
        if (returnVal == null) {
            return false;
        }
        return (Boolean)returnVal;
    }

    public boolean isSendOnAndOff() {
        Object returnVal = this.getProperty("Send ON/OFF");
        if (returnVal == null) {
            return true;
        }
        return (Boolean)returnVal;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newstate) {
        this.sendOpcSwReqMessage(this.adjustStateForInversion(newstate), true);
        if (this.isSendOnAndOff()) {
            this.meterTask = new TimerTask(newstate){
                int state;
                {
                    this.state = n;
                }

                @Override
                public void run() {
                    try {
                        LnTurnout.this.sendSetOffMessage(this.state);
                    }
                    catch (Exception e) {
                        log.error("Exception occurred while sending delayed off to turnout: {}", (Throwable)e);
                    }
                }
            };
            TimerUtil.schedule(this.meterTask, 100L);
        }
    }

    void sendOpcSwReqMessage(int state, boolean on) {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setOpCode(this.isByPassBushbyBit() ? 189 : 176);
        int hiadr = (this._number - 1) / 128 & 0x7F;
        l.setElement(1, this._number - 1 - hiadr * 128 & 0x7F);
        if ((state & 2) != 0) {
            hiadr |= 0x20;
            if ((state & 4) != 0) {
                log.error("LocoNet turnout logic can't handle both THROWN and CLOSED yet");
            }
        }
        if (on) {
            hiadr |= 0x10;
        } else if (this._useOffSwReqAsConfirmation) {
            log.warn("Turnout {} is using OPC_SWREQ off as confirmation, but is sending OFF commands itself anyway", (Object)this._number);
        }
        l.setElement(2, hiadr);
        this.controller.sendLocoNetMessage(l);
        if (this._useOffSwReqAsConfirmation) {
            ++this.noConsistencyTimersRunning;
            this.startConsistencyTimerTask();
        }
    }

    private void startConsistencyTimerTask() {
        this.consistencyTask = new TimerTask(){

            @Override
            public void run() {
                --LnTurnout.this.noConsistencyTimersRunning;
                if (!LnTurnout.this.isConsistentState() && LnTurnout.this.noConsistencyTimersRunning == 0) {
                    log.debug("LnTurnout resending command for turnout {}", (Object)LnTurnout.this._number);
                    LnTurnout.this.forwardCommandChangeToLayout(LnTurnout.this.getCommandedState());
                }
            }
        };
        TimerUtil.schedule(this.consistencyTask, 3000L);
    }

    void sendSetOffMessage(int state) {
        this.sendOpcSwReqMessage(this.adjustStateForInversion(state), false);
    }

    private void handleReceivedOpSwAckReq(LocoNetMessage l) {
        int sw2 = l.getElement(2);
        if (this.myAddress(l.getElement(1), sw2)) {
            log.debug("SW_REQ received with valid address");
            int state = (sw2 & 0x20) != 0 ? 2 : 4;
            state = this.adjustStateForInversion(state);
            this.newCommandedState(state);
            this.computeKnownStateOpSwAckReq(sw2, state);
        }
    }

    private void computeKnownStateOpSwAckReq(int sw2, int state) {
        boolean on = (sw2 & 0x10) != 0;
        switch (this.getFeedbackMode()) {
            case 8: {
                if (on && this._useOffSwReqAsConfirmation) break;
                this.newKnownState(state);
                break;
            }
            case 1: {
                this.newKnownState(state);
                break;
            }
        }
    }

    private void setKnownStateFromOutputStateClosedReport() {
        this.newCommandedState(2);
        if (this.getFeedbackMode() == 8 || this.getFeedbackMode() == 1) {
            this.newKnownState(2);
        }
    }

    private void setKnownStateFromOutputStateThrownReport() {
        this.newCommandedState(4);
        if (this.getFeedbackMode() == 8 || this.getFeedbackMode() == 1) {
            this.newKnownState(4);
        }
    }

    private void setKnownStateFromOutputStateOddReport() {
        this.newCommandedState(6);
        if (this.getFeedbackMode() == 8 || this.getFeedbackMode() == 1) {
            this.newKnownState(6);
        }
    }

    private void setKnownStateFromOutputStateReallyOddReport() {
        this.newCommandedState(0);
        if (this.getFeedbackMode() == 8 || this.getFeedbackMode() == 1) {
            this.newKnownState(0);
        }
    }

    private void computeFromOutputStateReport(int sw2) {
        int state = sw2 & 0x30;
        state = this.adjustStateForInversion(state);
        switch (state) {
            case 32: {
                this.setKnownStateFromOutputStateClosedReport();
                break;
            }
            case 16: {
                this.setKnownStateFromOutputStateThrownReport();
                break;
            }
            case 48: {
                this.setKnownStateFromOutputStateOddReport();
                break;
            }
            default: {
                this.setKnownStateFromOutputStateReallyOddReport();
            }
        }
    }

    private void computeFeedbackFromSwitchReport(int sw2) {
        if ((sw2 & 0x10) != 0) {
            this.computeFeedbackFromSwitchOffReport();
        } else {
            this.computeFeedbackFromSwitchOnReport();
        }
    }

    private void computeFeedbackFromSwitchOffReport() {
        if (this.getFeedbackMode() == 2) {
            this.newKnownState(this.adjustStateForInversion(2));
        } else if (this.getFeedbackMode() == 4) {
            this.newKnownState(this.adjustStateForInversion(2));
        } else if (!this.feedbackDeliberatelySet) {
            log.debug("setting CLOSED with !feedbackDeliberatelySet");
            this.newKnownState(this.adjustStateForInversion(2));
        }
    }

    private void computeFeedbackFromSwitchOnReport() {
        if (this.getFeedbackMode() == 2) {
            if (this.getKnownState() != 4) {
                this.newKnownState(8);
            }
        } else if (this.getFeedbackMode() == 4) {
            this.newKnownState(this.adjustStateForInversion(4));
        } else if (!this.feedbackDeliberatelySet) {
            log.debug("setting THROWN with !feedbackDeliberatelySet");
            this.newKnownState(this.adjustStateForInversion(4));
        }
    }

    private void computeFromSwFeedbackState(int sw2) {
        if ((sw2 & 0x20) != 0) {
            this.computeFeedbackFromSwitchReport(sw2);
        } else {
            this.computeFeedbackFromAuxInputReport(sw2);
        }
    }

    private void computeFeedbackFromAuxInputReport(int sw2) {
        if (!this.feedbackDeliberatelySet) {
            this.setFeedbackMode(2);
            this.feedbackDeliberatelySet = false;
        }
        if ((sw2 & 0x10) != 0) {
            if (this.getFeedbackMode() == 2) {
                this.newKnownState(this.adjustStateForInversion(4));
            }
        } else if (this.getFeedbackMode() == 2 && this.getKnownState() != 2) {
            this.newKnownState(8);
        }
    }

    private void handleReceivedOpSwRep(LocoNetMessage l) {
        int sw2;
        int sw1 = l.getElement(1);
        if (this.myAddress(sw1, sw2 = l.getElement(2))) {
            log.debug("SW_REP received with valid address");
            if ((sw2 & 0x40) == 0) {
                this.computeFromOutputStateReport(sw2);
            } else {
                this.computeFromSwFeedbackState(sw2);
            }
        }
    }

    public void messageFromManager(LocoNetMessage l) {
        switch (l.getOpCode()) {
            case 176: 
            case 189: {
                this.handleReceivedOpSwAckReq(l);
                return;
            }
            case 177: {
                this.handleReceivedOpSwRep(l);
                return;
            }
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        if (log.isDebugEnabled()) {
            log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this._prefix, this._number});
        }
    }

    @Override
    public void dispose() {
        if (this.meterTask != null) {
            this.meterTask.cancel();
        }
        if (this.consistencyTask != null) {
            this.consistencyTask.cancel();
        }
        super.dispose();
    }

    private boolean myAddress(int a1, int a2) {
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1 == this._number;
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    private int adjustStateForInversion(int rawState) {
        if (this.getInverted() && (rawState == 2 || rawState == 4)) {
            if (rawState == 2) {
                return 4;
            }
            return 2;
        }
        return rawState;
    }
}

