/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Vector;
import javax.annotation.Nonnull;
import jmri.jmrix.loconet.LocoNetInterface;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LnTrafficController
implements LocoNetInterface {
    LocoNetSystemConnectionMemo memo = null;
    protected Vector<LocoNetListener> listeners = new Vector();
    protected int receivedMsgCount = 0;
    protected int receivedByteCount = 0;
    protected int transmittedMsgCount = 0;
    private static final Logger log = LoggerFactory.getLogger(LnTrafficController.class);

    public LnTrafficController() {
    }

    public LnTrafficController(LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
    }

    @Override
    public void setSystemConnectionMemo(LocoNetSystemConnectionMemo m) {
        log.debug("LnTrafficController set memo to {}", (Object)m.getUserName());
        this.memo = m;
    }

    @Override
    public LocoNetSystemConnectionMemo getSystemConnectionMemo() {
        log.debug("getSystemConnectionMemo {} called in LnTC", (Object)this.memo.getUserName());
        return this.memo;
    }

    @Override
    public abstract boolean status();

    @Override
    public abstract void sendLocoNetMessage(LocoNetMessage var1);

    @Override
    public synchronized void addLocoNetListener(int mask, @Nonnull LocoNetListener l) {
        Objects.requireNonNull(l);
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    @Override
    public synchronized void removeLocoNetListener(int mask, @Nonnull LocoNetListener l) {
        Objects.requireNonNull(l);
        if (this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(LocoNetMessage m) {
        ArrayList<LocoNetListener> v;
        ++this.receivedMsgCount;
        this.receivedByteCount += m.getNumDataElements();
        LnTrafficController lnTrafficController = this;
        synchronized (lnTrafficController) {
            v = new ArrayList<LocoNetListener>(this.listeners);
        }
        log.debug("notify of incoming LocoNet packet: {}", (Object)m);
        for (LocoNetListener client : v) {
            log.trace("  notify {} of incoming LocoNet packet: {}", (Object)client, (Object)m);
            client.message(m);
        }
    }

    public abstract boolean isXmtBusy();

    public void resetStatistics() {
        this.receivedMsgCount = 0;
        this.transmittedMsgCount = 0;
        this.receivedByteCount = 0;
    }

    public void dispose() {
    }

    public int getReceivedMsgCount() {
        return this.receivedMsgCount;
    }

    public int getReceivedByteCount() {
        return this.receivedByteCount;
    }

    public int getTransmittedMsgCount() {
        return this.transmittedMsgCount;
    }
}

