/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.EnumSet;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.LocoNetThrottle;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.SlotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnThrottleManager
extends AbstractThrottleManager
implements SlotListener {
    protected SlotManager slotManager;
    protected LnTrafficController tc;
    volatile Thread retrySetupThread;
    Hashtable<Integer, Thread> waitingForNotification = new Hashtable(5);
    Hashtable<Integer, LocoNetSlot> slotForAddress;
    LinkedBlockingQueue<ThrottleRequest> requestList;
    boolean requestOutstanding = false;
    protected int throttleID = 369;
    private static final Logger log = LoggerFactory.getLogger(LnThrottleManager.class);

    public LnThrottleManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
        this.slotManager = memo.getSlotManager();
        this.tc = memo.getLnTrafficController();
        this.requestList = new LinkedBlockingQueue();
        this.slotForAddress = new Hashtable();
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    @Override
    public boolean enablePrefSilentStealOption() {
        return true;
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        log.debug("requestThrottleSetup: address {}, control {}", (Object)address, (Object)control);
        if (this.requestOutstanding) {
            try {
                this.requestList.put(new ThrottleRequest(address, control));
            }
            catch (InterruptedException interruptedException) {
                log.error("Interrupted while trying to store throttle request");
                this.requestOutstanding = false;
            }
        } else {
            this.requestOutstanding = true;
            this.processThrottleSetupRequest(address, control);
        }
    }

    protected void processQueuedThrottleSetupRequest() {
        if (!this.requestOutstanding && this.requestList.size() != 0) {
            this.requestOutstanding = true;
            try {
                ThrottleRequest tr = this.requestList.take();
                this.processThrottleSetupRequest(tr.getAddress(), tr.getControl());
            }
            catch (InterruptedException interruptedException) {
                log.error("Interrupted while trying to process process throttle request");
                this.requestOutstanding = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThrottleSetupRequest(LocoAddress address, boolean control) {
        this.slotManager.slotFromLocoAddress(address.getNumber(), this);
        class RetrySetup
        implements Runnable {
            final DccLocoAddress address;
            final SlotListener list;

            RetrySetup(DccLocoAddress address, SlotListener list) {
                this.address = address;
                this.list = list;
            }

            @Override
            public void run() {
                int attempts = 1;
                int maxAttempts = 10;
                while (attempts <= maxAttempts) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    String msg = "No response to slot request for {}, attempt {}";
                    if (attempts < maxAttempts) {
                        LnThrottleManager.this.slotManager.slotFromLocoAddress(this.address.getNumber(), this.list);
                        msg = String.valueOf(msg) + ", trying again.";
                    }
                    log.debug(msg, (Object)this.address, (Object)attempts);
                    ++attempts;
                }
                log.error("No response to slot request for {} after {} attempts.", (Object)this.address, (Object)(attempts - 1));
                LnThrottleManager.this.failedThrottleRequest(this.address, "Failed to get response from command station");
                LnThrottleManager.this.requestOutstanding = false;
                LnThrottleManager.this.processQueuedThrottleSetupRequest();
            }
        }
        this.retrySetupThread = new Thread(new RetrySetup(new DccLocoAddress(address.getNumber(), LnThrottleManager.isLongAddress(address.getNumber())), this));
        this.retrySetupThread.setName("LnThrottleManager RetrySetup " + address);
        this.retrySetupThread.start();
        LnThrottleManager lnThrottleManager = this;
        synchronized (lnThrottleManager) {
            this.waitingForNotification.put(address.getNumber(), this.retrySetupThread);
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return true;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28, SpeedStepMode.MOTOROLA_28, SpeedStepMode.NMRA_DCC_14);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChangedSlot(LocoNetSlot s) {
        log.debug("notifyChangedSlot - slot {}, slotStatus {}", (Object)s.getSlot(), (Object)Integer.toHexString(s.slotStatus()));
        if (s.slotStatus() == 48) {
            log.warn("slot {} address {} is already in-use.", (Object)s.getSlot(), (Object)s.locoAddr());
            if (s.id() != 0 && s.id() != this.throttleID) {
                LnThrottleManager lnThrottleManager = this;
                synchronized (lnThrottleManager) {
                    this.slotForAddress.put(s.locoAddr(), s);
                }
                this.notifyStealRequest(s.locoAddr());
                return;
            }
        }
        this.commitToAcquireThrottle(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToAcquireThrottle(LocoNetSlot s) {
        DccThrottle throttle = this.createThrottle((LocoNetSystemConnectionMemo)this.adapterMemo, s);
        s.notifySlotListeners();
        this.notifyThrottleKnown(throttle, new DccLocoAddress(s.locoAddr(), LnThrottleManager.isLongAddress(s.locoAddr())));
        LnThrottleManager lnThrottleManager = this;
        synchronized (lnThrottleManager) {
            if (this.waitingForNotification.containsKey(s.locoAddr())) {
                log.debug("LnThrottleManager.notifyChangedSlot() - removing throttle acquisition notification flagging for address {}", (Object)s.locoAddr());
                this.waitingForNotification.get(s.locoAddr()).interrupt();
                this.waitingForNotification.remove(s.locoAddr());
            } else {
                log.debug("LnThrottleManager.notifyChangedSlot() - ignoring slot notification for slot {}, address {} account not attempting to acquire that address", (Object)s.getSlot(), (Object)s.locoAddr());
            }
            this.slotForAddress.remove(s.locoAddr());
        }
        this.requestOutstanding = false;
        this.processQueuedThrottleSetupRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRefused(int address, String cause) {
        LnThrottleManager lnThrottleManager = this;
        synchronized (lnThrottleManager) {
            if (this.waitingForNotification.containsKey(address)) {
                this.waitingForNotification.get(address).interrupt();
                this.waitingForNotification.remove(address);
                class InformRejection
                implements Runnable {
                    final int address;
                    final String cause;

                    InformRejection(int address, String s) {
                        this.address = address;
                        this.cause = s;
                    }

                    @Override
                    public void run() {
                        log.debug("New thread launched to inform throttle user of failure to acquire loco {} - {}", (Object)this.address, (Object)this.cause);
                        LnThrottleManager.this.failedThrottleRequest(new DccLocoAddress(this.address, LnThrottleManager.isLongAddress(this.address)), this.cause);
                    }
                }
                Thread thr = new Thread(new InformRejection(address, cause));
                thr.start();
            }
            this.slotForAddress.remove(address);
        }
        this.requestOutstanding = false;
        this.processQueuedThrottleSetupRequest();
    }

    DccThrottle createThrottle(LocoNetSystemConnectionMemo memo, LocoNetSlot s) {
        log.debug("createThrottle: slot {}", (Object)s.getSlot());
        return new LocoNetThrottle(memo, s);
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return LnThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !LnThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    protected static boolean isLongAddress(int num) {
        return num >= 128;
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("disposeThrottle - throttle {}", (Object)t.getLocoAddress());
        if (t instanceof LocoNetThrottle && super.disposeThrottle(t, l)) {
            LocoNetThrottle lnt = (LocoNetThrottle)t;
            lnt.throttleDispose();
            return true;
        }
        return false;
    }

    @Override
    public void dispatchThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("dispatchThrottle - throttle {}", (Object)t.getLocoAddress());
        if (t instanceof LocoNetThrottle) {
            if (super.getThrottleUsageCount(t.getLocoAddress()) == 1) {
                ((LocoNetThrottle)t).dispatchThrottle(t, l);
            } else {
                return;
            }
        }
        super.releaseThrottle(t, l);
    }

    @Override
    public void releaseThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("releaseThrottle - throttle {}", (Object)t.getLocoAddress());
        super.releaseThrottle(t, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failedThrottleRequest(LocoAddress address, String reason) {
        super.failedThrottleRequest(address, reason);
        log.debug("failedThrottleRequest - address {}, reason {}", (Object)address, (Object)reason);
        LnThrottleManager lnThrottleManager = this;
        synchronized (lnThrottleManager) {
            if (this.waitingForNotification.containsKey(address.getNumber())) {
                this.waitingForNotification.get(address.getNumber()).interrupt();
                this.waitingForNotification.remove(address.getNumber());
            }
            this.slotForAddress.remove(address.getNumber());
        }
        this.requestOutstanding = false;
        this.processQueuedThrottleSetupRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelThrottleRequest(LocoAddress address, ThrottleListener l) {
        super.cancelThrottleRequest(address, l);
        this.failedThrottleRequest(address, "Throttle Request " + address + " Cancelled.");
        int loconumber = address.getNumber();
        log.debug("cancelThrottleRequest - loconumber {}", (Object)loconumber);
        LnThrottleManager lnThrottleManager = this;
        synchronized (lnThrottleManager) {
            if (this.waitingForNotification.containsKey(loconumber)) {
                this.waitingForNotification.get(loconumber).interrupt();
                this.waitingForNotification.remove(loconumber);
            }
            this.slotForAddress.remove(loconumber);
        }
        this.requestOutstanding = false;
        this.processQueuedThrottleSetupRequest();
    }

    public int getThrottleID() {
        return this.throttleID;
    }

    @Override
    public void dispose() {
        if (this.retrySetupThread != null) {
            try {
                this.retrySetupThread.interrupt();
                this.retrySetupThread.join();
            }
            catch (InterruptedException interruptedException) {
                log.warn("dispose interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStealRequest(int locoAddr) {
        LnThrottleManager lnThrottleManager = this;
        synchronized (lnThrottleManager) {
            if (this.waitingForNotification.containsKey(locoAddr)) {
                this.waitingForNotification.get(locoAddr).interrupt();
                this.waitingForNotification.remove(locoAddr);
                this.notifyDecisionRequest(new DccLocoAddress(locoAddr, LnThrottleManager.isLongAddress(locoAddr)), ThrottleListener.DecisionType.STEAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseThrottleDecision(LocoAddress address, ThrottleListener l, ThrottleListener.DecisionType decision) {
        log.debug("{} decision invoked for address {}", (Object)decision, (Object)address.getNumber());
        if (decision == ThrottleListener.DecisionType.STEAL) {
            LocoNetSlot slot;
            LnThrottleManager lnThrottleManager = this;
            synchronized (lnThrottleManager) {
                slot = this.slotForAddress.get(address.getNumber());
            }
            if (slot != null) {
                this.commitToAcquireThrottle(slot);
            } else {
                log.error("Address {} not found in list of slots", (Object)address.getNumber());
            }
        } else {
            log.error("Invalid DecisionType {} for LnThrottleManager.", (Object)decision);
        }
    }

    protected static class ThrottleRequest {
        private LocoAddress la = null;
        private boolean tc = false;

        ThrottleRequest(LocoAddress l, boolean control) {
            this.la = l;
            this.tc = control;
        }

        public boolean getControl() {
            return this.tc;
        }

        public LocoAddress getAddress() {
            return this.la;
        }
    }
}

