/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnSensor;
import jmri.jmrix.loconet.LnSensorAddress;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnSensorManager
extends AbstractSensorManager
implements LocoNetListener {
    protected final LnTrafficController tc;
    protected int restingTime = 1250;
    private volatile Instant lastSensTurnInterrog;
    volatile LnSensorUpdateThread thread;
    private boolean busy = false;
    int iName;
    private static final Logger log = LoggerFactory.getLogger(LnSensorManager.class);

    public LnSensorManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getLnTrafficController();
        if (this.tc == null) {
            log.error("SensorManager Created, yet there is no Traffic Controller");
            return;
        }
        this.lastSensTurnInterrog = Instant.now();
        this.tc.addLocoNetListener(-1, this);
        this.updateAll();
    }

    @Override
    @Nonnull
    public LocoNetSystemConnectionMemo getMemo() {
        return (LocoNetSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        block6: {
            this.tc.removeLocoNetListener(-1, this);
            LnSensorUpdateThread t = this.thread;
            if (t != null) {
                try {
                    try {
                        t.interrupt();
                        t.join();
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn("dispose interrupted");
                        this.thread = null;
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.thread = null;
                    throw throwable;
                }
                this.thread = null;
            }
        }
        super.dispose();
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        return new LnSensor(systemName, userName, this.tc, this.getSystemPrefix());
    }

    @Override
    public void message(LocoNetMessage l) {
        LnSensorAddress a;
        switch (l.getOpCode()) {
            case 178: {
                int sw1 = l.getElement(1);
                int sw2 = l.getElement(2);
                a = new LnSensorAddress(sw1, sw2, this.getSystemPrefix());
                log.debug("INPUT_REP received with address {}", (Object)a);
                this.lastSensTurnInterrog = Instant.now();
                break;
            }
            case 177: {
                this.lastSensTurnInterrog = Instant.now();
                return;
            }
            case 176: 
            case 189: {
                int address = (l.getElement(1) & 0x7F) + 128 * (l.getElement(2) & 0xF);
                switch (address) {
                    case 1016: 
                    case 1017: 
                    case 1018: 
                    case 1019: {
                        this.lastSensTurnInterrog = Instant.now();
                        return;
                    }
                }
            }
            default: {
                return;
            }
        }
        String s = a.getNumericAddress();
        LnSensor ns = (LnSensor)this.getBySystemName(s);
        if (ns == null) {
            if (log.isDebugEnabled()) {
                log.debug("Create new LnSensor as {}", (Object)s);
            }
            ns = (LnSensor)this.newSensor(s, null);
        }
        ns.messageFromManager(l);
    }

    @Override
    public void updateAll() {
        if (!this.busy) {
            this.setUpdateBusy();
            this.thread = new LnSensorUpdateThread(this, this.tc, this.getRestingTime());
            this.thread.setName("LnSensorUpdateThread");
            this.thread.start();
        }
    }

    public void setUpdateBusy() {
        this.busy = true;
    }

    public void setUpdateNotBusy() {
        this.busy = false;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (curAddress.contains(":")) {
            int board = 0;
            int channel = 0;
            int seperator = curAddress.indexOf(":");
            boolean turnout = false;
            if (curAddress.substring(0, seperator).toUpperCase().equals("T")) {
                turnout = true;
            } else {
                try {
                    board = Integer.parseInt(curAddress.substring(0, seperator));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JmriException("Unable to convert '" + curAddress + "' into the cab and channel format of nn:xx");
                }
            }
            try {
                channel = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert '" + curAddress + "' into the cab and channel format of nn:xx");
            }
            this.iName = turnout ? 2 * (channel - 1) + 1 : 16 * board + channel - 16;
            LoggingUtil.warnOnce(log, "LnSensorManager.createSystemName(curAddress, prefix) support for curAddress using the '{}' format is deprecated as of JMRI 4.17.4 and will be removed in a future JMRI release.  Use the curAddress format '{}' instead.", curAddress, this.iName);
        } else {
            log.debug("LnSensorManager creating system name for {}", (Object)curAddress);
            try {
                this.iName = Integer.parseInt(curAddress);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Hardware Address passed " + curAddress + " should be a number");
            }
        }
        return String.valueOf(prefix) + this.typeLetter() + this.iName;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, 4096, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    public void setRestingTime(int rest) {
        if (rest < 500) {
            rest = 500;
        } else if (rest > 200000) {
            rest = 200000;
        }
        this.restingTime = rest;
    }

    public int getRestingTime() {
        return this.restingTime;
    }

    class LnSensorUpdateThread
    extends Thread {
        private LnSensorManager sm = null;
        private LnTrafficController tc = null;
        private Duration restingTime;

        public LnSensorUpdateThread(LnSensorManager sm, LnTrafficController tc, int restingTime) {
            this.sm = sm;
            this.tc = tc;
            this.restingTime = Duration.ofMillis(restingTime);
        }

        @Override
        public void run() {
            this.sm.setUpdateBusy();
            while (!this.tc.status()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    this.sm.setUpdateNotBusy();
                    return;
                }
            }
            byte[] sw1 = new byte[]{120, 121, 122, 123, 120, 121, 122, 123};
            byte[] sw2 = new byte[]{39, 39, 39, 39, 7, 7, 7, 7};
            LocoNetMessage msg = new LocoNetMessage(4);
            msg.setOpCode(176);
            int k = 0;
            while (k < 8) {
                Instant n = Instant.now();
                Instant n2 = LnSensorManager.this.lastSensTurnInterrog.plus(this.restingTime);
                int result = n.compareTo(n2);
                log.debug("Interrogation phase {}: now {}, lastSensInterrog {}, target{}, time compare result {}", new Object[]{k, n, LnSensorManager.this.lastSensTurnInterrog, n2, result});
                while (result < 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        this.sm.setUpdateNotBusy();
                        return;
                    }
                    n = Instant.now();
                    result = n.compareTo(n2);
                    log.debug("Interrogation phase {}: now {}, lastSensInterrog {}, target{}, time compare result {}", new Object[]{k, n, LnSensorManager.this.lastSensTurnInterrog, n2, result});
                }
                msg.setElement(1, sw1[k]);
                msg.setElement(2, sw2[k]);
                this.tc.sendLocoNetMessage(msg);
                LnSensorManager.this.lastSensTurnInterrog = Instant.now();
                log.debug("LnSensorUpdate sent");
                ++k;
            }
            this.sm.setUpdateNotBusy();
        }
    }
}

