/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Reporter;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnReporter;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.managers.AbstractReporterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnReporterManager
extends AbstractReporterManager
implements LocoNetListener {
    protected final LnTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(LnReporterManager.class);

    public LnReporterManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getLnTrafficController();
        if (this.tc != null) {
            this.tc.addLocoNetListener(-1, this);
        } else {
            log.error("No layout connection, Reporter manager can't function");
        }
    }

    @Override
    @Nonnull
    public LocoNetSystemConnectionMemo getMemo() {
        return (LocoNetSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        if (this.tc != null) {
            this.tc.removeLocoNetListener(-1, this);
        }
        super.dispose();
    }

    @Override
    @Nonnull
    protected Reporter createNewReporter(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr = Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
        LnReporter t = new LnReporter(addr, this.tc, this.getSystemPrefix());
        t.setUserName(userName);
        t.addPropertyChangeListener(this);
        return t;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, 4096, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    @Override
    public void message(LocoNetMessage l) {
        int addr;
        switch (l.getOpCode()) {
            case 208: {
                if ((l.getElement(1) & 0xC0) == 0) {
                    addr = (l.getElement(1) & 0x1F) * 128 + l.getElement(2) + 1;
                    break;
                }
                return;
            }
            case 229: {
                if (l.getElement(1) == 9 && l.getElement(2) == 0) {
                    addr = (l.getElement(5) & 0x1F) * 128 + l.getElement(6) + 1;
                    break;
                }
                return;
            }
            case 228: {
                if (l.getElement(1) == 8) {
                    addr = l.getElement(4) & 0x7F;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        log.debug("Reporter[{}]", (Object)addr);
        LnReporter r = (LnReporter)this.provideReporter(String.valueOf(this.getSystemNamePrefix()) + addr);
        r.messageFromManager(l);
    }
}

