/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.CollectingReporter;
import jmri.DccLocoAddress;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.PhysicalLocationReporter;
import jmri.implementation.AbstractIdTagReporter;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.TranspondingTag;
import jmri.jmrix.loconet.TranspondingTagManager;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnReporter
extends AbstractIdTagReporter
implements CollectingReporter {
    int lastLoco = -1;
    private int _number;
    private HashSet<TranspondingTag> entrySet = null;
    private static final Logger log = LoggerFactory.getLogger(LnReporter.class);

    public LnReporter(int number, LnTrafficController tc, String prefix) {
        super(String.valueOf(prefix) + "R" + number);
        log.debug("new Reporter {}", (Object)number);
        this._number = number;
        this.entrySet = new HashSet();
    }

    public int getNumber() {
        return this._number;
    }

    public void messageFromManager(LocoNetMessage l) {
        if (this.isTranspondingLocationReport(l) || this.isTranspondingFindReport(l)) {
            this.transpondingReport(l);
        }
        if (l.getOpCode() != 228 || l.getElement(1) != 8) {
            return;
        }
        this.lissyReport(l);
    }

    public final boolean isTranspondingLocationReport(LocoNetMessage l) {
        return l.getOpCode() == 208 && (l.getElement(1) & 0xC0) == 0;
    }

    public final boolean isTranspondingFindReport(LocoNetMessage l) {
        return l.getOpCode() == 229 && l.getElement(1) == 9 && l.getElement(2) == 0;
    }

    void transpondingReport(LocoNetMessage l) {
        boolean enter = l.getOpCode() == 208 ? (l.getElement(1) & 0x20) != 0 : true;
        int loco = this.getLocoAddrFromTranspondingMsg(l);
        this.notify(null);
        IdTag idTag = InstanceManager.getDefault(TranspondingTagManager.class).provideIdTag("" + loco);
        idTag.setProperty("entryexit", "enter");
        if (enter) {
            idTag.setProperty("entryexit", "enter");
            if (!this.entrySet.contains(idTag)) {
                this.entrySet.add((TranspondingTag)idTag);
            }
        } else {
            idTag.setProperty("entryexit", "exits");
            if (this.entrySet.contains(idTag)) {
                this.entrySet.remove(idTag);
            }
        }
        log.debug("Tag: {}", (Object)idTag);
        this.notify(idTag);
        this.setState(enter ? loco : -1);
    }

    public int getLocoAddrFromTranspondingMsg(LocoNetMessage l) {
        if (l.getElement(3) == 125) {
            return l.getElement(4);
        }
        return l.getElement(3) * 128 + l.getElement(4);
    }

    void lissyReport(LocoNetMessage l) {
        int loco = (l.getElement(6) & 0x7F) + 128 * (l.getElement(5) & 0x7F);
        boolean north = (l.getElement(3) & 0x20) == 0;
        this.notify(null);
        IdTag idTag = InstanceManager.getDefault(TranspondingTagManager.class).provideIdTag("" + loco);
        if (north) {
            idTag.setProperty("seen", "seen northbound");
        } else {
            idTag.setProperty("seen", "seen southbound");
        }
        log.debug("Tag: {}", (Object)idTag);
        this.notify(idTag);
        this.setState(loco);
    }

    @Override
    public int getState() {
        return this.lastLoco;
    }

    @Override
    public void setState(int s) {
        this.lastLoco = s;
    }

    private Matcher parseReport(String rep) {
        if (rep == null) {
            return null;
        }
        Pattern ln_p = Pattern.compile("(\\d+) (enter|exits|seen)\\s*(northbound|southbound)?");
        Matcher m = ln_p.matcher(rep);
        return m;
    }

    @Override
    public LocoAddress getLocoAddress(String rep) {
        log.debug("report string: {}", (Object)rep);
        Matcher m = this.parseReport(rep);
        if (m != null && m.find()) {
            log.debug("Parsed address: {}", (Object)m.group(1));
            return new DccLocoAddress(Integer.parseInt(m.group(1)), LocoAddress.Protocol.DCC);
        }
        return null;
    }

    @Override
    public PhysicalLocationReporter.Direction getDirection(String rep) {
        block10: {
            log.debug("report string: {}", (Object)rep);
            Matcher m = this.parseReport(rep);
            if (!m.find()) break block10;
            log.debug("Parsed direction: {}", (Object)m.group(2));
            switch (m.group(2)) {
                case "enter": {
                    return PhysicalLocationReporter.Direction.ENTER;
                }
                case "seen": {
                    return PhysicalLocationReporter.Direction.ENTER;
                }
            }
            return PhysicalLocationReporter.Direction.EXIT;
        }
        return PhysicalLocationReporter.Direction.UNKNOWN;
    }

    @Override
    public PhysicalLocation getPhysicalLocation() {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }

    @Override
    public PhysicalLocation getPhysicalLocation(String s) {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }

    @Override
    public Collection getCollection() {
        return this.entrySet;
    }
}

