/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.Pr2Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnPr2ThrottleManager
extends AbstractThrottleManager {
    DccLocoAddress activeAddress = null;
    private static final Logger log = LoggerFactory.getLogger(LnPr2ThrottleManager.class);

    public LnPr2ThrottleManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    protected boolean singleUse() {
        return true;
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (address instanceof DccLocoAddress) {
            this.activeAddress = (DccLocoAddress)address;
        } else {
            log.error("cannot cast the passed address to DccLocoAddress.");
        }
        log.debug("new Pr2Throttle for {}", (Object)this.activeAddress);
        this.notifyThrottleKnown(new Pr2Throttle((LocoNetSystemConnectionMemo)this.adapterMemo, this.activeAddress), this.activeAddress);
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return LnPr2ThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !LnPr2ThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    static boolean isLongAddress(int num) {
        return num >= 128;
    }

    public DccLocoAddress getActiveAddress() {
        return this.activeAddress;
    }
}

