/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.JmriException;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnPowerManager
extends AbstractPowerManager<LocoNetSystemConnectionMemo>
implements LocoNetListener {
    LnTrafficController tc = null;
    volatile LnTrackStatusUpdateThread thread;
    private static final Logger log = LoggerFactory.getLogger(LnPowerManager.class);

    public LnPowerManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
        if (memo.getLnTrafficController() == null) {
            log.error("PowerManager Created, yet there is no Traffic Controller");
            return;
        }
        this.tc = memo.getLnTrafficController();
        this.tc.addLocoNetListener(-1, this);
        this.updateTrackPowerStatus();
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            LocoNetMessage l = new LocoNetMessage(2);
            l.setOpCode(131);
            this.tc.sendLocoNetMessage(l);
        } else if (v == 4) {
            LocoNetMessage l = new LocoNetMessage(2);
            l.setOpCode(130);
            this.tc.sendLocoNetMessage(l);
        } else if (v == 8 && this.implementsIdle()) {
            LocoNetMessage l = new LocoNetMessage(2);
            l.setOpCode(133);
            this.tc.sendLocoNetMessage(l);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() {
        block7: {
            if (this.thread != null) {
                try {
                    try {
                        this.thread.interrupt();
                        this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn("dispose interrupted");
                        this.thread = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.thread = null;
                    throw throwable;
                }
                this.thread = null;
            }
        }
        if (this.tc != null) {
            this.tc.removeLocoNetListener(-1, this);
        }
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("Use power manager after dispose");
        }
    }

    @Override
    public void message(LocoNetMessage m) {
        int old = this.power;
        block0 : switch (m.getOpCode()) {
            case 131: {
                this.power = 2;
                break;
            }
            case 130: {
                this.power = 4;
                break;
            }
            case 133: {
                this.power = 8;
                break;
            }
            case 231: {
                if (m.getElement(1) != 14 || m.getElement(2) >= 120) break;
                switch (m.getElement(7) & 3) {
                    case 1: {
                        this.power = 8;
                        break block0;
                    }
                    case 3: {
                        this.power = 2;
                        break block0;
                    }
                    case 2: {
                        this.power = 4;
                        break block0;
                    }
                }
                this.power = 1;
                break;
            }
        }
        this.firePowerPropertyChange(old, this.power);
    }

    private void updateTrackPowerStatus() {
        this.thread = new LnTrackStatusUpdateThread(this.tc);
        this.thread.setName("LnPowerManager LnTrackStatusUpdateThread");
        this.thread.start();
    }

    @Override
    public boolean implementsIdle() {
        boolean supportsIdleState = false;
        if (this.tc == null) {
            log.error("TC is null in LnPowerManager");
            return false;
        }
        if (this.tc.memo == null) {
            log.error("TC.Memo is null in LnPowerManager");
            return false;
        }
        LnCommandStationType cmdStationType = this.tc.memo.getSlotManager().getCommandStationType();
        switch (cmdStationType) {
            case COMMAND_STATION_DCS100: 
            case COMMAND_STATION_DCS240: 
            case COMMAND_STATION_DCS210: 
            case COMMAND_STATION_DCS200: 
            case COMMAND_STATION_DB150: {
                supportsIdleState = true;
                break;
            }
            default: {
                supportsIdleState = false;
            }
        }
        return supportsIdleState;
    }

    static class LnTrackStatusUpdateThread
    extends Thread {
        private LnTrafficController tc;

        public LnTrackStatusUpdateThread(LnTrafficController tc) {
            this.tc = tc;
        }

        @Override
        public void run() {
            log.trace("LnTrackStatusUpdateThread start check loop");
            int i = 1;
            while (i <= 10) {
                if (this.tc.status()) break;
                log.trace("LnTrackStatusUpdateThread waiting {} time", (Object)i);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                ++i;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
            log.trace("LnTrackStatusUpdateThread sending request");
            LocoNetMessage msg = new LocoNetMessage(4);
            msg.setOpCode(187);
            msg.setElement(1, 0);
            msg.setElement(2, 0);
            this.tc.sendLocoNetMessage(msg);
            log.debug("LnTrackStatusUpdate sent");
        }
    }
}

