/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.io.EOFException;
import java.io.IOException;
import java.util.NoSuchElementException;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnPacketizerStrict
extends LnPacketizer {
    private LocoNetMessage waitForMsg;
    private boolean waitingOnLack;
    private int waitBusy;
    private boolean reTryRequired;
    private static final Logger log = LoggerFactory.getLogger(LnPacketizerStrict.class);

    public LnPacketizerStrict(LocoNetSystemConnectionMemo m) {
        super(m);
    }

    @Override
    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = {} default = {} min available = {}", new Object[]{priority, 10, 5, 1});
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandlerStrict();
        }
        this.xmtThread = new Thread(this.xmtHandler, "LocoNet transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandlerStrict(this);
        }
        this.rcvThread = new Thread(this.rcvHandler, "LocoNet receive handler");
        this.rcvThread.setDaemon(true);
        this.rcvThread.setPriority(10);
        this.rcvThread.start();
        log.info("Strict Packetizer in use");
    }

    static /* synthetic */ boolean access$7(LnPacketizerStrict lnPacketizerStrict) {
        return lnPacketizerStrict.reTryRequired;
    }

    static /* synthetic */ int access$8(LnPacketizerStrict lnPacketizerStrict) {
        return lnPacketizerStrict.waitBusy;
    }

    protected class RcvHandlerStrict
    implements Runnable {
        LnTrafficController trafficController;

        public RcvHandlerStrict(LnTrafficController lt) {
            this.trafficController = lt;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int opCode;
                        if (((opCode = LnPacketizerStrict.this.readByteProtected(LnPacketizerStrict.this.istream) & 0xFF) & 0x80) == 0) {
                            log.trace("Skipping: {}", (Object)Integer.toHexString(opCode));
                            continue;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace(" (RcvHandler) Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        }
                        LocoNetMessage msg = null;
                        while (msg == null) {
                            try {
                                int byte2 = LnPacketizerStrict.this.readByteProtected(LnPacketizerStrict.this.istream) & 0xFF;
                                if (log.isTraceEnabled()) {
                                    log.trace("Byte2: {}", (Object)Integer.toHexString(byte2));
                                }
                                int len = 2;
                                switch ((opCode & 0x60) >> 5) {
                                    case 0: {
                                        len = 2;
                                        break;
                                    }
                                    case 1: {
                                        len = 4;
                                        break;
                                    }
                                    case 2: {
                                        len = 6;
                                        break;
                                    }
                                    case 3: {
                                        if (byte2 < 2) {
                                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                        }
                                        len = byte2;
                                        break;
                                    }
                                    default: {
                                        log.warn("Unhandled code: {}", (Object)((opCode & 0x60) >> 5));
                                    }
                                }
                                msg = new LocoNetMessage(len);
                                msg.setOpCode(opCode);
                                msg.setElement(1, byte2);
                                log.trace("len: {}", (Object)len);
                                int i = 2;
                                while (i < len) {
                                    int b = LnPacketizerStrict.this.readByteProtected(LnPacketizerStrict.this.istream) & 0xFF;
                                    if (log.isTraceEnabled()) {
                                        log.trace("char {} is: {}", (Object)i, (Object)Integer.toHexString(b));
                                    }
                                    if ((b & 0x80) != 0) {
                                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                        opCode = b;
                                        throw new LocoNetMessageException();
                                    }
                                    msg.setElement(i, b);
                                    ++i;
                                }
                            }
                            catch (LocoNetMessageException locoNetMessageException) {
                                msg = null;
                            }
                        }
                        if (!msg.checkParity()) {
                            log.warn("Ignore LocoNet packet with bad checksum: [{}]", (Object)msg.toString());
                            throw new LocoNetMessageException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("queue message for notification: {}", (Object)msg.toString());
                        }
                        if (LnPacketizerStrict.this.waitForMsg != null && LnPacketizerStrict.this.waitForMsg.equals(msg)) {
                            LnPacketizerStrict.this.waitForMsg = null;
                        }
                        if (LnPacketizerStrict.this.waitingOnLack) {
                            if (msg.getOpCode() == 180) {
                                LnPacketizerStrict.this.waitingOnLack = false;
                                if ((msg.getElement(1) & 0xFF) == 109 && (msg.getElement(2) & 0xFF) == 0) {
                                    LnPacketizerStrict.this.reTryRequired = true;
                                    LnPacketizerStrict.this.waitBusy = 100;
                                    log.warn("IMM Back off");
                                } else {
                                    LnPacketizerStrict.this.reTryRequired = false;
                                }
                            } else if (msg.getOpCode() == 231) {
                                LnPacketizerStrict.this.waitingOnLack = false;
                            } else if (msg.getOpCode() == 230) {
                                LnPacketizerStrict.this.waitingOnLack = false;
                            }
                        } else if (msg.getOpCode() == 129) {
                            LnPacketizerStrict.this.waitBusy = 100;
                            log.warn("CS Busy Back off");
                            LnPacketizerStrict.this.reTryRequired = true;
                        }
                        ThreadingUtil.runOnLayoutEventually(new RcvMemo(msg, this.trafficController));
                    }
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException: {}", (Throwable)e);
                    continue;
                }
                catch (EOFException eOFException) {
                    log.trace("EOFException, is LocoNet serial I/O using timeouts?");
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFIle: {}", (Throwable)e);
                    log.info("End of file");
                    LnPacketizerStrict.this.disconnectPort(LnPacketizerStrict.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected Exception: {}", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private static class RcvMemo
    implements ThreadingUtil.ThreadAction {
        LocoNetMessage thisMsg;
        LnTrafficController thisTc;

        public RcvMemo(LocoNetMessage msg, LnTrafficController trafficController) {
            this.thisMsg = msg;
            this.thisTc = trafficController;
        }

        @Override
        public void run() {
            this.thisTc.notify(this.thisMsg);
        }
    }

    class XmtHandlerStrict
    implements Runnable {
        XmtHandlerStrict() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        LnPacketizerStrict.access$0().trace("check for input");
                        msg = null;
                        var3_3 = this;
                        synchronized (var3_3) {
                            msg = (byte[])LnPacketizerStrict.this.xmtList.removeFirst();
                        }
                        try {
                            block27: {
                                if (LnPacketizerStrict.this.ostream == null) break block27;
                                if (!LnPacketizerStrict.this.controller.okToSend()) {
                                    LnPacketizerStrict.access$0().debug("LocoNet port not ready to receive");
                                }
                                if (LnPacketizerStrict.access$0().isDebugEnabled()) {
                                    LnPacketizerStrict.access$0().debug("start write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                                }
                                LnPacketizerStrict.access$5(LnPacketizerStrict.this, true);
                                reTryCount = 0;
                                while (LnPacketizerStrict.access$7(LnPacketizerStrict.this)) {
                                    LnPacketizerStrict.access$5(LnPacketizerStrict.this, false);
                                    LnPacketizerStrict.access$2(LnPacketizerStrict.this, new LocoNetMessage(msg));
                                    if ((msg[0] & 8) != 0) {
                                        LnPacketizerStrict.access$4(LnPacketizerStrict.this, true);
                                    }
                                    while (LnPacketizerStrict.access$8(LnPacketizerStrict.this) != 0) {
                                        waitTime = LnPacketizerStrict.access$8(LnPacketizerStrict.this);
                                        LnPacketizerStrict.access$6(LnPacketizerStrict.this, 0);
                                        LnPacketizerStrict.access$0().warn("Waitbusy");
                                        try {
                                            Thread.sleep(waitTime);
                                        }
                                        catch (InterruptedException ee) {
                                            LnPacketizerStrict.access$0().warn("waitBusy sleep Interrupted", (Throwable)ee);
                                        }
                                    }
                                    LnPacketizerStrict.this.ostream.write(msg);
                                    LnPacketizerStrict.this.ostream.flush();
                                    if (LnPacketizerStrict.access$0().isTraceEnabled()) {
                                        LnPacketizerStrict.access$0().trace("end write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                                    }
                                    waitCount = 0;
                                    while (LnPacketizerStrict.access$1(LnPacketizerStrict.this) != null && waitCount < 20) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (InterruptedException ee) {
                                            LnPacketizerStrict.access$0().error("waitForMsg sleep Interrupted", (Throwable)ee);
                                        }
                                        ++waitCount;
                                    }
                                    if (waitCount <= 19) ** GOTO lbl65
                                    LnPacketizerStrict.access$0().warn("Retry Send for Lost Packet [{}] Count[{}]", (Object)LnPacketizerStrict.access$1(LnPacketizerStrict.this), (Object)reTryCount);
                                    if (reTryCount < 5) {
                                        LnPacketizerStrict.access$5(LnPacketizerStrict.this, true);
                                        ++reTryCount;
                                        continue;
                                    }
                                    LnPacketizerStrict.access$5(LnPacketizerStrict.this, false);
                                    reTryCount = 0;
                                    LnPacketizerStrict.access$0().warn("Give up on lost packet");
                                    continue;
lbl-1000:
                                    // 1 sources

                                    {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (InterruptedException ee) {
                                            LnPacketizerStrict.access$0().error("waitingOnLack sleep Interrupted", (Throwable)ee);
                                        }
                                        ++waitCount;
lbl65:
                                        // 2 sources

                                        ** while (LnPacketizerStrict.access$3((LnPacketizerStrict)LnPacketizerStrict.this) && waitCount < 50)
                                    }
lbl66:
                                    // 1 sources

                                    if (waitCount <= 49) continue;
                                    try {
                                        LnPacketizerStrict.access$0().warn("Retry Send for Lost Response Count[{}]", (Object)reTryCount);
                                    }
                                    catch (NullPointerException v1) {
                                        LnPacketizerStrict.access$0().warn("Retry Send for waitingOnLack null?  Count[{}]", (Object)reTryCount);
                                    }
                                    if (reTryCount < 5) {
                                        LnPacketizerStrict.access$5(LnPacketizerStrict.this, true);
                                        ++reTryCount;
                                        continue;
                                    }
                                    LnPacketizerStrict.access$0().warn("Give up on Lost Response.");
                                    LnPacketizerStrict.access$5(LnPacketizerStrict.this, false);
                                    reTryCount = 0;
                                }
                                LnPacketizerStrict.this.messageTransmitted(msg);
                                continue;
                            }
                            LnPacketizerStrict.access$0().warn("sendLocoNetMessage: no connection established");
                        }
                        catch (IOException e) {
                            LnPacketizerStrict.access$0().warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                        }
                    }
                }
                catch (NoSuchElementException v2) {
                    LnPacketizerStrict.access$0().trace("start wait");
                    new WaitHandler(this);
                    LnPacketizerStrict.access$0().trace("end wait");
                    continue;
                }
                break;
            }
        }
    }
}

