/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnPacketizer
extends LnTrafficController {
    protected boolean echo = false;
    protected LinkedList<byte[]> xmtList = new LinkedList();
    protected Runnable xmtHandler = null;
    protected Runnable rcvHandler;
    protected LnPortController controller = null;
    public DataInputStream istream = null;
    public OutputStream ostream = null;
    private byte[] rcvBuffer = new byte[1];
    Thread rcvThread;
    Thread xmtThread;
    protected volatile boolean threadStopRequest = false;
    private static final Logger log = LoggerFactory.getLogger(LnPacketizer.class);

    public LnPacketizer(LocoNetSystemConnectionMemo m) {
        this.memo = m;
        m.setLnTrafficController(this);
    }

    @Override
    public boolean status() {
        boolean returnVal = this.ostream != null && this.istream != null && this.xmtThread != null && this.xmtThread.isAlive() && this.xmtHandler != null && this.rcvThread != null && this.rcvThread.isAlive() && this.rcvHandler != null;
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendLocoNetMessage(LocoNetMessage m) {
        ++this.transmittedMsgCount;
        m.setParity();
        int len = m.getNumDataElements();
        byte[] msg = new byte[len];
        int i2 = 0;
        while (i2 < len) {
            msg[i2] = (byte)m.getElement(i2);
            ++i2;
        }
        log.debug("queue LocoNet packet: {}", (Object)m);
        try {
            Runnable i2 = this.xmtHandler;
            synchronized (i2) {
                this.xmtList.addLast(msg);
                this.xmtHandler.notifyAll();
            }
        }
        catch (RuntimeException e) {
            log.warn("passing to xmit: unexpected exception: ", (Throwable)e);
        }
    }

    @Override
    public boolean isXmtBusy() {
        if (this.controller == null) {
            return false;
        }
        return !this.controller.okToSend();
    }

    public void connectPort(LnPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(LnPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortController");
        }
        this.controller = null;
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        while ((nchars = istream.read(this.rcvBuffer, 0, 1)) <= 0) {
        }
        return this.rcvBuffer[0];
    }

    protected void messageTransmitted(byte[] msg) {
        log.debug("message transmitted (echo {})", (Object)this.echo);
        if (!this.echo) {
            return;
        }
        SwingUtilities.invokeLater(new Echo(this, new LocoNetMessage(msg)));
    }

    public void startThreads() {
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = {} default = {} min available = {}", new Object[]{priority, 10, 5, 1});
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        this.rcvThread = new Thread(this.rcvHandler, "LocoNet receive handler");
        this.rcvThread.setDaemon(true);
        this.rcvThread.setPriority(10);
        this.rcvThread.start();
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        int xmtpriority = 9 > priority ? 9 : 10;
        this.xmtThread = new Thread(this.xmtHandler, "LocoNet transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
        log.info("lnPacketizer Started");
    }

    @Override
    public void dispose() {
        if (this.xmtThread != null) {
            this.xmtThread.stop();
            try {
                this.xmtThread.join();
            }
            catch (InterruptedException e) {
                log.warn("unexpected InterruptedException", (Throwable)e);
            }
        }
        if (this.rcvThread != null) {
            this.rcvThread.stop();
            try {
                this.rcvThread.join();
            }
            catch (InterruptedException e) {
                log.warn("unexpected InterruptedException", (Throwable)e);
            }
        }
        super.dispose();
    }

    public void terminateThreads() {
        this.threadStopRequest = true;
        if (this.xmtThread != null) {
            this.xmtThread.interrupt();
            try {
                this.xmtThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
            try {
                this.rcvThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static class Echo
    implements Runnable {
        LocoNetMessage msgForLater;
        LnPacketizer myTc;

        Echo(LnPacketizer t, LocoNetMessage m) {
            this.myTc = t;
            this.msgForLater = m;
        }

        @Override
        public void run() {
            this.myTc.notify(this.msgForLater);
        }
    }

    protected class RcvHandler
    implements Runnable {
        LnTrafficController trafficController;

        public RcvHandler(LnTrafficController lt) {
            this.trafficController = lt;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class RcvMemo
    implements ThreadingUtil.ThreadAction {
        LocoNetMessage thisMsg;
        LnTrafficController thisTc;

        public RcvMemo(LocoNetMessage msg, LnTrafficController trafficController) {
            this.thisMsg = msg;
            this.thisTc = trafficController;
        }

        @Override
        public void run() {
            this.thisTc.notify(this.thisMsg);
        }
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!LnPacketizer.this.threadStopRequest) {
                try {
                    log.trace("check for input");
                    byte[] msg = null;
                    XmtHandler xmtHandler = this;
                    synchronized (xmtHandler) {
                        msg = LnPacketizer.this.xmtList.removeFirst();
                    }
                    try {
                        if (LnPacketizer.this.ostream != null) {
                            if (log.isDebugEnabled()) {
                                if (LnPacketizer.this.isXmtBusy()) {
                                    log.debug("LocoNet port not ready to receive");
                                }
                                log.debug("start write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                            }
                            LnPacketizer.this.ostream.write(msg);
                            LnPacketizer.this.ostream.flush();
                            if (log.isTraceEnabled()) {
                                log.trace("end write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                            }
                            LnPacketizer.this.messageTransmitted(msg);
                            continue;
                        }
                        log.warn("sendLocoNetMessage: no connection established");
                    }
                    catch (IOException e) {
                        log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    log.trace("start wait");
                    new WaitHandler(this);
                    log.trace("end wait");
                }
            }
        }
    }
}

