/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrix.loconet.LnProgrammerManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locoio.LocoIO;
import jmri.jmrix.loconet.uhlenbrock.LncvMessageContents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnOpsModeProgrammer
extends PropertyChangeSupport
implements AddressedProgrammer,
LocoNetListener {
    LocoNetSystemConnectionMemo memo;
    int mAddress;
    boolean mLongAddr;
    ProgListener p;
    boolean doingWrite;
    boolean boardOpSwWriteVal;
    private int artNum;
    private Timer bdOpSwAccessTimer = null;
    private Timer sv2AccessTimer = null;
    private Timer lncvAccessTimer = null;
    protected ProgrammingMode mode = ProgrammingMode.OPSBYTEMODE;
    private static final Logger log = LoggerFactory.getLogger(LnOpsModeProgrammer.class);

    public LnOpsModeProgrammer(LocoNetSystemConnectionMemo memo, int pAddress, boolean pLongAddr) {
        this.memo = memo;
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
        memo.getLnTrafficController().addLocoNetListener(-1, this);
    }

    @Override
    public void writeCV(String CV, int val, ProgListener pL) throws ProgrammerException {
        this.p = null;
        if (this.getMode().equals(LnProgrammerManager.LOCONETCSOPSWMODE)) {
            this.memo.getSlotManager().setMode(LnProgrammerManager.LOCONETCSOPSWMODE);
            this.memo.getSlotManager().writeCV(CV, val, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            if (this.bdOpSwAccessTimer == null) {
                this.initializeBdOpsAccessTimer();
            }
            this.p = pL;
            this.doingWrite = true;
            log.debug("write CV \"{}\" to {} addr:{}", new Object[]{CV, val, this.mAddress});
            String[] parts = CV.split("\\.");
            int typeWord = Integer.parseInt(parts[0]);
            int state = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            LocoNetMessage m = new LocoNetMessage(6);
            m.setOpCode(208);
            int element = 114;
            if ((this.mAddress & 0x80) != 0) {
                element |= 1;
            }
            m.setElement(1, element);
            m.setElement(2, this.mAddress - 1 & 0x7F);
            m.setElement(3, typeWord);
            int loc = (state - 1) / 8;
            int bit = state - 1 - loc * 8;
            m.setElement(4, loc * 16 + bit * 2 + (val & 1));
            this.boardOpSwWriteVal = (val & 1) == 1;
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.bdOpSwAccessTimer.start();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV1MODE)) {
            this.p = pL;
            this.doingWrite = true;
            log.debug("write CV \"{}\" to {} addr:{}", new Object[]{CV, val, this.mAddress});
            int locoIOAddress = this.mAddress;
            int locoIOSubAddress = (this.mAddress + 256) / 256 & 0x7F;
            LocoNetMessage m = LocoIO.writeCV(locoIOAddress, locoIOSubAddress, this.decodeCvNum(CV), val);
            m.setElement(4, 1);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            if (this.sv2AccessTimer == null) {
                this.initializeSV2AccessTimer();
            }
            this.p = pL;
            log.debug("write CV \"{}\" to {} addr:{}", new Object[]{CV, val, this.mAddress});
            LocoNetMessage m = new LocoNetMessage(16);
            this.loadSV2MessageFormat(m, this.mAddress, this.decodeCvNum(CV), val);
            m.setElement(3, 1);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.sv2AccessTimer.start();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            String[] parts;
            if (this.lncvAccessTimer == null) {
                this.initializeLncvAccessTimer();
            }
            if ((parts = CV.split("\\.")).length > 1) {
                this.artNum = Integer.parseInt(parts[0]);
            }
            int cvNum = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            this.p = pL;
            this.doingWrite = true;
            log.debug("write CV \"{}\" to {} addr:{} (art. {})", new Object[]{cvNum, val, this.mAddress, this.artNum});
            LocoNetMessage m = LncvMessageContents.createCvWriteRequest(this.artNum, cvNum, val);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.lncvAccessTimer.start();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETOPSBOARD)) {
            this.memo.getSlotManager().setAcceptAnyLACK();
            this.memo.getSlotManager().writeCVOpsMode(CV, val, pL, this.mAddress, this.mLongAddr);
        } else {
            this.memo.getSlotManager().writeCVOpsMode(CV, val, pL, this.mAddress, this.mLongAddr);
        }
    }

    @Override
    public void readCV(String CV, ProgListener pL) throws ProgrammerException {
        this.p = null;
        if (this.getMode().equals(LnProgrammerManager.LOCONETCSOPSWMODE)) {
            this.memo.getSlotManager().setMode(LnProgrammerManager.LOCONETCSOPSWMODE);
            this.memo.getSlotManager().readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            if (this.bdOpSwAccessTimer == null) {
                this.initializeBdOpsAccessTimer();
            }
            this.p = pL;
            this.doingWrite = false;
            log.debug("read CV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            String[] parts = CV.split("\\.");
            int typeWord = Integer.parseInt(parts[0]);
            int state = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            LocoNetMessage m = new LocoNetMessage(6);
            m.setOpCode(208);
            int element = 98;
            if ((this.mAddress & 0x80) != 0) {
                element |= 1;
            }
            m.setElement(1, element);
            m.setElement(2, this.mAddress - 1 & 0x7F);
            m.setElement(3, typeWord);
            int loc = (state - 1) / 8;
            int bit = state - 1 - loc * 8;
            m.setElement(4, loc * 16 + bit * 2);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.bdOpSwAccessTimer.start();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV1MODE)) {
            this.p = pL;
            this.doingWrite = false;
            log.debug("read CV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            int locoIOAddress = this.mAddress & 0xFF;
            int locoIOSubAddress = (this.mAddress + 256) / 256 & 0x7F;
            LocoNetMessage m = LocoIO.readCV(locoIOAddress, locoIOSubAddress, this.decodeCvNum(CV));
            m.setElement(4, 1);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            if (this.sv2AccessTimer == null) {
                this.initializeSV2AccessTimer();
            }
            this.p = pL;
            log.debug("read CV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            LocoNetMessage m = new LocoNetMessage(16);
            this.loadSV2MessageFormat(m, this.mAddress, this.decodeCvNum(CV), 0);
            m.setElement(3, 2);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.sv2AccessTimer.start();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            String[] parts;
            if (this.lncvAccessTimer == null) {
                this.initializeLncvAccessTimer();
            }
            if ((parts = CV.split("\\.")).length > 1) {
                this.artNum = Integer.parseInt(parts[0]);
            }
            int cvNum = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            this.doingWrite = false;
            this.p = pL;
            log.debug("read LNCV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            LocoNetMessage m = LncvMessageContents.createCvReadRequest(this.artNum, this.mAddress, cvNum);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.lncvAccessTimer.start();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETOPSBOARD)) {
            this.memo.getSlotManager().setAcceptAnyLACK();
            this.memo.getSlotManager().readCVOpsMode(CV, pL, this.mAddress, this.mLongAddr);
        } else {
            this.memo.getSlotManager().readCVOpsMode(CV, pL, this.mAddress, this.mLongAddr);
        }
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener pL) throws ProgrammerException {
        this.p = null;
        if (this.getMode().equals(LnProgrammerManager.LOCONETCSOPSWMODE)) {
            this.memo.getSlotManager().setMode(LnProgrammerManager.LOCONETCSOPSWMODE);
            this.memo.getSlotManager().readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            this.readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            log.warn("confirm CV \"{}\" addr:{} in SV2 mode not implemented", (Object)CV, (Object)this.mAddress);
            this.notifyProgListenerEnd(pL, 0, 1);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            log.warn("confirm CV \"{}\" addr:{} in LNCV mode not (yet) implemented", (Object)CV, (Object)this.mAddress);
            this.readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETOPSBOARD)) {
            this.memo.getSlotManager().setAcceptAnyLACK();
            this.memo.getSlotManager().confirmCVOpsMode(CV, val, pL, this.mAddress, this.mLongAddr);
        } else {
            this.memo.getSlotManager().confirmCVOpsMode(CV, val, pL, this.mAddress, this.mLongAddr);
        }
    }

    @Override
    public void message(LocoNetMessage m) {
        log.debug("LocoNet message received: {}", (Object)m);
        if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            if (this.p == null) {
                log.warn("received board-program reply message with no reply object: {}", (Object)m);
                return;
            }
            if (m.getOpCode() != 180 || m.getElement(1) != 0 && m.getElement(1) != 80) {
                return;
            }
            this.bdOpSwAccessTimer.stop();
            if (this.doingWrite) {
                int code = 0;
                int val = this.boardOpSwWriteVal ? 1 : 0;
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, val, code);
                return;
            }
            int val = 0;
            if ((m.getElement(2) & 0x20) != 0) {
                val = 1;
            }
            int code = 0;
            if (m.getElement(2) == 127) {
                code = 1;
            }
            ProgListener temp = this.p;
            this.p = null;
            this.notifyProgListenerEnd(temp, val, code);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV1MODE)) {
            if (m.getOpCode() != 229 || m.getElement(1) != 16 || m.getElement(4) != 1 || (m.getElement(5) & 0x70) != 0) {
                return;
            }
            if ((m.getElement(3) & 0x7F) != 80) {
                return;
            }
            if (this.p == null) {
                log.warn("received SV reply message with no reply object: {}", (Object)m);
            } else {
                log.debug("returning SV programming reply: {}", (Object)m);
                int code = 0;
                int val = this.doingWrite ? m.getPeerXfrData()[7] : m.getPeerXfrData()[5];
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, val, code);
            }
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            if ((m.getOpCode() & 0xFF) != 229 || (m.getElement(1) & 0xFF) != 16 || m.getElement(3) != 65 && m.getElement(3) != 66 || (m.getElement(4) & 0xFF) != 2 || (m.getElement(5) & 0x70) != 16 || (m.getElement(10) & 0x70) != 16) {
                return;
            }
            if (this.p == null) {
                log.error("received SV reply message with no reply object: {}", (Object)m);
            } else {
                log.debug("returning SV programming reply: {}", (Object)m);
                this.sv2AccessTimer.stop();
                int code = 0;
                int val = m.getElement(11) & 0x7F | ((m.getElement(10) & 1) != 0 ? 128 : 0);
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, val, code);
            }
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            int code;
            if (m.getOpCode() == 180 && m.getElement(1) == 109 && this.doingWrite) {
                switch (m.getElement(2)) {
                    case 127: {
                        code = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        code = 8;
                        break;
                    }
                    default: {
                        code = 1;
                    }
                }
                if (this.lncvAccessTimer != null) {
                    this.lncvAccessTimer.stop();
                }
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, code);
            }
            if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ_REPLY) {
                LncvMessageContents contents = new LncvMessageContents(m);
                int artReturned = contents.getLncvArticleNum();
                int valReturned = contents.getCvValue();
                code = 0;
                if (artReturned != this.artNum) {
                    log.warn("LNCV read reply received for article {}, expected article {}", (Object)artReturned, (Object)this.artNum);
                }
                if (this.lncvAccessTimer != null) {
                    this.lncvAccessTimer.stop();
                }
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, valReturned, code);
            }
        }
    }

    int decodeCvNum(String CV) {
        try {
            return Integer.parseInt(CV);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void loadSV2MessageFormat(LocoNetMessage m, int mAddress, int cvAddr, int data) {
        m.setElement(0, 229);
        m.setElement(1, 16);
        m.setElement(2, 1);
        m.setElement(4, 2);
        m.setElement(6, mAddress & 0xFF);
        m.setElement(7, mAddress >> 8 & 0xFF);
        m.setElement(8, cvAddr & 0xFF);
        m.setElement(9, cvAddr / 256 & 0xFF);
        int svx1 = 0x10 | ((m.getElement(6) & 0x80) != 0 ? 1 : 0) | ((m.getElement(7) & 0x80) != 0 ? 2 : 0) | ((m.getElement(8) & 0x80) != 0 ? 4 : 0) | ((m.getElement(9) & 0x80) != 0 ? 8 : 0);
        m.setElement(5, svx1);
        m.setElement(6, m.getElement(6) & 0x7F);
        m.setElement(7, m.getElement(7) & 0x7F);
        m.setElement(8, m.getElement(8) & 0x7F);
        m.setElement(9, m.getElement(9) & 0x7F);
        m.setElement(11, data & 0xFF);
        m.setElement(12, data >> 8 & 0xFF);
        m.setElement(13, data >> 16 & 0xFF);
        m.setElement(14, data >> 24 & 0xFF);
        int svx2 = 0x10 | ((m.getElement(11) & 0x80) != 0 ? 1 : 0) | ((m.getElement(12) & 0x80) != 0 ? 2 : 0) | ((m.getElement(13) & 0x80) != 0 ? 4 : 0) | ((m.getElement(14) & 0x80) != 0 ? 8 : 0);
        m.setElement(10, svx2);
        m.setElement(11, m.getElement(11) & 0x7F);
        m.setElement(12, m.getElement(12) & 0x7F);
        m.setElement(13, m.getElement(13) & 0x7F);
        m.setElement(14, m.getElement(14) & 0x7F);
    }

    @Override
    public final void setMode(ProgrammingMode m) {
        if (!this.getSupportedModes().contains(m)) {
            throw new IllegalArgumentException("Invalid requested mode: " + m);
        }
        this.mode = m;
        this.firePropertyChange("Mode", this.mode, m);
    }

    @Override
    public final ProgrammingMode getMode() {
        return this.mode;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>(4);
        ret.add(ProgrammingMode.OPSBYTEMODE);
        ret.add(LnProgrammerManager.LOCONETOPSBOARD);
        ret.add(LnProgrammerManager.LOCONETSV1MODE);
        ret.add(LnProgrammerManager.LOCONETSV2MODE);
        ret.add(LnProgrammerManager.LOCONETLNCVMODE);
        ret.add(LnProgrammerManager.LOCONETBDOPSWMODE);
        ret.add(LnProgrammerManager.LOCONETCSOPSWMODE);
        return ret;
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        if (this.getMode().equals(ProgrammingMode.OPSBYTEMODE)) {
            return Programmer.WriteConfirmMode.NotVerified;
        }
        return Programmer.WriteConfirmMode.DecoderReply;
    }

    @Override
    public boolean getCanRead() {
        if (this.getMode().equals(ProgrammingMode.OPSBYTEMODE)) {
            return this.memo.getSlotManager().getTranspondingAvailable();
        }
        return true;
    }

    @Override
    public boolean getCanRead(String addr) {
        return this.getCanRead();
    }

    @Override
    public boolean getCanWrite() {
        return true;
    }

    @Override
    public boolean getCanWrite(String addr) {
        return this.getCanWrite() && Integer.parseInt(addr) <= 1024;
    }

    @Override
    @Nonnull
    public String decodeErrorCode(int i) {
        return this.memo.getSlotManager().decodeErrorCode(i);
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    void initializeBdOpsAccessTimer() {
        if (this.bdOpSwAccessTimer == null) {
            this.bdOpSwAccessTimer = new Timer(1000, e -> {
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, 128);
            });
            this.bdOpSwAccessTimer.setInitialDelay(1000);
            this.bdOpSwAccessTimer.setRepeats(false);
        }
    }

    void initializeSV2AccessTimer() {
        if (this.sv2AccessTimer == null) {
            this.sv2AccessTimer = new Timer(1000, e -> {
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, 128);
            });
            this.sv2AccessTimer.setInitialDelay(1000);
            this.sv2AccessTimer.setRepeats(false);
        }
    }

    void initializeLncvAccessTimer() {
        if (this.lncvAccessTimer == null) {
            this.lncvAccessTimer = new Timer(1000, e -> {
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, 128);
            });
            this.lncvAccessTimer.setInitialDelay(1000);
            this.lncvAccessTimer.setRepeats(false);
        }
    }
}

