/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.jmrix.AbstractNetworkPortController;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LnNetworkPortController
extends AbstractNetworkPortController {
    protected LnCommandStationType commandStationType = null;
    protected boolean mTurnoutNoRetry = false;
    protected boolean mTurnoutExtraSpace = false;
    protected boolean mTranspondingAvailable = false;
    protected LnCommandStationType[] commandStationTypes = new LnCommandStationType[]{LnCommandStationType.COMMAND_STATION_DCS100, LnCommandStationType.COMMAND_STATION_DCS240, LnCommandStationType.COMMAND_STATION_DCS210, LnCommandStationType.COMMAND_STATION_DCS200, LnCommandStationType.COMMAND_STATION_DCS050, LnCommandStationType.COMMAND_STATION_DCS051, LnCommandStationType.COMMAND_STATION_DCS052, LnCommandStationType.COMMAND_STATION_DB150, LnCommandStationType.COMMAND_STATION_IBX_TYPE_1, LnCommandStationType.COMMAND_STATION_IBX_TYPE_2, LnCommandStationType.COMMAND_STATION_LBPS, LnCommandStationType.COMMAND_STATION_MM};
    protected String[] commandStationNames = new String[this.commandStationTypes.length];
    private static final Logger log = LoggerFactory.getLogger(LnNetworkPortController.class);

    protected LnNetworkPortController(LocoNetSystemConnectionMemo connectionMemo) {
        super(connectionMemo);
        int i = 0;
        LnCommandStationType[] lnCommandStationTypeArray = this.commandStationTypes;
        int n = this.commandStationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            LnCommandStationType type = lnCommandStationTypeArray[n2];
            this.commandStationNames[i++] = type.getName();
            ++n2;
        }
        this.setManufacturer("Digitrax");
    }

    public void setCommandStationType(String name) {
        try {
            this.setCommandStationType(LnCommandStationType.getByName(name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Invalid command station name: \"{}\", defaulting to {}", (Object)name, (Object)this.commandStationTypes[0]);
            this.setCommandStationType(this.commandStationTypes[0]);
        }
    }

    public void setCommandStationType(LnCommandStationType value) {
        if (value == null) {
            return;
        }
        log.debug("setCommandStationType: {}", (Object)value);
        this.commandStationType = value;
    }

    @Override
    public LocoNetSystemConnectionMemo getSystemConnectionMemo() {
        return (LocoNetSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    public void setTurnoutHandling(String value) {
        if (value.equals("One Only") || value.equals(Bundle.getMessage("HandleOneOnly")) || value.equals("Both") || value.equals(Bundle.getMessage("HandleBoth"))) {
            this.mTurnoutNoRetry = true;
        }
        log.debug("turnout no retry: {}", (Object)this.mTurnoutNoRetry);
        if (value.equals("Spread") || value.equals(Bundle.getMessage("HandleSpread")) || value.equals("Both") || value.equals(Bundle.getMessage("HandleBoth"))) {
            this.mTurnoutExtraSpace = true;
        }
        log.debug("turnout extra space: {}", (Object)this.mTurnoutExtraSpace);
    }

    public void setTranspondingAvailable(String value) {
        this.mTranspondingAvailable = value.equals("Yes") || value.equals(Bundle.getMessage("ButtonYes"));
        log.debug("transponding available: {}", (Object)this.mTranspondingAvailable);
    }

    @Override
    public void configureOption3(String value) {
        super.configureOption3(value);
        log.debug("configureOption3: {}", (Object)value);
        this.setTurnoutHandling(value);
    }
}

