/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.TimerTask;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnMeterInitTask {
    boolean _enabled = false;
    private UpdateTask _intervalTask = null;
    private final int _sleepInterval;
    private final LnTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(LnMeterInitTask.class);

    public LnMeterInitTask(LnTrafficController tc, int interval) {
        this.tc = tc;
        this._sleepInterval = interval;
    }

    protected void enable() {
        if (!this._enabled) {
            this._enabled = true;
            if (this._intervalTask != null) {
                this._intervalTask.enable(true);
            }
        }
    }

    protected void disable() {
        if (this._intervalTask != null) {
            this._intervalTask.enable(false);
        }
    }

    public void initTimer() {
        if (this._intervalTask != null) {
            this._intervalTask.cancel();
            this._intervalTask = null;
        }
        if (this._sleepInterval < 0) {
            return;
        }
        this._intervalTask = new UpdateTask();
        log.debug("Starting Initialization Timer");
        TimerUtil.scheduleAtFixedRate((TimerTask)this._intervalTask, this._sleepInterval, (long)this._sleepInterval);
    }

    public void dispose() {
        if (this._intervalTask != null && this._intervalTask.isEnabled()) {
            this._intervalTask.enable(false);
        }
        if (this._intervalTask != null) {
            this._intervalTask = null;
        }
    }

    private class UpdateTask
    extends TimerTask {
        private boolean _updateTaskIsEnabled = false;

        public void enable(boolean val) {
            if (!val) {
                this.cancel();
            }
            this._updateTaskIsEnabled = val;
        }

        public boolean isEnabled() {
            return this._updateTaskIsEnabled;
        }

        @Override
        public void run() {
            if (!this._updateTaskIsEnabled) {
                log.debug("LnMeter initialization timer finds task not enabled.");
                return;
            }
            if (!LnMeterInitTask.this.tc.status()) {
                log.debug("LnMeter initialization timer finds connection not ready.");
                return;
            }
            log.debug("LnMeter initialization timer is sending query.");
            int[] nArray = new int[4];
            nArray[0] = 187;
            nArray[1] = 121;
            nArray[2] = 1;
            LnMeterInitTask.this.tc.sendLocoNetMessage(new LocoNetMessage(nArray));
            LnMeterInitTask.this.disable();
        }
    }
}

