/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnLight;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.managers.AbstractLightManager;

public class LnLightManager
extends AbstractLightManager {
    public LnLightManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public LocoNetSystemConnectionMemo getMemo() {
        return (LocoNetSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = this.getBitFromSystemName(systemName);
        if (bitNum == 0) {
            throw new IllegalArgumentException("Invalid Bit from System Name: " + systemName);
        }
        String sName = String.valueOf(this.getSystemPrefix()) + "L" + bitNum;
        LnLight lgt = new LnLight(sName, userName, this.getMemo().getLnTrafficController(), this);
        return lgt;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, 4096, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return true;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

