/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.concurrent.Immutable;
import jmri.ThrottleManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public enum LnCommandStationType {
    COMMAND_STATION_DCS100("DCS100 (Chief)", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.SUPPORTS_OPC_IDLE, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_DCS240("DCS240 (Advanced Command Station)", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.SUPPORTS_OPC_IDLE, MultiMeterSupport.SUPPORTS_MULTIMETER_FUNCTION, LocoResetSupport.SUPPORTS_LOCO_RESET_FUNCTION),
    COMMAND_STATION_DCS210("DCS210 (Evolution Command Station)", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.SUPPORTS_OPC_IDLE, MultiMeterSupport.SUPPORTS_MULTIMETER_FUNCTION, LocoResetSupport.SUPPORTS_LOCO_RESET_FUNCTION),
    COMMAND_STATION_DCS200("DCS200", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.SUPPORTS_OPC_IDLE, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_DCS050("DCS50 (Zephyr)", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_DCS051("DCS51 (Zephyr Xtra)", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_DCS052("DCS52 (Zephyr Express)", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.SUPPORTS_MULTIMETER_FUNCTION, LocoResetSupport.SUPPORTS_LOCO_RESET_FUNCTION),
    COMMAND_STATION_DB150("DB150 (Empire Builder)", ReadsFromServiceModeTrack.NO_SVC_MODE_READS, ProgDepowersTrack.TRACK_TURNEDOFF_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.SUPPORTS_OPC_IDLE, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_LBPS("LocoBuffer (PS)", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_MM("Mix-Master", ReadsFromServiceModeTrack.NO_SVC_MODE_READS, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_IBX_TYPE_1("Intellibox-I", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "Ib1ThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_IBX_TYPE_2("Intellibox-II", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "Ib2ThrottleManager", "UhlenbrockSlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_PR3_ALONE("PR3 standalone programmer", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_PR2_ALONE("PR2 standalone programmer", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_STANDALONE("Stand-alone LocoNet", ReadsFromServiceModeTrack.NO_SVC_MODE_READS, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_PR4_ALONE("PR4 standalone programmer", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.NO_MULTIMETER_SUPPORT, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_USB_DCS240_ALONE("DCS240 USB interface as standalone programmer", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.SUPPORTS_MULTIMETER_FUNCTION, LocoResetSupport.NO_LOCO_RESET_SUPPORT),
    COMMAND_STATION_USB_DCS52_ALONE("DCS52 USB interface as standalone programmer", ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK, ProgDepowersTrack.TRACK_UNCHANGED_BY_PROGRAMMING, "LnThrottleManager", "SlotManager", IdleSupport.NO_OPC_IDLE_SUPPORT, MultiMeterSupport.SUPPORTS_MULTIMETER_FUNCTION, LocoResetSupport.NO_LOCO_RESET_SUPPORT);

    final String name;
    final ReadsFromServiceModeTrack canRead;
    final ProgDepowersTrack progEndOp;
    final String throttleClassName;
    final String slotManagerClassName;
    final IdleSupport supportsIdle;
    final MultiMeterSupport supportsMultiMeter;
    final LocoResetSupport supportsLocoReset;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(LnCommandStationType.class);
    }

    private LnCommandStationType(String name, ReadsFromServiceModeTrack canRead, ProgDepowersTrack progEndOp, String throttleClassName, String slotManagerClassName, IdleSupport supportsIdle, MultiMeterSupport supportMultiMeter, LocoResetSupport supportsLocoReset) {
        this.name = name;
        this.canRead = canRead;
        this.progEndOp = progEndOp;
        this.throttleClassName = throttleClassName;
        this.slotManagerClassName = slotManagerClassName;
        this.supportsIdle = supportsIdle;
        this.supportsMultiMeter = supportMultiMeter;
        this.supportsLocoReset = supportsLocoReset;
    }

    public String getName() {
        return this.name;
    }

    public boolean getCanRead() {
        return this.canRead == ReadsFromServiceModeTrack.CAN_READ_ON_SVC_TRACK;
    }

    public String toString() {
        return this.name;
    }

    public boolean getProgPowersOff() {
        return this.progEndOp == ProgDepowersTrack.TRACK_TURNEDOFF_BY_PROGRAMMING;
    }

    public static LnCommandStationType getByName(String name) {
        LnCommandStationType[] lnCommandStationTypeArray = LnCommandStationType.values();
        int n = lnCommandStationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LnCommandStationType p = lnCommandStationTypeArray[n2];
            if (p.name.equals(name)) {
                return p;
            }
            ++n2;
        }
        throw new IllegalArgumentException("argument value [" + name + "] not valid");
    }

    public ThrottleManager getThrottleManager(LocoNetSystemConnectionMemo memo) {
        try {
            Constructor<?>[] allConstructors;
            String className = "jmri.jmrix.loconet." + this.throttleClassName;
            log.debug("attempting to create {}", (Object)className);
            Class<?> c = Class.forName(className);
            Constructor<?>[] constructorArray = allConstructors = c.getDeclaredConstructors();
            int n = allConstructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> ctor = constructorArray[n2];
                Class<?>[] pType = ctor.getParameterTypes();
                if (pType.length == 1 && pType[0].equals(LocoNetSystemConnectionMemo.class)) {
                    return (ThrottleManager)ctor.newInstance(memo);
                }
                ++n2;
            }
            log.error("Did not find a throttle ctor for {}", (Object)this.name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("Could not find class for throttle manager from type {} in enum element {}", (Object)this.throttleClassName, (Object)this.name);
        }
        catch (InstantiationException e2) {
            log.error("Could not create throttle manager object from type {} in enum element {}", new Object[]{this.throttleClassName, this.name, e2});
        }
        catch (IllegalAccessException e3) {
            log.error("Access error creating throttle manager object from type {} in enum element {}", new Object[]{this.throttleClassName, this.name, e3});
        }
        catch (InvocationTargetException e4) {
            log.error("Invocation error while creating throttle manager object from type {} in enum element {}", new Object[]{this.throttleClassName, this.name, e4});
        }
        return null;
    }

    public SlotManager getSlotManager(LnTrafficController tc) {
        try {
            Constructor<?>[] allConstructors;
            String className = "jmri.jmrix.loconet." + this.slotManagerClassName;
            log.debug("attempting to create {}", (Object)className);
            Class<?> c = Class.forName(className);
            Constructor<?>[] constructorArray = allConstructors = c.getDeclaredConstructors();
            int n = allConstructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> ctor = constructorArray[n2];
                Class<?>[] pType = ctor.getParameterTypes();
                if (pType.length == 1 && pType[0].equals(LnTrafficController.class)) {
                    return (SlotManager)ctor.newInstance(tc);
                }
                ++n2;
            }
            log.error("Did not find a slotmanager ctor for {}", (Object)this.name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("Could not find class for slotmanager from type {} in enum element {}", (Object)this.slotManagerClassName, (Object)this.name);
        }
        catch (InstantiationException e2) {
            log.error("Could not create slotmanager object from type {} in enum element {}", new Object[]{this.slotManagerClassName, this.name, e2});
        }
        catch (IllegalAccessException e3) {
            log.error("Access error creating slotmanager object from type {} in enum element {}", new Object[]{this.slotManagerClassName, this.name, e3});
        }
        catch (InvocationTargetException e4) {
            log.error("Invocation error while creating slotmanager object from type {} in enum element {}", new Object[]{this.slotManagerClassName, this.name, e4});
        }
        return null;
    }

    public boolean getImplementsIdle() {
        return this.supportsIdle == IdleSupport.SUPPORTS_OPC_IDLE;
    }

    public boolean getSupportsMultimeter() {
        return this.supportsMultiMeter == MultiMeterSupport.SUPPORTS_MULTIMETER_FUNCTION;
    }

    public boolean getSupportsLocoReset() {
        return this.supportsLocoReset == LocoResetSupport.SUPPORTS_LOCO_RESET_FUNCTION;
    }

    protected static enum IdleSupport {
        NO_OPC_IDLE_SUPPORT,
        SUPPORTS_OPC_IDLE;

    }

    protected static enum LocoResetSupport {
        NO_LOCO_RESET_SUPPORT,
        SUPPORTS_LOCO_RESET_FUNCTION;

    }

    protected static enum MultiMeterSupport {
        NO_MULTIMETER_SUPPORT,
        SUPPORTS_MULTIMETER_FUNCTION;

    }

    protected static enum ProgDepowersTrack {
        TRACK_TURNEDOFF_BY_PROGRAMMING,
        TRACK_UNCHANGED_BY_PROGRAMMING;

    }

    protected static enum ReadsFromServiceModeTrack {
        NO_SVC_MODE_READS,
        CAN_READ_ON_SVC_TRACK;

    }
}

