/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.LocoAddress;
import jmri.SignalMast;
import jmri.implementation.DefaultCabSignal;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnCabSignal
extends DefaultCabSignal {
    private LocoNetSystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(LnCabSignal.class);

    public LnCabSignal(LocoNetSystemConnectionMemo memo, LocoAddress address) {
        super(address);
        this._memo = memo;
        log.debug("created cab signal for {}", (Object)address);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._memo = null;
    }

    @Override
    protected void forwardAspectToLayout() {
        int signalD3;
        int locoD2;
        int locoD1;
        block27: {
            String speed;
            LocoAddress locoaddr = this.getCabSignalAddress();
            SignalMast mast = this.getNextMast();
            locoD1 = locoaddr.getNumber() / 128;
            locoD2 = locoaddr.getNumber() % 128;
            signalD3 = 0;
            if (mast == null) break block27;
            switch (speed = (String)mast.getSignalSystem().getProperty(mast.getAspect(), "speed")) {
                case "Normal": 
                case "Clear": {
                    signalD3 = 24;
                    break;
                }
                case "Limited": {
                    signalD3 = 25;
                    break;
                }
                case "Medium": {
                    signalD3 = 20;
                    break;
                }
                case "Stop": {
                    signalD3 = 18;
                    break;
                }
                case "RestrictedSlow": 
                case "Slow": 
                case "Restricting": 
                case "Restricted": {
                    signalD3 = 19;
                    break;
                }
                default: {
                    signalD3 = mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(1)) ? 24 : (mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(2)) ? 18 : (mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(0)) ? 18 : (mast.getAspect().equals(mast.getAppearanceMap().getSpecificAppearance(3)) ? 0 : 20)));
                }
            }
        }
        LocoNetMessage peerXFerMessage = new LocoNetMessage(16);
        peerXFerMessage.setOpCode(229);
        peerXFerMessage.setElement(1, 16);
        peerXFerMessage.setElement(2, 127);
        peerXFerMessage.setElement(3, 0);
        peerXFerMessage.setElement(4, 0);
        peerXFerMessage.setElement(5, 0);
        peerXFerMessage.setElement(6, locoD1);
        peerXFerMessage.setElement(7, locoD2);
        peerXFerMessage.setElement(8, signalD3);
        peerXFerMessage.setElement(9, 0);
        peerXFerMessage.setElement(10, 112);
        peerXFerMessage.setElement(11, 0);
        peerXFerMessage.setElement(12, 0);
        peerXFerMessage.setElement(13, 0);
        peerXFerMessage.setElement(14, 0);
        peerXFerMessage.setElement(15, 0);
        this._memo.getLnTrafficController().sendLocoNetMessage(peerXFerMessage);
    }

    @Override
    protected void resetLayoutCabSignal() {
        LocoAddress locoaddr = this.getCabSignalAddress();
        int locoD1 = locoaddr.getNumber() / 128;
        int locoD2 = locoaddr.getNumber() % 128;
        int signalD3 = 0;
        LocoNetMessage peerXFerMessage = new LocoNetMessage(16);
        peerXFerMessage.setOpCode(229);
        peerXFerMessage.setElement(1, 16);
        peerXFerMessage.setElement(2, 127);
        peerXFerMessage.setElement(3, 0);
        peerXFerMessage.setElement(4, 0);
        peerXFerMessage.setElement(5, 0);
        peerXFerMessage.setElement(6, locoD1);
        peerXFerMessage.setElement(7, locoD2);
        peerXFerMessage.setElement(8, signalD3);
        peerXFerMessage.setElement(9, 0);
        peerXFerMessage.setElement(10, 112);
        peerXFerMessage.setElement(11, 0);
        peerXFerMessage.setElement(12, 0);
        peerXFerMessage.setElement(13, 0);
        peerXFerMessage.setElement(14, 0);
        peerXFerMessage.setElement(15, 0);
        this._memo.getLnTrafficController().sendLocoNetMessage(peerXFerMessage);
    }
}

