/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.implementation.DccSignalMast;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.SlotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LNCPSignalMast
extends DccSignalMast
implements LocoNetListener {
    LnTrafficController tc;
    byte dccByteAddr1;
    byte dccByteAddr2;
    private static final Logger log = LoggerFactory.getLogger(LNCPSignalMast.class);

    public LNCPSignalMast(String sys, String user) {
        super(sys, user, "F$lncpsm");
        this.packetSendCount = 1;
        this.configureFromName(sys);
        this.init();
    }

    public LNCPSignalMast(String sys) {
        super(sys, null, "F$lncpsm");
        this.packetSendCount = 1;
        this.configureFromName(sys);
        this.init();
    }

    void init() {
        this.tc = this.c instanceof SlotManager && ((SlotManager)this.c).getSystemConnectionMemo() != null ? ((SlotManager)this.c).getSystemConnectionMemo().getLnTrafficController() : InstanceManager.getDefault(LnTrafficController.class);
        int lowAddr = this.dccSignalDecoderAddress - 1 & 3;
        int boardAddr = this.dccSignalDecoderAddress - 1 >> 2;
        int midAddr = boardAddr & 0x3F;
        int highAddr = ~boardAddr >> 6 & 7;
        this.dccByteAddr1 = (byte)(0x80 | midAddr);
        this.dccByteAddr2 = (byte)(1 | highAddr << 4 | lowAddr << 1);
        this.tc.addLocoNetListener(-1, this);
    }

    @Override
    public void message(LocoNetMessage l) {
        if (l.getOpCode() != 237) {
            return;
        }
        int val7f = l.getElement(2);
        if (val7f != 127) {
            return;
        }
        int reps = l.getElement(3);
        int len = (reps & 0x70) >> 4;
        if (len != 3) {
            return;
        }
        int dhi = l.getElement(4);
        int im1 = l.getElement(5);
        int im2 = l.getElement(6);
        int im3 = l.getElement(7);
        byte[] packet = new byte[len];
        packet[0] = (byte)(im1 + ((dhi & 1) != 0 ? 128 : 0));
        packet[1] = (byte)(im2 + ((dhi & 2) != 0 ? 128 : 0));
        if (this.myAddress(packet[0], packet[1])) {
            packet[2] = (byte)(im3 + ((dhi & 4) != 0 ? 128 : 0));
            byte aspect = packet[2];
            for (Map.Entry entry : this.appearanceToOutput.entrySet()) {
                if ((Integer)entry.getValue() != aspect) continue;
                this.setKnownState((String)entry.getKey());
                return;
            }
            log.error("Aspect for id {} on signal mast {} not found", (Object)aspect, (Object)this.getDisplayName());
        }
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        if (this.appearanceToOutput.containsKey(aspect) && (Integer)this.appearanceToOutput.get(aspect) != -1) {
            this.c.sendPacket(NmraPacket.altAccSignalDecoderPkt(this.dccSignalDecoderAddress, (Integer)this.appearanceToOutput.get(aspect)), this.packetSendCount);
        } else {
            log.warn("Trying to set aspect ({}) that has not been configured on mast {}", (Object)aspect, (Object)this.getDisplayName());
        }
    }

    public void setKnownState(String aspect) {
        String oldAspect = this.aspect;
        this.aspect = aspect;
        this.speed = (String)this.getSignalSystem().getProperty(aspect, "speed");
        this.firePropertyChange("Aspect", oldAspect, aspect);
    }

    @Override
    public void dispose() {
        this.tc.removeLocoNetListener(-1, this);
        super.dispose();
    }

    private boolean myAddress(byte a1, byte a2) {
        if (a1 != this.dccByteAddr1) {
            return false;
        }
        return a2 == this.dccByteAddr2;
    }
}

