/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.Intellibox;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.Intellibox.Bundle;
import jmri.jmrix.loconet.Intellibox.IBLnPacketizer;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.locobuffer.LocoBufferAdapter;

public class IntelliboxAdapter
extends LocoBufferAdapter {
    public IntelliboxAdapter() {
        this.options.remove(this.option2Name);
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationOptions(), false));
        this.validSpeeds = new String[]{Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud115200")};
        this.validSpeedValues = new int[]{19200, 38400, 115200};
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        IBLnPacketizer packets = new IBLnPacketizer();
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    public String option1Name() {
        return Bundle.getMessage("XconnectionUsesLabel", Bundle.getMessage("TypeSerial"));
    }

    public String[] commandStationOptions() {
        String[] retval = new String[]{LnCommandStationType.COMMAND_STATION_IBX_TYPE_1.getName()};
        return retval;
    }
}

