/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.Intellibox;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBLnPacketizer
extends LnPacketizer {
    private static final Logger log = LoggerFactory.getLogger(IBLnPacketizer.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during system initialization")
    public IBLnPacketizer() {
        super(new LocoNetSystemConnectionMemo());
        this.echo = true;
    }

    @Override
    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        Thread xmtThread = new Thread(this.xmtHandler, "LocoNet Intellibox transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        xmtThread.setDaemon(true);
        xmtThread.setPriority(9);
        xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        Thread rcvThread = new Thread(this.rcvHandler, "LocoNet Intellibox receive handler");
        rcvThread.setDaemon(true);
        rcvThread.setPriority(10);
        rcvThread.start();
    }

    static /* synthetic */ LinkedList access$1(IBLnPacketizer iBLnPacketizer) {
        return iBLnPacketizer.xmtList;
    }

    static /* synthetic */ LnPortController access$2(IBLnPacketizer iBLnPacketizer) {
        return iBLnPacketizer.controller;
    }

    static /* synthetic */ void access$3(IBLnPacketizer iBLnPacketizer, byte[] byArray) {
        iBLnPacketizer.messageTransmitted(byArray);
    }

    class RcvHandler
    implements Runnable {
        LnPacketizer trafficController;

        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="single threaded during init; will eventually be replaced for multi-connection support")
        public RcvHandler(LnPacketizer lt) {
            this.trafficController = lt;
        }

        private byte readNextByteFromUSB() {
            while (true) {
                try {
                    byte inbyte = IBLnPacketizer.this.istream.readByte();
                    return inbyte;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int opCode;
                        if (((opCode = this.readNextByteFromUSB() & 0xFF) & 0x80) == 0) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Skipping: {}", (Object)Integer.toHexString(opCode));
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        }
                        LocoNetMessage msg = null;
                        while (msg == null) {
                            try {
                                int byte2 = this.readNextByteFromUSB() & 0xFF;
                                if ((byte2 & 0x80) != 0) {
                                    log.warn("LocoNet message with opCode: {} ended early. Byte2 is also an opcode: {}", (Object)Integer.toHexString(opCode), (Object)Integer.toHexString(byte2));
                                    opCode = byte2;
                                    throw new LocoNetMessageException();
                                }
                                switch ((opCode & 0x60) >> 5) {
                                    case 0: {
                                        msg = new LocoNetMessage(2);
                                        break;
                                    }
                                    case 1: {
                                        msg = new LocoNetMessage(4);
                                        break;
                                    }
                                    case 2: {
                                        msg = new LocoNetMessage(6);
                                        break;
                                    }
                                    case 3: {
                                        if (byte2 < 2) {
                                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                        }
                                        msg = new LocoNetMessage(byte2);
                                        break;
                                    }
                                    default: {
                                        throw new LocoNetMessageException("decode failure " + byte2);
                                    }
                                }
                                msg.setOpCode(opCode);
                                msg.setElement(1, byte2);
                                int len = msg.getNumDataElements();
                                int i = 2;
                                while (i < len) {
                                    int b = this.readNextByteFromUSB() & 0xFF;
                                    if ((b & 0x80) != 0) {
                                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                        opCode = b;
                                        throw new LocoNetMessageException();
                                    }
                                    msg.setElement(i, b);
                                    ++i;
                                }
                            }
                            catch (LocoNetMessageException locoNetMessageException) {
                                msg = null;
                            }
                        }
                        if (!msg.checkParity()) {
                            log.warn("Ignore LocoNet packet with bad checksum: {}", (Object)msg.toString());
                            throw new LocoNetMessageException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("queue message for notification");
                        }
                        LocoNetMessage thisMsg = msg;
                        LnPacketizer thisTc = this.trafficController;
                        Runnable r = new Runnable(thisMsg, thisTc){
                            LocoNetMessage msgForLater;
                            LnPacketizer myTc;
                            {
                                this.msgForLater = locoNetMessage;
                                this.myTc = lnPacketizer;
                            }

                            @Override
                            public void run() {
                                this.myTc.notify(this.msgForLater);
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException: {}", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    log.warn("run: unexpected Exception: {}", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        IBLnPacketizer.access$0().debug("check for input");
                        msg = null;
                        var2_2 = this;
                        synchronized (var2_2) {
                            msg = (byte[])IBLnPacketizer.access$1(IBLnPacketizer.this).removeFirst();
                        }
                        try {
                            block12: {
                                if (IBLnPacketizer.this.ostream == null) break block12;
                                if (!IBLnPacketizer.access$2(IBLnPacketizer.this).okToSend()) {
                                    IBLnPacketizer.access$0().debug("LocoNet port not ready to receive");
                                }
                                IBLnPacketizer.access$0().debug("start write to stream");
                                i = 0;
                                ** GOTO lbl26
                                {
                                    Thread.yield();
                                    do {
                                        if (!IBLnPacketizer.access$2(IBLnPacketizer.this).okToSend()) continue block9;
                                        IBLnPacketizer.this.ostream.write(msg[i]);
                                        IBLnPacketizer.this.ostream.flush();
                                        ++i;
lbl26:
                                        // 2 sources

                                    } while (i < msg.length);
                                }
                                IBLnPacketizer.access$0().debug("end write to stream");
                                IBLnPacketizer.access$3(IBLnPacketizer.this, msg);
                                continue;
                            }
                            IBLnPacketizer.access$0().warn("sendLocoNetMessage: no connection established");
                        }
                        catch (IOException e) {
                            IBLnPacketizer.access$0().warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                        }
                    }
                }
                catch (NoSuchElementException v1) {
                    IBLnPacketizer.access$0().debug("start wait");
                    new WaitHandler(this);
                    IBLnPacketizer.access$0().debug("end wait");
                    continue;
                }
                break;
            }
        }
    }
}

