/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsOpSwAccess
implements LocoNetListener {
    private Timer csOpSwAccessTimer;
    private Timer csOpSwValidTimer;
    private CmdStnOpSwStateType cmdStnOpSwState;
    private int cmdStnOpSwNum;
    private boolean cmdStnOpSwVal;
    private LocoNetSystemConnectionMemo memo;
    private ProgListener p;
    private boolean doingWrite;
    private int[] opSwBytes;
    private boolean haveValidLowBytes;
    private boolean haveValidHighBytes;
    private static final Logger log = LoggerFactory.getLogger(CsOpSwAccess.class);

    public CsOpSwAccess(@Nonnull LocoNetSystemConnectionMemo memo, @Nonnull ProgListener p) {
        this.memo = memo;
        this.p = p;
        memo.getLnTrafficController().addLocoNetListener(-1, this);
        this.csOpSwAccessTimer = null;
        this.csOpSwValidTimer = null;
        this.cmdStnOpSwState = CmdStnOpSwStateType.IDLE;
        this.opSwBytes = new int[16];
        this.haveValidLowBytes = false;
        this.haveValidHighBytes = false;
        log.debug("csOpSwAccess constructor");
    }

    public void setProgrammerListener(@Nonnull ProgListener p) {
        this.p = p;
    }

    public void readCsOpSw(String opSw, @Nonnull ProgListener pL) throws ProgrammerException {
        log.debug("reading a cs opsw : {}", (Object)opSw);
        if (this.csOpSwAccessTimer == null) {
            log.debug("initializing timers");
            this.initializeCsOpSwAccessTimer();
            this.initializeCsOpSwValidTimer();
        }
        this.p = pL;
        this.doingWrite = false;
        log.debug("read Command Station OpSw{}", (Object)opSw);
        String[] parts = opSw.split("\\.");
        ProgListener temp = pL;
        if (parts.length == 2 && parts[0].equals("csOpSw") && Integer.parseInt(parts[1]) >= 1 && Integer.parseInt(parts[1]) <= 128) {
            log.trace("splitting CV: {} becomes {} and {}", new Object[]{opSw, parts[0], parts[1]});
            log.trace("Valid typeWord = 1; attempting to read OpSw{}.", (Object)Integer.parseInt(parts[1]));
            log.trace("starting from state {}", (Object)this.cmdStnOpSwState);
            this.readCmdStationOpSw(Integer.parseInt(parts[1]));
            return;
        }
        log.warn("Cannot perform Cs OpSw access: parts.length={}, parts[]={}", (Object)parts.length, (Object)parts);
        this.p = null;
        if (temp != null) {
            temp.programmingOpReply(0, 8);
        }
    }

    public void writeCsOpSw(String opSw, int val, @Nonnull ProgListener pL) throws ProgrammerException {
        this.p = null;
        String[] parts = opSw.split("\\.");
        if (val != 0 && val != 1 || parts.length != 2 || !parts[0].equals("csOpSw") || Integer.parseInt(parts[1]) <= 0 || Integer.parseInt(parts[1]) >= 129) {
            log.warn("Cannot perform Cs OpSw access: parts.length={}, parts[]={}, val={}", new Object[]{parts.length, parts, val});
            if (pL != null) {
                pL.programmingOpReply(0, 8);
            }
            return;
        }
        if (this.csOpSwAccessTimer == null) {
            this.initializeCsOpSwAccessTimer();
            this.initializeCsOpSwValidTimer();
        }
        this.p = pL;
        this.doingWrite = true;
        log.debug("write Command Station OpSw{} as {}", (Object)opSw, (Object)(val > 0 ? "c" : "t"));
        int opSwNum = Integer.parseInt(parts[1]);
        log.debug("CS OpSw number {}", (Object)opSwNum);
        if (!this.updateCmdStnOpSw(opSwNum, val == 1)) {
            this.sendFinalProgrammerReply(-1, 4);
        }
    }

    @Override
    public void message(LocoNetMessage m) {
        if (this.cmdStnOpSwState == CmdStnOpSwStateType.IDLE) {
            return;
        }
        if (m.getOpCode() == 231 && m.getElement(1) == 14 && (m.getElement(2) & 0x7E) == 126 && (this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY || this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY_ENHANCED)) {
            log.debug("got slot {} read data", (Object)m.getElement(2));
            this.updateStoredOpSwsFromRead(m);
            if (this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY || this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY_ENHANCED) {
                log.debug("got slot {} read data in response to OpSw query", (Object)m.getElement(2));
                if ((m.getElement(7) & 0x40) == 64 && this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY) {
                    this.csOpSwAccessTimer.restart();
                    int[] nArray = new int[4];
                    nArray[0] = 187;
                    nArray[1] = 126;
                    LocoNetMessage m2 = new LocoNetMessage(nArray);
                    this.cmdStnOpSwState = CmdStnOpSwStateType.QUERY_ENHANCED;
                    this.memo.getLnTrafficController().sendLocoNetMessage(m2);
                    this.csOpSwAccessTimer.start();
                    return;
                }
                this.csOpSwAccessTimer.stop();
                this.cmdStnOpSwState = CmdStnOpSwStateType.HAS_STATE;
                log.debug("starting valid timer");
                this.csOpSwValidTimer.start();
                if (this.doingWrite) {
                    log.debug("now can finish the write by updating the correct bit...");
                    this.finishTheWrite();
                } else if (!(this.cmdStnOpSwNum > 0 && this.cmdStnOpSwNum < 65 && this.haveValidLowBytes || this.cmdStnOpSwNum > 64 && this.cmdStnOpSwNum < 129 && this.haveValidHighBytes)) {
                    ProgListener temp = this.p;
                    this.p = null;
                    if (temp != null) {
                        log.debug("Aborting - OpSw {} beyond allowed range", (Object)this.cmdStnOpSwNum);
                        temp.programmingOpReply(0, 8);
                    } else {
                        log.warn("no programmer to which the error condition can be returned.");
                    }
                } else {
                    boolean value = this.extractCmdStnOpSw(this.cmdStnOpSwNum);
                    log.debug("now can return the extracted OpSw{} read data ({}) to the programmer", (Object)this.cmdStnOpSwNum, (Object)value);
                    this.sendFinalProgrammerReply(value ? 1 : 0, 0);
                }
            } else if (this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY_BEFORE_WRITE || this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY_ENHANCED_BEFORE_WRITE) {
                if ((m.getElement(7) & 0x40) == 64 && this.cmdStnOpSwState == CmdStnOpSwStateType.QUERY_BEFORE_WRITE) {
                    this.csOpSwAccessTimer.restart();
                    int[] nArray = new int[4];
                    nArray[0] = 187;
                    nArray[1] = 126;
                    LocoNetMessage m2 = new LocoNetMessage(nArray);
                    this.cmdStnOpSwState = CmdStnOpSwStateType.QUERY_ENHANCED_BEFORE_WRITE;
                    this.memo.getLnTrafficController().sendLocoNetMessage(m2);
                    this.csOpSwAccessTimer.start();
                    return;
                }
                log.debug("have received OpSw query before a write; now can process the data modification");
                this.csOpSwAccessTimer.stop();
                this.cmdStnOpSwState = CmdStnOpSwStateType.WRITE;
                LocoNetMessage m2 = this.updateOpSwVal(this.cmdStnOpSwNum, this.cmdStnOpSwVal);
                log.debug("performing enhanced opsw write: {}", (Object)m2.toString());
                log.debug("todo; uncomment the send?");
                this.csOpSwAccessTimer.start();
            }
        } else if (m.getOpCode() == 180 && m.getElement(1) == 111 && m.getElement(2) == 127 && this.cmdStnOpSwState == CmdStnOpSwStateType.WRITE) {
            this.csOpSwAccessTimer.stop();
            this.cmdStnOpSwState = CmdStnOpSwStateType.HAS_STATE;
            boolean value = this.extractCmdStnOpSw(this.cmdStnOpSwNum);
            this.sendFinalProgrammerReply(value ? 1 : 0, 0);
        }
    }

    public void readCmdStationOpSw(int cv) {
        log.debug("readCmdStationOpSw: state is {}, have lowvalid {}, have highvalid {}, asking for OpSw{}", new Object[]{this.cmdStnOpSwState, this.haveValidLowBytes ? "true" : "false", this.haveValidHighBytes ? "true" : "false", cv});
        if (this.cmdStnOpSwState == CmdStnOpSwStateType.HAS_STATE) {
            if (cv > 0 && cv < 65 && this.haveValidLowBytes || cv > 64 && cv < 129 && this.haveValidHighBytes) {
                log.debug("readCmdStationOpSw: returning state from previously-stored state for OpSw{}", (Object)cv);
                this.returnCmdStationOpSwVal(cv);
            } else {
                log.warn("Cannot perform Cs OpSw access of OpSw {} account out-of-range for this command station.", (Object)cv);
                this.sendFinalProgrammerReply(-1, 8);
            }
        } else if (this.cmdStnOpSwState == CmdStnOpSwStateType.IDLE || this.cmdStnOpSwState == CmdStnOpSwStateType.HAS_STATE) {
            log.debug("readCmdStationOpSw: attempting to read some CVs");
            this.updateCmdStnOpSw(cv, false);
        } else {
            log.warn("readCmdStationOpSw: aborting - cmdStnOpSwState is odd: {}", (Object)this.cmdStnOpSwState);
            this.sendFinalProgrammerReply(-1, 1);
        }
    }

    public void returnCmdStationOpSwVal(int cmdStnOpSwNum) {
        boolean returnVal = this.extractCmdStnOpSw(cmdStnOpSwNum);
        if (this.p != null) {
            log.debug("returnCmdStationOpSwVal: Returning OpSw{} value of {}", (Object)cmdStnOpSwNum, (Object)returnVal);
            this.p.programmingOpReply(returnVal ? 1 : 0, 0);
        }
    }

    public boolean updateCmdStnOpSw(int opSwNum, boolean val) {
        if (this.cmdStnOpSwState == CmdStnOpSwStateType.HAS_STATE) {
            if (!this.doingWrite) {
                log.debug("updateCmdStnOpSw: should already have OpSw values from previous read.");
                return false;
            }
            this.cmdStnOpSwVal = val;
            this.cmdStnOpSwNum = opSwNum;
            this.finishTheWrite();
            return true;
        }
        if (this.cmdStnOpSwState != CmdStnOpSwStateType.IDLE) {
            log.debug("updateCmdStnOpSw: cannot query OpSw values from state {}", (Object)this.cmdStnOpSwState);
            return false;
        }
        log.debug("updateCmdStnOpSw: attempting to query the OpSws when state = {}", (Object)this.cmdStnOpSwState);
        this.cmdStnOpSwState = CmdStnOpSwStateType.QUERY;
        this.cmdStnOpSwNum = opSwNum;
        this.cmdStnOpSwVal = val;
        int[] nArray = new int[4];
        nArray[0] = 187;
        nArray[1] = 127;
        int[] contents = nArray;
        this.memo.getLnTrafficController().sendLocoNetMessage(new LocoNetMessage(contents));
        this.csOpSwAccessTimer.start();
        return true;
    }

    public boolean extractCmdStnOpSw(int cmdStnOpSwNum) {
        if (cmdStnOpSwNum > 0 && cmdStnOpSwNum < 65 && this.haveValidLowBytes || cmdStnOpSwNum > 64 && cmdStnOpSwNum < 129 && this.haveValidHighBytes) {
            log.debug("attempting to extract value for OpSw {} with haveValidLowBytes {} and haveValidHighBytes {}", new Object[]{cmdStnOpSwNum, this.haveValidLowBytes, this.haveValidHighBytes});
            int msgByte = (cmdStnOpSwNum - 1) / 8;
            int bitpos = cmdStnOpSwNum - 1 - 8 * msgByte;
            boolean retval = (this.opSwBytes[msgByte] >> bitpos & 1) == 1;
            log.debug("extractCmdStnOpSw: opsw{} from bit {} of opSwByte[{}]={} gives {}", new Object[]{cmdStnOpSwNum, bitpos, msgByte, this.opSwBytes[msgByte], retval});
            return retval;
        }
        log.debug("failing extract account problem with cmdStnOpSwNum={}, haveValidLowBytes {} and haveValidHighBytes {}", new Object[]{cmdStnOpSwNum, this.haveValidLowBytes, this.haveValidHighBytes});
        this.csOpSwAccessTimer.stop();
        this.csOpSwValidTimer.stop();
        this.sendFinalProgrammerReply(-1, 1);
        return false;
    }

    public LocoNetMessage updateOpSwVal(int cmdStnOpSwNum, boolean cmdStnOpSwVal) {
        if ((cmdStnOpSwNum - 1 & 7) == 7) {
            log.warn("Cannot program OpSw{} account LocoNet encoding limitations.", (Object)cmdStnOpSwNum);
            this.sendFinalProgrammerReply(-1, 1);
            int[] nArray = new int[2];
            nArray[0] = 129;
            return new LocoNetMessage(nArray);
        }
        if (cmdStnOpSwNum < 1 || cmdStnOpSwNum > 128) {
            log.warn("Cannot program OpSw{} account OpSw number out of range.", (Object)cmdStnOpSwNum);
            this.sendFinalProgrammerReply(-1, 8);
            int[] nArray = new int[2];
            nArray[0] = 129;
            return new LocoNetMessage(nArray);
        }
        log.debug("updateOpSwVal: OpSw{} = {}", (Object)cmdStnOpSwNum, (Object)cmdStnOpSwVal);
        this.changeOpSwBytes(cmdStnOpSwNum, cmdStnOpSwVal);
        LocoNetMessage m = new LocoNetMessage(14);
        m.setOpCode(239);
        m.setElement(1, 14);
        m.setElement(2, cmdStnOpSwNum >= 65 ? 126 : 127);
        m.setElement(3, this.opSwBytes[0 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(4, this.opSwBytes[1 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(5, this.opSwBytes[2 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(6, this.opSwBytes[3 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(7, 0);
        m.setElement(8, this.opSwBytes[4 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(9, this.opSwBytes[5 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(10, this.opSwBytes[6 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(11, this.opSwBytes[7 + 8 * (cmdStnOpSwNum > 64 ? 1 : 0)]);
        m.setElement(12, 0);
        m.setElement(13, 0);
        return m;
    }

    private void finishTheWrite() {
        this.cmdStnOpSwState = CmdStnOpSwStateType.WRITE;
        LocoNetMessage m2 = this.updateOpSwVal(this.cmdStnOpSwNum, this.cmdStnOpSwVal);
        if (m2.getNumDataElements() == 2) {
            this.sendFinalProgrammerReply(-1, 1);
            return;
        }
        m2.setOpCode(239);
        log.debug("finish the write sending LocoNet cmd stn opsw write message {}, length={}", (Object)m2.toString(), (Object)m2.getNumDataElements());
        this.memo.getLnTrafficController().sendLocoNetMessage(m2);
        this.csOpSwAccessTimer.start();
    }

    private void sendFinalProgrammerReply(int val, int response) {
        log.debug("returning response {} with value {} to programmer", (Object)response, (Object)val);
        ProgListener temp = this.p;
        this.p = null;
        if (temp != null) {
            temp.programmingOpReply(val, response);
        }
    }

    void initializeCsOpSwAccessTimer() {
        if (this.csOpSwAccessTimer == null) {
            this.csOpSwAccessTimer = new Timer(500, e -> {
                log.debug("csOpSwAccessTimer timed out!");
                ProgListener temp = this.p;
                this.p = null;
                if (temp != null) {
                    temp.programmingOpReply(0, 128);
                }
            });
            this.csOpSwAccessTimer.setRepeats(false);
        }
    }

    void initializeCsOpSwValidTimer() {
        if (this.csOpSwValidTimer == null) {
            this.csOpSwValidTimer = new Timer(1000, e -> {
                log.debug("csOpSwValidTimer timed out; invalidating held data!");
                this.haveValidLowBytes = false;
                this.haveValidHighBytes = false;
                this.cmdStnOpSwState = CmdStnOpSwStateType.IDLE;
            });
            this.csOpSwValidTimer.setRepeats(false);
        }
    }

    private void updateStoredOpSwsFromRead(LocoNetMessage m) {
        if (m.getOpCode() == 231 && m.getElement(1) == 14 && m.getElement(2) == 127) {
            this.opSwBytes[0] = m.getElement(3);
            this.opSwBytes[1] = m.getElement(4);
            this.opSwBytes[2] = m.getElement(5);
            this.opSwBytes[3] = m.getElement(6);
            this.opSwBytes[4] = m.getElement(8);
            this.opSwBytes[5] = m.getElement(9);
            this.opSwBytes[6] = m.getElement(10);
            this.opSwBytes[7] = m.getElement(11);
            this.opSwBytes[8] = 0;
            this.opSwBytes[10] = 0;
            this.opSwBytes[11] = 0;
            this.opSwBytes[12] = 0;
            this.opSwBytes[13] = 0;
            this.opSwBytes[14] = 0;
            this.opSwBytes[15] = 0;
            this.haveValidLowBytes = true;
            this.haveValidHighBytes = false;
        } else if (m.getOpCode() == 231 && m.getElement(1) == 14 && m.getElement(2) == 126) {
            this.opSwBytes[8] = m.getElement(3);
            this.opSwBytes[9] = m.getElement(4);
            this.opSwBytes[10] = m.getElement(5);
            this.opSwBytes[11] = m.getElement(6);
            this.opSwBytes[12] = m.getElement(8);
            this.opSwBytes[13] = m.getElement(9);
            this.opSwBytes[14] = m.getElement(10);
            this.opSwBytes[15] = m.getElement(11);
            this.haveValidHighBytes = true;
        }
    }

    private void changeOpSwBytes(int cmdStnOpSwNum, boolean cmdStnOpSwVal) {
        log.debug("updating OpSw{} to {}", (Object)cmdStnOpSwNum, (Object)cmdStnOpSwVal);
        int msgByte = (cmdStnOpSwNum - 1) / 8;
        int bitpos = cmdStnOpSwNum - 1 - 8 * msgByte;
        int newVal = this.opSwBytes[msgByte] & ~(1 << bitpos) | (cmdStnOpSwVal ? 1 : 0) << bitpos;
        log.debug("updating OpSwBytes[{}] from {} to {}", new Object[]{msgByte, this.opSwBytes[msgByte], newVal});
        this.opSwBytes[msgByte] = newVal;
    }

    public CmdStnOpSwStateType getState() {
        return this.cmdStnOpSwState;
    }

    public void dispose() {
        if (this.csOpSwAccessTimer != null) {
            this.csOpSwAccessTimer.stop();
        }
        if (this.csOpSwValidTimer != null) {
            this.csOpSwValidTimer.stop();
        }
    }

    static enum CmdStnOpSwStateType {
        IDLE,
        QUERY,
        QUERY_ENHANCED,
        QUERY_BEFORE_WRITE,
        QUERY_ENHANCED_BEFORE_WRITE,
        WRITE,
        HAS_STATE;

    }
}

