/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.ztc640;

import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZTC640XNetPacketizer
extends XNetPacketizer {
    private static final Logger log = LoggerFactory.getLogger(ZTC640XNetPacketizer.class);

    public ZTC640XNetPacketizer(LenzCommandStation pCommandStation) {
        super(pCommandStation);
        log.debug("Loading ZTC640 Extention to XNetPacketizer");
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        log.debug("loading characters from port");
        int i = 0;
        while (i < msg.maxSize()) {
            byte char1 = this.readByteProtected(istream);
            while (i == 0 && (char1 & 0xF0) == 240) {
                if ((char1 & 0xFF) == 240 || (char1 & 0xFF) == 242) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Filtering 0x{} from stream", (Object)Integer.toHexString(char1 & 0xFF));
                }
                char1 = this.readByteProtected(istream);
            }
            msg.setElement(i, char1 & 0xFF);
            if (this.endOfMessage(msg)) break;
            ++i;
        }
        log.debug("Accepted Message: {}", (Object)msg);
    }
}

