/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.xntcp.configurexml;

import javax.annotation.Nonnull;
import jmri.jmrix.configurexml.AbstractNetworkConnectionConfigXml;
import jmri.jmrix.lenz.xntcp.ConnectionConfig;
import jmri.jmrix.lenz.xntcp.XnTcpAdapter;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractNetworkConnectionConfigXml {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    protected void getInstance() {
        if (this.adapter == null) {
            this.adapter = new XnTcpAdapter();
        }
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    public boolean load(@Nonnull Element shared, Element perNode) {
        boolean result = true;
        try {
            result = super.load(shared, perNode);
            if (log.isDebugEnabled()) {
                log.debug("result {}", (Object)result);
            }
        }
        catch (NullPointerException nullPointerException) {
            String yesno;
            if (log.isDebugEnabled()) {
                log.debug("Null Pointer Exception Occured");
            }
            try {
                String manualOption = shared.getAttribute("port").getValue();
                this.adapter.configureOption1(manualOption);
            }
            catch (NullPointerException nullPointerException2) {}
            try {
                String hostName = shared.getAttribute("option1").getValue();
                this.adapter.setHostName(hostName);
            }
            catch (NullPointerException nullPointerException3) {}
            try {
                int portNumber = shared.getAttribute("option2").getIntValue();
                this.adapter.setPort(portNumber);
            }
            catch (DataConversionException dataConversionException) {
                log.warn("Could not parse port attribute");
            }
            catch (NullPointerException nullPointerException4) {}
            try {
                String manufacturer = shared.getAttribute("manufacturer").getValue();
                this.adapter.setManufacturer(manufacturer);
            }
            catch (NullPointerException nullPointerException5) {}
            if (this.adapter.getSystemConnectionMemo() != null) {
                if (shared.getAttribute("userName") != null) {
                    this.adapter.getSystemConnectionMemo().setUserName(shared.getAttribute("userName").getValue());
                }
                if (shared.getAttribute("systemPrefix") != null) {
                    this.adapter.getSystemConnectionMemo().setSystemPrefix(shared.getAttribute("systemPrefix").getValue());
                }
            }
            if (shared.getAttribute("disabled") != null && (yesno = shared.getAttribute("disabled").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("no")) {
                    this.adapter.setDisabled(false);
                } else if (yesno.equals("yes")) {
                    this.adapter.setDisabled(true);
                }
            }
            this.register();
            if (this.adapter.getDisabled()) {
                this.unpackElement(shared, perNode);
                return result;
            }
            try {
                this.adapter.connect();
            }
            catch (Exception e1) {
                this.handleException(e1.getMessage(), "opening connection", null, null, e1);
                return false;
            }
            this.adapter.configure();
            this.unpackElement(shared, perNode);
        }
        return result;
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

