/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.xntcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetNetworkPortController;
import jmri.jmrix.lenz.xntcp.Bundle;
import jmri.jmrix.lenz.xntcp.XnTcpXNetPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XnTcpAdapter
extends XNetNetworkPortController {
    static final int DEFAULT_UDP_PORT = 61234;
    static final int DEFAULT_TCP_PORT = 61235;
    static final String DEFAULT_IP_ADDRESS = "10.1.0.1";
    static final int UDP_LENGTH = 18;
    static final int BROADCAST_TIMEOUT = 1000;
    static final int READ_TIMEOUT = 8000;
    static final int MAX_PENDING_PACKETS = 15;
    private static final String MANUAL = "Manual";
    private Vector<String> hostNameVector = null;
    private Vector<HostAddress> hostAddressVector = null;
    private InputStream inTcpStream = null;
    private OutputTcpStream outTcpStream = null;
    private int pendingPackets = 0;
    private String outName = "Manual";
    private static final Logger log = LoggerFactory.getLogger(XnTcpAdapter.class);

    public XnTcpAdapter() {
        this.option1Name = "XnTcpInterface";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("XnTcpInterfaceLabel"), this.getInterfaces()));
        this.m_HostName = DEFAULT_IP_ADDRESS;
        this.m_port = 61235;
    }

    String[] getInterfaces() {
        Vector<String> v = this.getInterfaceNames();
        String[] a = new String[v.size() + 1];
        int i = 0;
        while (i < v.size()) {
            a[i + 1] = v.elementAt(i);
            ++i;
        }
        a[0] = Bundle.getMessage(MANUAL);
        return a;
    }

    public Vector<String> getInterfaceNames() {
        this.findInterfaces();
        return this.hostNameVector;
    }

    @Override
    public void connect() throws IOException {
        if (this.getOptionState(this.option1Name) != null) {
            this.outName = this.getOptionState(this.option1Name);
        }
        if (this.outName.equals(Bundle.getMessage(MANUAL)) || this.outName.equals(MANUAL)) {
            if (this.m_HostName == null) {
                this.m_HostName = DEFAULT_IP_ADDRESS;
            }
            if (this.m_port == 0) {
                this.m_port = 61235;
            }
            this.outName = this.m_HostName;
        } else {
            int ind;
            if (this.hostNameVector == null) {
                this.findInterfaces();
            }
            if ((ind = this.hostNameVector.indexOf(this.outName)) < 0) {
                throw new IOException("XpressNet/TCP interface " + this.outName + " not found");
            }
            this.m_HostName = this.hostAddressVector.get(ind).ipNumber;
            this.m_port = this.hostAddressVector.get(ind).portNumber;
        }
        try {
            try {
                this.socketConn = new Socket(this.m_HostName, this.m_port);
                this.socketConn.setSoTimeout(8000);
            }
            catch (UnknownHostException e) {
                ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.outName, "Not Connected");
                throw e;
            }
            this.inTcpStream = this.socketConn.getInputStream();
            this.purgeStream(this.inTcpStream);
            this.opened = true;
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.outName, "Connected");
        }
        catch (SocketException se) {
            log.error("Socket exception while opening TCP connection with {} trace follows: {}", (Object)this.outName, (Object)se);
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.outName, "Not Connected");
            throw se;
        }
        catch (IOException e) {
            log.error("Unexpected exception while opening TCP connection with {} trace follows: {}", (Object)this.outName, (Object)e);
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.outName, "Not Connected");
            throw e;
        }
    }

    private void findInterfaces() {
        DatagramSocket udpSocket = null;
        this.hostNameVector = new Vector(10, 1);
        this.hostAddressVector = new Vector(10, 1);
        try {
            try {
                byte[] udpBuffer = new byte[18];
                udpSocket = new DatagramSocket();
                udpBuffer[0] = 37;
                DatagramPacket udpPacket = new DatagramPacket(udpBuffer, 1, InetAddress.getByName("255.255.255.255"), 61234);
                udpSocket.send(udpPacket);
                udpSocket.setSoTimeout(1000);
                while (true) {
                    udpPacket.setLength(18);
                    udpSocket.receive(udpPacket);
                    if (udpPacket.getLength() < 18) continue;
                    this.hostNameVector.addElement(new String(udpBuffer, 0, 16, StandardCharsets.US_ASCII).trim());
                    this.hostAddressVector.addElement(new HostAddress(XnTcpAdapter.cleanIP(udpPacket.getAddress().getHostAddress()), (udpBuffer[16] & 0xFF) * 256 + (udpBuffer[17] & 0xFF)));
                }
            }
            catch (IOException e) {
                log.debug("Exception occured: {}", (Throwable)e);
                if (udpSocket != null) {
                    udpSocket.close();
                    udpSocket = null;
                }
            }
        }
        catch (Throwable throwable) {
            if (udpSocket != null) {
                udpSocket.close();
                udpSocket = null;
            }
            throw throwable;
        }
    }

    protected synchronized void xnTcpSetPendingPackets(int s) {
        this.pendingPackets += s;
        if (this.pendingPackets < 0) {
            this.pendingPackets = 0;
        }
    }

    protected synchronized void xnTcpError() {
        if (this.opened) {
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.outName, "Not Connected");
            this.opened = false;
            log.debug("XnTcpError: TCP/IP communication dropped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean okToSend() {
        if (!this.opened) {
            return true;
        }
        XnTcpAdapter xnTcpAdapter = this;
        synchronized (xnTcpAdapter) {
            log.debug("XnTcpAdapter.okToSend = {} (pending packets = {})", (Object)(this.pendingPackets < 15 ? 1 : 0), (Object)this.pendingPackets);
            return this.pendingPackets < 15;
        }
    }

    @Override
    public void configure() {
        XnTcpXNetPacketizer packets = new XnTcpXNetPacketizer(new LenzCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).setDefaults().versionCheck().setTimeout(30000).init();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.inTcpStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            this.outTcpStream = new OutputTcpStream(this.socketConn.getOutputStream());
            return new DataOutputStream(this.outTcpStream);
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    private static String cleanIP(String ip) {
        String outIP = ip;
        int i = outIP.indexOf(47);
        if (i >= 0 && i < outIP.length() - 2) {
            outIP = outIP.substring(i + 1);
        }
        return outIP;
    }

    private static class HostAddress {
        private final String ipNumber;
        private final int portNumber;

        private HostAddress(String h, int p) {
            this.ipNumber = h;
            this.portNumber = p;
        }
    }

    public class OutputTcpStream
    extends OutputStream {
        private OutputStream tcpOut = null;
        private int count;

        public OutputTcpStream() {
        }

        public OutputTcpStream(OutputStream out) {
            this.tcpOut = out;
            this.count = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            OutputStream outputStream = this.tcpOut;
            synchronized (outputStream) {
                try {
                    this.tcpOut.write(b);
                    if (log.isDebugEnabled()) {
                        log.debug("XnTcpAdapter: sent {}", (Object)Integer.toHexString(b & 0xFF));
                    }
                    if (this.count < 0) {
                        this.count = b & 0xF;
                    } else if (this.count-- == 0) {
                        this.tcpOut.flush();
                        log.debug("XnTcpAdapter: flush ");
                        XnTcpAdapter.this.xnTcpSetPendingPackets(1);
                    }
                }
                catch (IOException e) {
                    XnTcpAdapter.this.xnTcpError();
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream outputStream = this.tcpOut;
            synchronized (outputStream) {
                while (len-- > 0) {
                    this.write(b[off++] & 0xFF);
                }
            }
        }

        public void write(byte[] b, int len) throws IOException {
            this.write(b, 0, len);
        }
    }
}

