/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.xnetsimulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.BitSet;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetPacketizer;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSimulatorPortController;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.xnetsimulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetSimulatorAdapter
extends XNetSimulatorPortController
implements Runnable {
    private boolean outputBufferEmpty = true;
    private int csStatus;
    private static final int CS_EMERGENCY_STOP = 1;
    private static final int CS_NORMAL_MODE = 0;
    private int currentSpeedStepMode = 19;
    private int currentSpeedStep = 0;
    private int functionGroup1 = 0;
    private int functionGroup2 = 0;
    private int functionGroup3 = 0;
    private int functionGroup4 = 0;
    private int functionGroup5 = 0;
    private int momentaryGroup1 = 0;
    private int momentaryGroup2 = 0;
    private int momentaryGroup3 = 0;
    private int momentaryGroup4 = 0;
    private int momentaryGroup5 = 0;
    private final BitSet accessoryState = new BitSet(1024);
    private final BitSet accessoryOperated = new BitSet(1024);
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private Thread sourceThread;
    private static final Logger log = LoggerFactory.getLogger(XNetSimulatorAdapter.class);

    public XNetSimulatorAdapter() {
        this.setPort(Bundle.getMessage("None"));
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Throwable)e);
            return;
        }
        this.csStatus = 0;
    }

    @Override
    public String openPort(String portName, String appName) {
        this.setPort(portName);
        return null;
    }

    @Override
    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    @Override
    public boolean okToSend() {
        boolean checkBuffer = true;
        if (checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty && super.okToSend();
        }
        log.debug("No Flow Control or Buffer Check");
        return super.okToSend();
    }

    @Override
    public void configure() {
        XNetPacketizer packets = new XNetPacketizer(new LenzCommandStation());
        this.configure(packets);
    }

    protected void configure(XNetTrafficController packets) {
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        this.sourceThread = new Thread(this);
        this.sourceThread.start();
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).setDefaults().versionCheck().setTimeout(30000).init();
    }

    @Override
    public DataInputStream getInputStream() {
        if (this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.getCurrentPortName(), "Not Connected");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.getCurrentPortName(), "Not Connected");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.pout != null && this.pin != null;
    }

    @Override
    public void run() {
        log.debug("Simulator Thread Started");
        ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.getCurrentPortName(), "Connected");
        while (true) {
            XNetMessage m = this.readMessage();
            log.debug("Simulator Thread received message {}", (Object)m);
            XNetReply r = this.generateReply(m);
            this.writeReply(r);
            log.debug("Simulator Thread sent Reply {}", (Object)r);
        }
    }

    private XNetMessage readMessage() {
        XNetMessage msg = null;
        try {
            msg = this.loadChars();
        }
        catch (IOException iOException) {
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.getCurrentPortName(), "Not Connected");
        }
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private XNetReply generateReply(XNetMessage m) {
        XNetReply reply = new XNetReply();
        block0 : switch (m.getElement(0) & 0xFF) {
            case 33: {
                switch (m.getElement(1) & 0xFF) {
                    case 33: {
                        reply = this.xNetVersionReply();
                        break block0;
                    }
                    case 129: {
                        this.csStatus = 0;
                        reply = this.normalOpsReply();
                        break block0;
                    }
                    case 128: {
                        this.csStatus = 1;
                        reply = this.everythingOffReply();
                        break block0;
                    }
                    case 36: {
                        reply = this.csStatusReply();
                        break block0;
                    }
                }
                reply = this.notSupportedReply();
                break;
            }
            case 240: {
                reply.setOpCode(2);
                reply.setElement(1, 0);
                reply.setElement(2, 0);
                reply.setElement(3, 0);
                reply.setParity();
                break;
            }
            case 228: {
                switch (m.getElement(1) & 0xFF) {
                    case 16: {
                        this.currentSpeedStepMode = 16;
                        this.currentSpeedStep = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 17: {
                        this.currentSpeedStepMode = 17;
                        this.currentSpeedStep = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 18: {
                        this.currentSpeedStepMode = 18;
                        this.currentSpeedStep = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 19: {
                        this.currentSpeedStepMode = 19;
                        this.currentSpeedStep = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 32: {
                        this.functionGroup1 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 33: {
                        this.functionGroup2 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 34: {
                        this.functionGroup3 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 35: {
                        this.functionGroup4 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 40: {
                        this.functionGroup5 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 36: {
                        this.momentaryGroup1 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 37: {
                        this.momentaryGroup2 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 38: {
                        this.momentaryGroup3 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 39: {
                        this.momentaryGroup4 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                    case 44: {
                        this.momentaryGroup5 = m.getElement(4);
                        reply = this.okReply();
                        break block0;
                    }
                }
                reply = this.notSupportedReply();
                break;
            }
            case 128: {
                this.csStatus = 1;
                reply = this.emergencyStopReply();
                break;
            }
            case 145: 
            case 146: {
                reply = this.okReply();
                break;
            }
            case 82: {
                reply = this.accReqReply(m);
                break;
            }
            case 66: {
                reply = this.accInfoReply(m);
                break;
            }
            case 227: {
                switch (m.getElement(1) & 0xFF) {
                    case 0: {
                        reply.setOpCode(228);
                        reply.setElement(1, this.currentSpeedStepMode);
                        reply.setElement(2, this.currentSpeedStep);
                        reply.setElement(3, this.functionGroup1);
                        reply.setElement(4, (this.functionGroup2 & 0xF) + ((this.functionGroup3 & 0xF) << 4));
                        reply.setElement(5, 0);
                        reply.setParity();
                        break block0;
                    }
                    case 7: {
                        reply.setOpCode(227);
                        reply.setElement(1, 80);
                        reply.setElement(2, this.momentaryGroup1);
                        reply.setElement(3, (this.momentaryGroup2 & 0xF) + (this.momentaryGroup3 * 15 << 4));
                        reply.setElement(4, 0);
                        reply.setParity();
                        break block0;
                    }
                    case 9: {
                        reply.setOpCode(227);
                        reply.setElement(1, 82);
                        reply.setElement(2, this.functionGroup4);
                        reply.setElement(3, this.functionGroup5);
                        reply.setElement(4, 0);
                        reply.setParity();
                        break block0;
                    }
                    case 8: {
                        reply.setOpCode(228);
                        reply.setElement(1, 81);
                        reply.setElement(2, this.momentaryGroup4);
                        reply.setElement(3, this.momentaryGroup5);
                        reply.setElement(4, 0);
                        reply.setParity();
                        break block0;
                    }
                }
                reply = this.notSupportedReply();
                break;
            }
            case 230: {
                int operation = m.getElement(4) & 0xFC;
                switch (operation & 0xFF) {
                    case 236: {
                        log.debug("Write CV in Ops Mode Request Received");
                        reply = this.okReply();
                        break block0;
                    }
                    case 228: {
                        log.debug("Verify CV in Ops Mode Request Received");
                        reply = this.okReply();
                        break block0;
                    }
                    case 232: {
                        log.debug("Ops Mode Bit Request Received");
                        reply = this.okReply();
                        break block0;
                    }
                }
                reply = this.notSupportedReply();
                break;
            }
            default: {
                reply = this.notSupportedReply();
            }
        }
        return reply;
    }

    private XNetReply notSupportedReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(97);
        r.setElement(1, 130);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply okReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(1);
        r.setElement(1, 4);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply normalOpsReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(97);
        r.setElement(1, 1);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply everythingOffReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(97);
        r.setElement(1, 0);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply emergencyStopReply() {
        XNetReply r = new XNetReply();
        r.setOpCode(129);
        r.setElement(1, 0);
        r.setElement(2, 0);
        r.setParity();
        return r;
    }

    private XNetReply xNetVersionReply() {
        XNetReply reply = new XNetReply();
        reply.setOpCode(99);
        reply.setElement(1, 33);
        reply.setElement(2, 54);
        reply.setElement(3, 0);
        reply.setElement(4, 0);
        reply.setParity();
        return reply;
    }

    private XNetReply csStatusReply() {
        XNetReply reply = new XNetReply();
        reply.setOpCode(98);
        reply.setElement(1, 34);
        reply.setElement(2, this.csStatus);
        reply.setElement(3, 0);
        reply.setParity();
        return reply;
    }

    protected int getTurnoutFeedbackType() {
        return 1;
    }

    protected int getAccessoryStateBits(int a) {
        if (!this.accessoryOperated.get(a)) {
            return 0;
        }
        boolean state = this.accessoryState.get(a);
        int zbits = state ? 2 : 1;
        return zbits;
    }

    protected XNetReply accInfoReply(XNetMessage m) {
        if (m.getElement(1) >= 64) {
            return this.feedbackInfoReply(m);
        }
        boolean nibble = (m.getElement(2) & 1) == 1;
        int ba = m.getElement(1);
        return this.accInfoReply(ba, nibble);
    }

    protected XNetReply feedbackInfoReply(XNetMessage m) {
        XNetReply reply = new XNetReply();
        reply.setOpCode(66);
        reply.setElement(1, m.getElement(1));
        if (m.getElement(2) == 128) {
            reply.setElement(2, 64);
        } else {
            reply.setElement(2, 80);
        }
        reply.setElement(3, 0);
        reply.setParity();
        return reply;
    }

    protected XNetReply accInfoReply(int baseAddress, boolean nibble) {
        XNetReply r = new XNetReply();
        r.setOpCode(66);
        r.setElement(1, baseAddress);
        int nibbleVal = 0;
        int a = baseAddress * 4 + 1;
        if (nibble) {
            a += 2;
        }
        int zbits = this.getAccessoryStateBits(a++);
        nibbleVal |= zbits;
        zbits = this.getAccessoryStateBits(a++);
        r.setElement(2, this.getTurnoutFeedbackType() << 5 | (nibble ? 1 : 0) << 4 | (nibbleVal |= zbits << 2) & 0xF);
        r.setElement(3, 0);
        r.setParity();
        return r;
    }

    protected XNetReply generateAccRequestReply(int address, int output, boolean state, boolean previousAccessoryState) {
        XNetReply r;
        if (state) {
            if (this.accessoryOperated.get(address) && previousAccessoryState == (output != 0)) {
                return this.okReply();
            }
            this.accessoryOperated.set(address);
            r = this.accInfoReply(address);
            r.setUnsolicited();
        } else {
            this.accessoryOperated.set(address);
            r = this.okReply();
        }
        return r;
    }

    protected XNetReply accInfoReply(int dccTurnoutAddress) {
        int baseAddress = --dccTurnoutAddress / 4;
        boolean upperNibble = dccTurnoutAddress % 4 >= 2;
        return this.accInfoReply(baseAddress, upperNibble);
    }

    protected XNetReply accReqReply(XNetMessage m) {
        int baseaddress = m.getElement(1);
        int subaddress = (m.getElement(2) & 6) >> 1;
        int address = baseaddress * 4 + subaddress + 1;
        int output = m.getElement(2) & 1;
        boolean on = (m.getElement(2) & 8) == 8;
        boolean oldState = this.accessoryState.get(address);
        if (on) {
            this.accessoryState.set(address, output != 0);
        }
        log.debug("Received command {} ... {}", (Object)m, (Object)m.toMonitorString());
        return this.generateAccRequestReply(address, output, on, oldState);
    }

    private void writeReply(XNetReply r) {
        int len = (r.getElement(0) & 0xF) + 2;
        int i = 0;
        while (i < len) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {
                ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.getCurrentPortName(), "Not Connected");
            }
            ++i;
        }
    }

    protected XNetMessage loadChars() throws IOException {
        byte char1 = this.readByteProtected(this.inpipe);
        int len = (char1 & 0xF) + 2;
        XNetMessage msg = new XNetMessage(len);
        msg.setElement(0, char1 & 0xFF);
        int i = 1;
        while (i < len) {
            char1 = this.readByteProtected(this.inpipe);
            msg.setElement(i, char1 & 0xFF);
            ++i;
        }
        return msg;
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        byte[] rcvBuffer = new byte[1];
        while ((nchars = istream.read(rcvBuffer, 0, 1)) <= 0) {
        }
        return rcvBuffer[0];
    }
}

