/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.stackmon;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.swing.stackmon.Bundle;
import jmri.jmrix.lenz.swing.stackmon.StackMonDataModel;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackMonFrame
extends JmriJFrame
implements XNetListener {
    final JButton nextButton = new JButton(Bundle.getMessage("NextButtonLabel"));
    final JButton previousButton = new JButton(Bundle.getMessage("PreviousButtonLabel"));
    final JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    final JButton refreshButton = new JButton(Bundle.getMessage("RefreshButtonLabel"));
    final JLabel currentStatus = new JLabel(" ");
    final JTextField adrTextField = new JTextField(4);
    StackMonDataModel stackModel;
    JTable stackTable;
    private boolean _getAll = false;
    protected XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(StackMonFrame.class);

    public StackMonFrame(XNetSystemConnectionMemo memo) {
        this.stackModel = new StackMonDataModel(1, 4, memo);
        this.stackTable = new JTable(this.stackModel);
        this.nextButton.addActionListener(e -> this.getNextEntry());
        this.nextButton.setVisible(true);
        this.previousButton.addActionListener(e -> this.getPreviousEntry());
        this.previousButton.setVisible(true);
        this.previousButton.setEnabled(false);
        this.deleteButton.setVisible(true);
        this.deleteButton.addActionListener(e -> this.deleteEntry());
        this.refreshButton.setVisible(true);
        this.refreshButton.addActionListener(e -> this.getAllEntries());
        this.adrTextField.setVisible(true);
        this.setTitle(Bundle.getMessage("MenuItemCSDatabaseManager"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new FlowLayout());
        pane1.add(this.refreshButton);
        this.getContentPane().add(pane1);
        JPanel manualPanel = new JPanel();
        manualPanel.setLayout(new FlowLayout());
        manualPanel.add(this.previousButton);
        manualPanel.add(this.nextButton);
        manualPanel.add(this.deleteButton);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        pane2.add(this.adrTextField);
        JPanel pane3 = new JPanel();
        pane3.setLayout(new FlowLayout());
        pane3.add(this.currentStatus);
        JScrollPane stackPane = new JScrollPane(this.stackTable);
        stackPane.setVerticalScrollBarPolicy(20);
        this.stackModel.initTable(this.stackTable, this);
        this.getContentPane().add(stackPane);
        this.addHelpMenu("package.jmri.jmrix.lenz.stackmon.StackMonFrame", true);
        this.pack();
        this.tc = memo.getXNetTrafficController();
        this.tc.addXNetListener(-1, this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int jMenuBarHeight = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += jMenuBarHeight;
            this.setSize(dimension);
        }
    }

    private void getAllEntries() {
        this.stackModel.clearData();
        this._getAll = true;
        this.getNextEntry();
    }

    private void getNextEntry() {
        int address = 0;
        if (!this.adrTextField.getText().equals("")) {
            address = Integer.parseInt(this.adrTextField.getText());
        }
        XNetMessage msg = XNetMessage.getNextAddressOnStackMsg(address, true);
        this.tc.sendXNetMessage(msg, this);
    }

    private void getNextEntry(int address) {
        XNetMessage msg = XNetMessage.getNextAddressOnStackMsg(address, true);
        this.tc.sendXNetMessage(msg, this);
    }

    private void getPreviousEntry() {
        int address = 0;
        if (!this.adrTextField.getText().equals("")) {
            address = Integer.parseInt(this.adrTextField.getText());
        }
        XNetMessage msg = XNetMessage.getNextAddressOnStackMsg(address, false);
        this.tc.sendXNetMessage(msg, this);
    }

    private void deleteEntry() {
        if (!this.adrTextField.getText().equals("")) {
            int address = Integer.parseInt(this.adrTextField.getText());
            XNetMessage msg = XNetMessage.getDeleteAddressOnStackMsg(address);
            this.tc.sendXNetMessage(msg, this);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="This is part of work in progress code to allow display of all information about the locomotives in the stack.")
    private void requestStatus() {
        if (!this.adrTextField.getText().equals("")) {
            int address = Integer.parseInt(this.adrTextField.getText());
            XNetMessage msg = XNetMessage.getLocomotiveInfoRequestMsg(address);
            this.tc.sendXNetMessage(msg, this);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="This is part of work in progress code to allow display of all information about the locomotives in the stack.")
    private void requestFunctionStatus() {
        if (!this.adrTextField.getText().equals("")) {
            int address = Integer.parseInt(this.adrTextField.getText());
            XNetMessage msg = XNetMessage.getLocomotiveFunctionStatusMsg(address);
            this.tc.sendXNetMessage(msg, this);
        }
    }

    @Override
    public void message(XNetReply r) {
        if (r.getElement(0) == 227) {
            int address = r.getThrottleMsgAddr();
            Integer intAddress = address;
            switch (r.getElement(1)) {
                case 48: {
                    this.currentStatus.setText(Bundle.getMessage("SearchNormal"));
                    this.adrTextField.setText("" + address);
                    this.stackModel.updateData(intAddress, Bundle.getMessage("SearchNormal"));
                    if (!this._getAll) break;
                    this.getNextEntry(address);
                    break;
                }
                case 49: {
                    this.currentStatus.setText(Bundle.getMessage("SearchDH"));
                    this.adrTextField.setText("" + r.getThrottleMsgAddr());
                    this.stackModel.updateData(intAddress, Bundle.getMessage("SearchDH"));
                    if (!this._getAll) break;
                    this.getNextEntry(address);
                    break;
                }
                case 50: {
                    this.currentStatus.setText(Bundle.getMessage("SearchMUBase"));
                    this.adrTextField.setText("" + r.getThrottleMsgAddr());
                    this.stackModel.updateData(intAddress, Bundle.getMessage("SearchMUBase"));
                    if (!this._getAll) break;
                    this.getNextEntry(address);
                    break;
                }
                case 51: {
                    this.currentStatus.setText(Bundle.getMessage("SearchMU"));
                    this.adrTextField.setText("" + r.getThrottleMsgAddr());
                    this.stackModel.updateData(intAddress, Bundle.getMessage("SearchMU"));
                    if (!this._getAll) break;
                    this.getNextEntry(address);
                    break;
                }
                case 52: {
                    this.currentStatus.setText(Bundle.getMessage("SearchFail"));
                    this.adrTextField.setText("" + r.getThrottleMsgAddr());
                    if (!this._getAll) break;
                    this._getAll = false;
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug("not search result");
                }
            }
        }
    }

    @Override
    public void message(XNetMessage m) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }
}

