/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.stackmon;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.swing.stackmon.Bundle;
import jmri.jmrix.lenz.swing.stackmon.StackMonFrame;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackMonDataModel
extends AbstractTableModel {
    private static final int ADDRCOLUMN = 0;
    private static final int TYPECOLUMN = 1;
    private static final int DELCOLUMN = 3;
    private static final int NUMCOLUMN = 4;
    StackMonFrame _stackFrame;
    ArrayList<Integer> _addressList;
    Hashtable<Integer, String> _typeList;
    protected XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(StackMonDataModel.class);

    StackMonDataModel(int row, int column, XNetSystemConnectionMemo memo) {
        this.tc = memo.getXNetTrafficController();
    }

    void initTable(JTable stackTable, StackMonFrame stackFrame) {
        TableColumnModel tcm = stackTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(3).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(3).setCellEditor(buttonEditor);
        this._stackFrame = stackFrame;
    }

    @Override
    public int getRowCount() {
        try {
            return this._addressList.size();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("AddressCol");
            }
            case 1: {
                return Bundle.getMessage("EntryTypeCol");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Integer.class;
            }
            case 3: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        log.debug("isCellEditable called for row: row: {} column: {}", (Object)row, (Object)col);
        return col == 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        log.debug("getValueAt called for row: {} column: {}", (Object)row, (Object)col);
        if (row >= this._addressList.size()) {
            log.debug("row is greater thant address list size");
            return "Error";
        }
        switch (col) {
            case 0: {
                return this._addressList.get(row);
            }
            case 1: {
                return this._typeList.get(this._addressList.get(row));
            }
            case 3: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        log.debug("setValueAt called for row: {} column: {}", (Object)row, (Object)col);
        if (col == 3) {
            log.debug("Delete Called for row {}", (Object)row);
            this.fireTableRowsDeleted(row, row);
            XNetMessage msg = XNetMessage.getDeleteAddressOnStackMsg(this._addressList.get(row));
            this.tc.sendXNetMessage(msg, this._stackFrame);
            this._typeList.remove(this._addressList.get(row));
            this._addressList.remove(row);
            this.fireTableDataChanged();
        } else {
            log.error("Unknown Operation");
        }
    }

    public void updateData(Integer address, String type) {
        if (this._addressList == null) {
            this._addressList = new ArrayList();
            this._typeList = new Hashtable();
        }
        if (!this._addressList.contains(address)) {
            this._addressList.add(address);
            this._typeList.put(address, type);
        } else {
            this._typeList.put(address, type);
        }
        this.fireTableDataChanged();
    }

    public void clearData() {
        this._addressList = new ArrayList();
        this._typeList = new Hashtable();
        this.fireTableDataChanged();
    }
}

