/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.swing.liusb;

import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.swing.liusb.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIUSBConfigFrame
extends JmriJFrame
implements XNetListener {
    protected XNetTrafficController tc;
    boolean read = false;
    final JComboBox<String> addrBox = new JComboBox();
    final JLabel status = new JLabel("    ");
    final JToggleButton readSettingsButton = new JToggleButton(Bundle.getMessage("LIUSBReadButton"));
    final JToggleButton writeSettingsButton = new JToggleButton(Bundle.getMessage("LIUSBWriteButton"));
    final JButton closeButton = new JButton(Bundle.getMessage("ButtonClose"));
    final JButton resetButton = new JButton(Bundle.getMessage("ButtonResetDefaults"));
    protected final String[] validXNetAddresses = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", ""};
    private static final Logger log = LoggerFactory.getLogger(LIUSBConfigFrame.class);

    public LIUSBConfigFrame(XNetSystemConnectionMemo memo) {
        super(Bundle.getMessage("MenuItemLIUSBConfigurationManager"));
        this.tc = memo.getXNetTrafficController();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane0 = new JPanel();
        pane0.setLayout(new FlowLayout());
        pane0.add(new JLabel(Bundle.getMessage("XNetAddressLabel")));
        pane0.add(this.addrBox);
        pane0.setAlignmentX(0.5f);
        this.getContentPane().add(pane0);
        JPanel pane2 = new JPanel();
        pane2.add(this.readSettingsButton);
        pane2.add(this.writeSettingsButton);
        pane2.add(this.resetButton);
        this.resetButton.setToolTipText(Bundle.getMessage("ResetDefaultsToolTip"));
        pane2.add(this.closeButton);
        this.getContentPane().add(pane2);
        this.addrBox.setVisible(true);
        this.addrBox.setToolTipText(Bundle.getMessage("XNetAddressToolTip"));
        String[] stringArray = this.validXNetAddresses;
        int n = this.validXNetAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            String validXNetAddress = stringArray[n2];
            this.addrBox.addItem(validXNetAddress);
            ++n2;
        }
        this.addrBox.setSelectedIndex(32);
        this.status.setAlignmentX(0.5f);
        this.getContentPane().add(this.status);
        this.pack();
        this.readSettingsButton.addActionListener(a -> this.readLIUSBSettings());
        this.writeSettingsButton.addActionListener(a -> this.writeLIUSBSettings());
        this.closeButton.addActionListener(a -> {
            this.setVisible(false);
            this.dispose();
        });
        this.resetButton.addActionListener(a -> this.resetLIUSBSettings());
        if (this.tc != null) {
            this.tc.addXNetListener(-1, this);
        } else {
            log.warn("No XpressNet connection, so panel won't function");
        }
    }

    void writeLIUSBSettings() {
        if (!this.addrBox.getSelectedItem().equals("") && this.addrBox.getSelectedItem() != null) {
            XNetMessage msg = XNetMessage.getLIAddressRequestMsg(this.addrBox.getSelectedIndex());
            this.tc.sendXNetMessage(msg, this);
        }
    }

    void readLIUSBSettings() {
        XNetMessage msg = XNetMessage.getLIAddressRequestMsg(32);
        this.tc.sendXNetMessage(msg, this);
    }

    @Override
    public void message(XNetReply l) {
        if (l.getElement(0) == 242 && l.getElement(1) == 1) {
            this.addrBox.setSelectedIndex(l.getElement(2));
            this.status.setText(Bundle.getMessage("LIUSBReceivedStatus", l.getElement(2)));
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {}", (Object)msg.toString());
    }

    void resetLIUSBSettings() {
        this.addrBox.setSelectedIndex(30);
    }
}

