/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.liusbserver;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.nio.charset.StandardCharsets;
import java.util.TimerTask;
import jmri.jmrix.AbstractNetworkPortController;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetNetworkPortController;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.liusbserver.Bundle;
import jmri.jmrix.lenz.liusbserver.LIUSBServerXNetPacketizer;
import jmri.util.ImmediatePipedOutputStream;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIUSBServerAdapter
extends XNetNetworkPortController {
    static final int COMMUNICATION_TCP_PORT = 5550;
    static final int BROADCAST_TCP_PORT = 5551;
    static final String DEFAULT_IP_ADDRESS = "localhost";
    private TimerTask keepAliveTimer;
    private static final int keepAliveTimeoutValue = 30000;
    private BroadCastPortAdapter bcastAdapter = null;
    private CommunicationPortAdapter commAdapter = null;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private Thread commThread;
    private Thread bcastThread;
    private static final Logger log = LoggerFactory.getLogger(LIUSBServerAdapter.class);

    public LIUSBServerAdapter() {
        this.option1Name = "BroadcastPort";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("BroadcastPortLabel"), new String[]{String.valueOf(5551), ""}));
        this.manufacturerName = "Lenz";
    }

    @Override
    public synchronized void connect() throws IOException {
        this.opened = false;
        log.debug("connect called");
        try {
            this.bcastAdapter = new BroadCastPortAdapter(this);
            this.commAdapter = new CommunicationPortAdapter(this);
            this.bcastAdapter.connect();
            this.commAdapter.connect();
            this.pout = this.commAdapter.getOutputStream();
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
            this.opened = true;
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Throwable)e);
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.m_HostName, "Not Connected");
            throw e;
        }
        catch (Exception ex) {
            log.error("init (connect): Exception: {}", (Throwable)ex);
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.m_HostName, "Not Connected");
            throw ex;
        }
        this.keepAliveTimer();
        if (this.opened) {
            ConnectionStatus.instance().setConnectionState(this.getSystemConnectionMemo().getUserName(), this.m_HostName, "Connected");
        }
    }

    @Override
    public boolean okToSend() {
        return super.okToSend() && this.status();
    }

    @Override
    public DataInputStream getInputStream() {
        if (this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.pout != null && this.pin != null;
    }

    @Override
    public void configure() {
        log.debug("configure called");
        LIUSBServerXNetPacketizer packets = new LIUSBServerXNetPacketizer(new LenzCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        this.startCommThread();
        this.startBCastThread();
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).setDefaults().versionCheck().setTimeout(30000).init();
    }

    private void startCommThread() {
        this.commThread = new Thread(() -> {
            log.debug("Communication Adapter Thread Started");
            BufferedReader bufferedin = new BufferedReader(new InputStreamReader((InputStream)this.commAdapter.getInputStream(), StandardCharsets.UTF_8));
            while (true) {
                XNetReply r;
                try {
                    CommunicationPortAdapter communicationPortAdapter = this.commAdapter;
                    synchronized (communicationPortAdapter) {
                        r = this.loadChars(bufferedin);
                    }
                }
                catch (IOException iOException) {
                    this.commAdapter.recover();
                    break;
                }
                log.debug("Network Adapter Received Reply: {}", (Object)r);
                this.writeReply(r);
            }
        });
        this.commThread.start();
    }

    private void startBCastThread() {
        this.bcastThread = new Thread(() -> {
            log.debug("Broadcast Adapter Thread Started");
            BufferedReader bufferedin = new BufferedReader(new InputStreamReader((InputStream)this.bcastAdapter.getInputStream(), StandardCharsets.UTF_8));
            while (true) {
                XNetReply r;
                try {
                    BroadCastPortAdapter broadCastPortAdapter = this.bcastAdapter;
                    synchronized (broadCastPortAdapter) {
                        r = this.loadChars(bufferedin);
                    }
                }
                catch (IOException iOException) {
                    this.bcastAdapter.recover();
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Network Adapter Received Reply: {}", (Object)r.toString());
                }
                r.setUnsolicited();
                this.writeReply(r);
            }
        });
        this.bcastThread.start();
    }

    private synchronized void writeReply(XNetReply r) {
        log.debug("Write reply to outpipe: {}", (Object)r);
        int len = (r.getElement(0) & 0xF) + 2;
        int i = 0;
        while (i < len) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    private XNetReply loadChars(BufferedReader istream) throws IOException {
        String s = istream.readLine();
        log.debug("Received from port: {}", (Object)s);
        if (s == null) {
            return null;
        }
        return new XNetReply(s);
    }

    @Override
    public synchronized void recover() {
        this.bcastAdapter.recover();
        this.commAdapter.recover();
    }

    @Override
    protected void resetupConnection() {
        this.getSystemConnectionMemo().getXNetTrafficController().connectPort(this);
    }

    private void keepAliveTimer() {
        if (this.keepAliveTimer == null) {
            this.keepAliveTimer = new TimerTask(){

                @Override
                public void run() {
                    try {
                        LIUSBServerAdapter.this.bcastAdapter.getOutputStream().write(122);
                        LIUSBServerAdapter.this.commAdapter.getOutputStream().write(122);
                    }
                    catch (IOException ex) {
                        log.error("Communications port dropped", (Throwable)ex);
                    }
                }
            };
        } else {
            this.keepAliveTimer.cancel();
        }
        TimerUtil.schedule(this.keepAliveTimer, 30000L, 30000L);
    }

    private static class BroadCastPortAdapter
    extends AbstractNetworkPortController {
        private final LIUSBServerAdapter parent;

        public BroadCastPortAdapter(LIUSBServerAdapter p) {
            super(p.getSystemConnectionMemo());
            this.parent = p;
            this.allowConnectionRecovery = true;
            this.setHostName(LIUSBServerAdapter.DEFAULT_IP_ADDRESS);
            this.setPort(5551);
        }

        @Override
        public void configure() {
        }

        @Override
        public String getManufacturer() {
            return this.parent.getManufacturer();
        }

        @Override
        protected void resetupConnection() {
            this.parent.startBCastThread();
        }

        @Override
        public XNetSystemConnectionMemo getSystemConnectionMemo() {
            return this.parent.getSystemConnectionMemo();
        }

        @Override
        public void dispose() {
        }
    }

    private static class CommunicationPortAdapter
    extends AbstractNetworkPortController {
        private final LIUSBServerAdapter parent;

        public CommunicationPortAdapter(LIUSBServerAdapter p) {
            super(p.getSystemConnectionMemo());
            this.parent = p;
            this.allowConnectionRecovery = true;
            this.setHostName(LIUSBServerAdapter.DEFAULT_IP_ADDRESS);
            this.setPort(5550);
        }

        @Override
        public void configure() {
        }

        @Override
        public String getManufacturer() {
            return this.parent.getManufacturer();
        }

        @Override
        protected void resetupConnection() {
            this.parent.startCommThread();
        }

        @Override
        public XNetSystemConnectionMemo getSystemConnectionMemo() {
            return this.parent.getSystemConnectionMemo();
        }

        @Override
        public void dispose() {
        }
    }
}

