/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.li101;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetInitializationManager;
import jmri.jmrix.lenz.XNetPacketizer;
import jmri.jmrix.lenz.XNetSerialPortController;
import jmri.jmrix.lenz.li101.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class LI101Adapter
extends XNetSerialPortController {
    protected final String[] validSpeeds = new String[]{Bundle.getMessage("LIBaud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200")};
    protected final int[] validSpeedValues = new int[]{19200, 38400, 57600, 115200};
    protected final String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionHwRecomm"), Bundle.getMessage("FlowOptionNo")};
    private boolean opened = false;
    InputStream serialStream = null;
    static volatile LI101Adapter mInstance = null;
    private static final Logger log = LoggerFactory.getLogger(LI101Adapter.class);

    public LI101Adapter() {
        this.option1Name = "FlowControl";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("XconnectionUsesLabel", Bundle.getMessage("IFTypeLI101")), this.validOption1));
        this.manufacturerName = "Lenz";
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.setSerialPort();
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            try {
                this.activeSerialPort.enableReceiveTimeout(10);
                log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            }
            catch (UnsupportedCommOperationException et) {
                log.info("failed to set serial timeout: {}", (Throwable)et);
            }
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud with DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            if (log.isDebugEnabled()) {
                log.debug(" port flow control shows {}", (Object)(this.activeSerialPort.getFlowControlMode() == 2 ? "hardware flow control" : "no flow control"));
                this.setPortEventLogging(this.activeSerialPort);
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public void configure() {
        XNetPacketizer packets = new XNetPacketizer(new LenzCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setXNetTrafficController(packets);
        new XNetInitializationManager().memo(this.getSystemConnectionMemo()).setDefaults().versionCheck().setTimeout(30000).init();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setSerialPort() throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 2;
        if (!this.getOptionState(this.option1Name).equals(this.validOption1[0])) {
            flow = 0;
        }
        this.configureLeadsAndFlowControl(this.activeSerialPort, flow);
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Deprecated
    public static LI101Adapter instance() {
        if (mInstance == null) {
            mInstance = new LI101Adapter();
        }
        return mInstance;
    }
}

