/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.li100;

import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetProgrammer;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LI100XNetProgrammer
extends XNetProgrammer {
    private static final int RETURNSENT = 3;
    private XNetMessage lastRequestMessage = null;
    private int _error = 0;
    private static final Logger log = LoggerFactory.getLogger(LI100XNetProgrammer.class);

    public LI100XNetProgrammer(XNetTrafficController tc) {
        super(tc);
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 1;
        this._val = val;
        this._cv = 0xFFFF & CV;
        try {
            this.restartTimer(90000);
            if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
                XNetMessage msg = XNetMessage.getWritePagedCVMsg(CV, val);
                msg.setNeededMode(1);
                this.lastRequestMessage = new XNetMessage(msg);
                this.controller().sendXNetMessage(msg, this);
            } else if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
                XNetMessage msg = XNetMessage.getWriteDirectCVMsg(CV, val);
                msg.setNeededMode(1);
                this.lastRequestMessage = new XNetMessage(msg);
                this.controller().sendXNetMessage(msg, this);
            } else {
                XNetMessage msg = XNetMessage.getWriteRegisterMsg(this.registerFromCV(CV), val);
                msg.setNeededMode(1);
                this.lastRequestMessage = new XNetMessage(msg);
                this.controller().sendXNetMessage(msg, this);
            }
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        if (!this.getCanRead()) {
            this.notifyProgListenerEnd(p, CV, 8);
            return;
        }
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 1;
        this._cv = 0xFFFF & CV;
        try {
            this.restartTimer(90000);
            if (this.getMode() == ProgrammingMode.PAGEMODE) {
                XNetMessage msg = XNetMessage.getReadPagedCVMsg(CV);
                msg.setNeededMode(1);
                this.lastRequestMessage = new XNetMessage(msg);
                this.controller().sendXNetMessage(msg, this);
            } else if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
                XNetMessage msg = XNetMessage.getReadDirectCVMsg(CV);
                msg.setNeededMode(1);
                this.lastRequestMessage = new XNetMessage(msg);
                this.controller().sendXNetMessage(msg, this);
            } else {
                XNetMessage msg = XNetMessage.getReadRegisterMsg(this.registerFromCV(CV));
                msg.setNeededMode(1);
                this.lastRequestMessage = new XNetMessage(msg);
                this.controller().sendXNetMessage(msg, this);
            }
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void message(XNetReply m) {
        if (m.getElement(0) == 97 && m.getElement(1) == 2) {
            if (!this._service_mode) {
                log.debug("change _service_mode to true");
                this._service_mode = true;
            } else {
                log.debug("_service_mode already true");
                return;
            }
        }
        if (m.getElement(0) == 97 && m.getElement(1) == 1) {
            if (this._service_mode) {
                log.debug("change _service_mode to false");
                this._service_mode = false;
            } else {
                log.debug("_service_mode already false");
                return;
            }
        }
        if (this.progState != 0) {
            if (this.progState == 1) {
                log.debug("reply in REQUESTSENT state");
                if (this._service_mode && m.isOkMessage() || m.getElement(0) == 97 && (m.getElement(1) == 2 || m.getElement(1) == 17)) {
                    this.stopTimer();
                    if (!this.getCanRead()) {
                        this.restartTimer(this.SHORT_TIMEOUT);
                        return;
                    }
                    this.progState = 2;
                    this.restartTimer(90000);
                    this.controller().sendXNetMessage(XNetMessage.getServiceModeResultsMsg(), this);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 130) {
                    this.progState = 3;
                    this._error = 8;
                    this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 1) {
                    log.debug("Service mode exited before sequence complete.");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 512);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 18) {
                    log.error("Short Circuit While Programming Decoder");
                    this.progState = 3;
                    this._error = 256;
                    this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                } else if (m.isCommErrorMessage() && m.getElement(1) != 5) {
                    if (!this._service_mode) {
                        log.error("Communications error in REQUESTSENT state before entering service mode.  Error: {}", (Object)m);
                        this.controller().sendXNetMessage(this.lastRequestMessage, this);
                    } else {
                        log.error("Communications error in REQUESTSENT state after entering service mode.  Error: {}", (Object)m);
                        this.progState = 3;
                        this._error = 1024;
                        this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                    }
                }
            } else if (this.progState == 2) {
                log.debug("reply in INQUIRESENT state");
                if (m.isPagedModeResponse()) {
                    try {
                        if (m.getServiceModeCVNumber() != this._cv && m.getServiceModeCVNumber() != this.registerFromCV(this._cv)) {
                            log.debug(" result for CV {} expecting {}", (Object)m.getServiceModeCVNumber(), (Object)this._cv);
                            return;
                        }
                    }
                    catch (ProgrammerException programmerException) {
                        this.progState = 0;
                        this.notifyProgListenerEnd(this._val, 1);
                    }
                    if (this._progRead) {
                        this._val = m.getServiceModeCVValue();
                    }
                    this.progState = 3;
                    this._error = 0;
                    this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                } else if (m.isDirectModeResponse()) {
                    if (m.getServiceModeCVNumber() != this._cv) {
                        log.debug(" result for CV {} expecting {}", (Object)m.getServiceModeCVNumber(), (Object)this._cv);
                        return;
                    }
                    if (this._progRead) {
                        this._val = m.getServiceModeCVValue();
                    }
                    this.progState = 3;
                    this._error = 0;
                    this.stopTimer();
                    this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 19) {
                    this.progState = 3;
                    this._error = 2;
                    this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 18) {
                    log.error("Short Circuit While Programming Decoder");
                    this.progState = 3;
                    this._error = 256;
                    this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 1) {
                    log.error("Service mode exited before sequence complete.");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 512);
                } else if (m.isCommErrorMessage() && m.getElement(1) != 5) {
                    if (this._service_mode) {
                        log.error("Communications error in INQUIRESENT state while in service mode.  Error: {}", (Object)m);
                        this.controller().sendXNetMessage(XNetMessage.getServiceModeResultsMsg(), this);
                    } else {
                        log.error("Communications error in INQUIRESENT state after exiting service mode.  Error: {}", (Object)m);
                        this.progState = 3;
                        this._error = 1024;
                        this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
                    }
                }
            } else if (this.progState == 3) {
                log.debug("reply in RETURNSENT state");
                if (m.getElement(0) == 97 && m.getElement(1) == 1) {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, this._error);
                }
            } else {
                log.debug("reply in un-decoded state");
            }
        }
    }

    @Override
    public synchronized void message(XNetMessage l) {
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            log.debug("timeout!");
            this.progState = 3;
            this._error = !this.getCanRead() ? 0 : 128;
            this.controller().sendXNetMessage(XNetMessage.getExitProgModeMsg(), this);
        }
    }
}

