/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz.hornbyelite;

import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetProgrammer;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EliteXNetProgrammer
extends XNetProgrammer {
    private static final int ELITEMESSAGETIMEOUT = 10000;
    private static final int EliteXNetProgrammerTimeout = 20000;
    private static final Logger log = LoggerFactory.getLogger(EliteXNetProgrammer.class);

    public EliteXNetProgrammer(XNetTrafficController tc) {
        super(tc);
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 1;
        this._val = val;
        this._cv = 0xFFFF & CV;
        try {
            this.restartTimer(20000);
            if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
                XNetMessage msg = XNetMessage.getWritePagedCVMsg(CV, val);
                msg.setNeededMode(1);
                msg.setTimeout(10000);
                this.controller().sendXNetMessage(msg, this);
            } else if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
                XNetMessage msg = XNetMessage.getWriteDirectCVMsg(CV, val);
                msg.setNeededMode(1);
                msg.setTimeout(10000);
                this.controller().sendXNetMessage(msg, this);
            } else {
                XNetMessage msg = XNetMessage.getWriteRegisterMsg(this.registerFromCV(CV), val);
                msg.setNeededMode(1);
                msg.setTimeout(10000);
                this.controller().sendXNetMessage(msg, this);
            }
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        if (!this.getCanRead()) {
            this.notifyProgListenerEnd(p, CV, 8);
            return;
        }
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 1;
        this._cv = 0xFFFF & CV;
        try {
            this.restartTimer(20000);
            if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
                XNetMessage msg = XNetMessage.getReadPagedCVMsg(CV);
                msg.setNeededMode(1);
                msg.setTimeout(10000);
                this.controller().sendXNetMessage(msg, this);
            } else if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
                XNetMessage msg = XNetMessage.getReadDirectCVMsg(CV);
                msg.setNeededMode(1);
                msg.setTimeout(10000);
                this.controller().sendXNetMessage(msg, this);
            } else {
                XNetMessage msg = XNetMessage.getReadRegisterMsg(this.registerFromCV(CV));
                msg.setNeededMode(1);
                msg.setTimeout(10000);
                this.controller().sendXNetMessage(msg, this);
            }
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void message(XNetReply m) {
        if (m.getElement(0) == 97 && m.getElement(1) == 2) {
            if (!this._service_mode) {
                this._service_mode = true;
            } else {
                return;
            }
        }
        if (m.getElement(0) == 97 && m.getElement(1) == 1) {
            if (this._service_mode) {
                this._service_mode = false;
            } else {
                return;
            }
        }
        if (this.progState != 0) {
            if (this.progState == 1) {
                log.debug("reply in REQUESTSENT state");
                if (this._service_mode && m.isOkMessage() || m.getElement(0) == 97 && (m.getElement(1) == 2 || m.getElement(1) == 17)) {
                    this.stopTimer();
                    if (!this.getCanRead()) {
                        log.debug("CV reading not supported, exiting REQUESTSENT state");
                        this.stopTimer();
                        this.notifyProgListenerEnd(this._val, 0);
                    }
                } else if (m.getElement(0) == 97 && m.getElement(1) == 130) {
                    this.progState = 0;
                    this.notifyProgListenerEnd(this._val, 8);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 1) {
                    this.progState = 2;
                    this.restartTimer(20000);
                    XNetMessage resultMsg = XNetMessage.getServiceModeResultsMsg();
                    resultMsg.setNeededMode(1);
                    resultMsg.setTimeout(10000);
                    this.controller().sendXNetMessage(resultMsg, this);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 18) {
                    log.error("Short Circuit While Programming Decoder");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 256);
                } else if (m.isCommErrorMessage()) {
                    if (m.getElement(1) == 5) {
                        return;
                    }
                    log.error("Communications error in REQUESTSENT state while programming.  Error: {}", (Object)m);
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 1024);
                }
            } else if (this.progState == 2) {
                log.debug("reply in INQUIRESENT state");
                if (m.isPagedModeResponse()) {
                    try {
                        if (m.getServiceModeCVNumber() != this._cv && m.getServiceModeCVNumber() != this.registerFromCV(this._cv)) {
                            log.debug(" result for CV {} expecting {}", (Object)m.getServiceModeCVNumber(), (Object)this._cv);
                            return;
                        }
                    }
                    catch (ProgrammerException programmerException) {
                        this.progState = 0;
                        this.notifyProgListenerEnd(this._val, 1);
                    }
                    if (this._progRead) {
                        this._val = m.getServiceModeCVValue();
                    }
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 0);
                } else if (m.isDirectModeResponse()) {
                    if (m.getServiceModeCVNumber() != this._cv) {
                        log.debug(" result for CV {} expecting {}", (Object)m.getServiceModeCVNumber(), (Object)this._cv);
                        return;
                    }
                    if (this._progRead) {
                        this._val = m.getServiceModeCVValue();
                    }
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 0);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 19) {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 2);
                } else if (m.getElement(0) == 97 && m.getElement(1) == 18) {
                    log.error("Short Circuit While Programming Decoder");
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 256);
                } else if (m.isCommErrorMessage()) {
                    if (m.getElement(1) == 5) {
                        return;
                    }
                    log.error("Communications error in INQUIRESENT state while programming.  Error: {}", (Object)m);
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 1024);
                }
            } else {
                log.debug("reply in un-decoded state");
            }
        }
    }

    @Override
    public synchronized void message(XNetMessage l) {
    }
}

