/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.XNetAddress;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.XNetTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetTurnoutManager
extends AbstractTurnoutManager
implements XNetListener {
    protected XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(XNetTurnoutManager.class);

    public XNetTurnoutManager(XNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getXNetTrafficController();
        this.tc.getFeedbackMessageCache();
        this.tc.addXNetListener(8, this);
    }

    @Override
    @Nonnull
    public XNetSystemConnectionMemo getMemo() {
        return (XNetSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = XNetAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum == -1) {
            throw new IllegalArgumentException("Cannot get Bit from System Name " + systemName);
        }
        XNetTurnout t = new XNetTurnout(this.getSystemPrefix(), bitNum, this.tc);
        t.setUserName(userName);
        return t;
    }

    @Override
    public void message(XNetReply l) {
        if (log.isDebugEnabled()) {
            log.debug("received message: {}", (Object)l);
        }
        if (l.isFeedbackBroadcastMessage()) {
            int numDataBytes = l.getElement(0) & 0xF;
            int i = 1;
            while (i < numDataBytes) {
                int addr = l.getTurnoutMsgAddr(i);
                if (addr >= 0) {
                    log.debug("message has address: {}", (Object)addr);
                    String s = String.valueOf(this.getSystemNamePrefix()) + addr;
                    this.forwardMessageToTurnout(s, l);
                    if (addr % 2 != 0) {
                        s = String.valueOf(this.getSystemNamePrefix()) + (addr + 1);
                        this.forwardMessageToTurnout(s, l);
                    }
                }
                i += 2;
            }
        }
    }

    protected void forwardMessageToTurnout(String s, XNetReply l) {
        XNetTurnout t = (XNetTurnout)this.getBySystemName(s);
        if (t == null) {
            ((XNetTurnout)this.provideTurnout(s)).initmessage(l);
        } else {
            t.message(l);
        }
    }

    @Override
    @Nonnull
    public String getClosedText() {
        return Bundle.getMessage("TurnoutStateClosed");
    }

    @Override
    @Nonnull
    public String getThrownText() {
        return Bundle.getMessage("TurnoutStateThrown");
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {}", (Object)msg);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(name, 1, 1024, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return XNetAddress.validSystemNameFormat(systemName, 'T', this.getSystemPrefix());
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

